/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.factories;

import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.factories.ComponentFactory;
import org.jboss.cache.factories.annotations.DefaultFactoryFor;
import org.jboss.cache.factories.context.ContextFactory;
import org.jboss.cache.factories.context.MVCCContextFactory;
import org.jboss.cache.factories.context.OptimisticContextFactory;
import org.jboss.cache.factories.context.PessimisticContextFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DefaultFactoryFor(classes={ContextFactory.class})
public class ContextMetaFactory
extends ComponentFactory {
    @Override
    protected <T> T construct(Class<T> componentType) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Cache configuration is " + (Object)((Object)this.configuration.getNodeLockingScheme())));
        }
        switch (this.configuration.getNodeLockingScheme()) {
            case MVCC: {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"Creating an MVCC context factory");
                }
                return componentType.cast(new MVCCContextFactory());
            }
            case OPTIMISTIC: {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"Creating an optimistic context factory");
                }
                return componentType.cast(new OptimisticContextFactory());
            }
            case PESSIMISTIC: {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"Creating a pessimistic context factory");
                }
                return componentType.cast(new PessimisticContextFactory());
            }
        }
        throw new ConfigurationException("Unknown configuration node locking scheme");
    }
}

