/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config;

import java.util.concurrent.ExecutorService;
import javax.transaction.TransactionManager;
import org.jboss.cache.RPCManager;
import org.jboss.cache.buddyreplication.BuddyGroup;
import org.jboss.cache.config.ConfigurationComponent;
import org.jboss.cache.util.Util;
import org.jgroups.Channel;
import org.jgroups.ChannelFactory;
import org.jgroups.util.ThreadFactory;

public class RuntimeConfig
extends ConfigurationComponent {
    private static final long serialVersionUID = 5626847485703341794L;
    private transient TransactionManager transactionManager;
    private transient Channel channel;
    private transient ChannelFactory muxChannelFactory;
    private transient BuddyGroup buddyGroup;
    private RPCManager rpcManager;
    private transient ThreadFactory evictionTimerThreadFactory;
    private transient ExecutorService asyncSerializationExecutor;
    private transient ExecutorService asyncCacheListenerExecutor;

    public void reset() {
        this.channel = null;
        this.rpcManager = null;
    }

    public ChannelFactory getMuxChannelFactory() {
        return this.muxChannelFactory;
    }

    public void setMuxChannelFactory(ChannelFactory multiplexerChannelFactory) {
        this.testImmutability("muxChannelFactory");
        this.muxChannelFactory = multiplexerChannelFactory;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.testImmutability("transactionManager");
        this.transactionManager = transactionManager;
    }

    public ThreadFactory getEvictionTimerThreadFactory() {
        return this.evictionTimerThreadFactory;
    }

    public void setEvictionTimerThreadFactory(ThreadFactory evictionTimerThreadFactory) {
        this.evictionTimerThreadFactory = evictionTimerThreadFactory;
    }

    public ExecutorService getAsyncSerializationExecutor() {
        return this.asyncSerializationExecutor;
    }

    public void setAsyncSerializationExecutor(ExecutorService asyncSerializationExecutor) {
        this.asyncSerializationExecutor = asyncSerializationExecutor;
    }

    public ExecutorService getAsyncCacheListenerExecutor() {
        return this.asyncCacheListenerExecutor;
    }

    public void setAsyncCacheListenerExecutor(ExecutorService asyncCacheListenerExecutor) {
        this.asyncCacheListenerExecutor = asyncCacheListenerExecutor;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RuntimeConfig) {
            RuntimeConfig other = (RuntimeConfig)obj;
            return Util.safeEquals(this.transactionManager, other.transactionManager) && Util.safeEquals(this.muxChannelFactory, other.muxChannelFactory) && Util.safeEquals(this.rpcManager, other.rpcManager) && Util.safeEquals(this.channel, other.channel) && Util.safeEquals(this.evictionTimerThreadFactory, other.evictionTimerThreadFactory) && Util.safeEquals(this.asyncCacheListenerExecutor, other.asyncCacheListenerExecutor) && Util.safeEquals(this.asyncSerializationExecutor, other.asyncSerializationExecutor);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = result * 29 + (this.transactionManager == null ? 0 : this.transactionManager.hashCode());
        result = result * 29 + (this.muxChannelFactory == null ? 0 : this.muxChannelFactory.hashCode());
        result = result * 29 + (this.rpcManager == null ? 0 : this.rpcManager.hashCode());
        result = result * 29 + (this.channel == null ? 0 : this.channel.hashCode());
        result = result * 29 + (this.evictionTimerThreadFactory == null ? 0 : this.evictionTimerThreadFactory.hashCode());
        result = result * 29 + (this.asyncCacheListenerExecutor == null ? 0 : this.asyncCacheListenerExecutor.hashCode());
        result = result * 29 + (this.asyncSerializationExecutor == null ? 0 : this.asyncSerializationExecutor.hashCode());
        return result;
    }

    public void setBuddyGroup(BuddyGroup buddyGroup) {
        this.buddyGroup = buddyGroup;
    }

    public BuddyGroup getBuddyGroup() {
        return this.buddyGroup;
    }

    public void setRPCManager(RPCManager rpcManager) {
        this.rpcManager = rpcManager;
    }

    public RPCManager getRPCManager() {
        return this.rpcManager;
    }

    public RuntimeConfig clone() throws CloneNotSupportedException {
        return (RuntimeConfig)super.clone();
    }
}

