/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.write;

import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.InternalNode;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.Visitor;
import org.jboss.cache.commands.WriteCommand;
import org.jboss.cache.commands.read.AbstractDataCommand;
import org.jboss.cache.notifications.Notifier;
import org.jboss.cache.transaction.GlobalTransaction;

public class MoveCommand
extends AbstractDataCommand
implements WriteCommand {
    public static final int METHOD_ID = 36;
    protected static final Log log = LogFactory.getLog(MoveCommand.class);
    protected static final boolean trace = log.isTraceEnabled();
    protected Notifier notifier;
    protected Fqn to;
    protected GlobalTransaction globalTransaction;

    public MoveCommand() {
    }

    public void initialize(Notifier notifier, DataContainer dataContainer) {
        this.notifier = notifier;
        this.dataContainer = dataContainer;
    }

    public MoveCommand(Fqn from, Fqn to) {
        this.fqn = from;
        this.to = to;
    }

    public GlobalTransaction getGlobalTransaction() {
        return this.globalTransaction;
    }

    public void setGlobalTransaction(GlobalTransaction globalTransaction) {
        this.globalTransaction = globalTransaction;
    }

    public Object perform(InvocationContext ctx) {
        if (this.fqn.isDirectChildOf(this.to)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Attempting to move " + this.fqn + " onto itself.  Nothing to do."));
            }
            return null;
        }
        NodeSPI node = ctx.lookUpNode(this.fqn);
        if (node == null || node.isDeleted()) {
            if (trace) {
                log.trace((Object)("Node " + this.fqn + " does not exist when attempting to move node!  Not doing anything."));
            }
            return null;
        }
        if (trace) {
            log.trace((Object)("Moving " + this.fqn + " to sit under " + this.to));
        }
        NodeSPI newNode = ctx.lookUpNode(Fqn.fromRelativeElements(this.to, this.fqn.getLastElement()));
        Fqn newNodeFqn = newNode.getFqn();
        this.notifier.notifyNodeMoved(this.fqn, newNodeFqn, true, ctx);
        this.moveRecursively(node, newNode, ctx);
        this.notifier.notifyNodeMoved(this.fqn, newNodeFqn, false, ctx);
        return null;
    }

    private void moveRecursively(NodeSPI oldNode, NodeSPI newNode, InvocationContext ctx) {
        ConcurrentMap children;
        if (trace) {
            log.trace((Object)("Moving " + oldNode.getFqn() + " to " + newNode.getFqn()));
        }
        if (!(children = oldNode.getDelegationTarget().getChildrenMap()).isEmpty()) {
            for (InternalNode child : children.values()) {
                Fqn childFqn = child.getFqn();
                Fqn newChildFqn = childFqn.replaceAncestor(oldNode.getFqn(), newNode.getFqn());
                this.moveRecursively(ctx.lookUpNode(childFqn), ctx.lookUpNode(newChildFqn), ctx);
            }
        }
        newNode.getDelegationTarget().putAll(oldNode.getDelegationTarget().getData());
        oldNode.markAsDeleted(true);
    }

    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitMoveCommand(ctx, this);
    }

    public Fqn getTo() {
        return this.to;
    }

    public int getCommandId() {
        return 36;
    }

    public Object[] getParameters() {
        return new Object[]{this.fqn, this.to};
    }

    public void setParameters(int commandId, Object[] args) {
        this.fqn = (Fqn)args[0];
        this.to = (Fqn)args[1];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MoveCommand that = (MoveCommand)o;
        return !(this.to != null ? !this.to.equals(that.to) : that.to != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.to != null ? this.to.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "MoveCommand{fqn=" + this.fqn + ", to=" + this.to + '}';
    }
}

