/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.remote;

import java.util.Arrays;
import java.util.Map;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.buddyreplication.BuddyGroup;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.commands.ReplicableCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignToBuddyGroupCommand
implements ReplicableCommand {
    public static final int METHOD_ID = 29;
    private BuddyManager buddyManager;
    private BuddyGroup group;
    private Map<Fqn, byte[]> state;

    public AssignToBuddyGroupCommand(BuddyGroup group, Map<Fqn, byte[]> state) {
        this.group = group;
        this.state = state;
    }

    public AssignToBuddyGroupCommand() {
    }

    public void initialize(BuddyManager manager) {
        this.buddyManager = manager;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        if (this.buddyManager != null) {
            this.buddyManager.handleAssignToBuddyGroup(this.group, this.state);
        }
        return null;
    }

    @Override
    public int getCommandId() {
        return 29;
    }

    public BuddyGroup getGroup() {
        return this.group;
    }

    public Map<Fqn, byte[]> getState() {
        return this.state;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.group, this.state};
    }

    @Override
    public void setParameters(int commandId, Object[] args) {
        this.group = (BuddyGroup)args[0];
        this.state = (Map)args[1];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssignToBuddyGroupCommand that = (AssignToBuddyGroupCommand)o;
        if (this.group != null ? !this.group.equals(that.group) : that.group != null) {
            return false;
        }
        return !(this.state != null ? !((Object)this.state).equals(that.state) : that.state != null);
    }

    public int hashCode() {
        int result = this.group != null ? this.group.hashCode() : 0;
        result = 31 * result + (this.state != null ? ((Object)this.state).hashCode() : 0);
        return result;
    }

    public String toString() {
        return "AssignToBuddyGroupCommand{buddyManager=" + this.buddyManager + ", group=" + this.group + ", state=" + (this.state == null ? null : Arrays.asList(this.state)) + '}';
    }
}

