/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.protocol.core.impl.PacketImpl;

public class SessionForceConsumerDelivery
extends PacketImpl {
    private long consumerID;
    private long sequence;

    public SessionForceConsumerDelivery(long consumerID, long sequence) {
        super((byte)78);
        this.consumerID = consumerID;
        this.sequence = sequence;
    }

    public SessionForceConsumerDelivery() {
        super((byte)78);
    }

    public long getConsumerID() {
        return this.consumerID;
    }

    public long getSequence() {
        return this.sequence;
    }

    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeLong(this.consumerID);
        buffer.writeLong(this.sequence);
    }

    public void decodeRest(HornetQBuffer buffer) {
        this.consumerID = buffer.readLong();
        this.sequence = buffer.readLong();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getParentString());
        buf.append(", consumerID=" + this.consumerID);
        buf.append(", sequence=" + this.sequence);
        buf.append("]");
        return buf.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof SessionForceConsumerDelivery)) {
            return false;
        }
        SessionForceConsumerDelivery r = (SessionForceConsumerDelivery)other;
        return super.equals(other) && this.consumerID == r.consumerID && this.sequence == r.sequence;
    }
}

