/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.protocol.core.impl.PacketImpl;

public class SessionConsumerFlowCreditMessage
extends PacketImpl {
    private long consumerID;
    private int credits;

    public SessionConsumerFlowCreditMessage(long consumerID, int credits) {
        super((byte)70);
        this.consumerID = consumerID;
        this.credits = credits;
    }

    public SessionConsumerFlowCreditMessage() {
        super((byte)70);
    }

    public long getConsumerID() {
        return this.consumerID;
    }

    public int getCredits() {
        return this.credits;
    }

    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeLong(this.consumerID);
        buffer.writeInt(this.credits);
    }

    public void decodeRest(HornetQBuffer buffer) {
        this.consumerID = buffer.readLong();
        this.credits = buffer.readInt();
    }

    public String toString() {
        return this.getParentString() + ", consumerID=" + this.consumerID + ", credits=" + this.credits + "]";
    }

    public boolean equals(Object other) {
        if (!(other instanceof SessionConsumerFlowCreditMessage)) {
            return false;
        }
        SessionConsumerFlowCreditMessage r = (SessionConsumerFlowCreditMessage)other;
        return super.equals(other) && this.credits == r.credits && this.consumerID == r.consumerID;
    }
}

