/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.journal.JournalLoadInformation;
import org.hornetq.core.protocol.core.impl.PacketImpl;

public class ReplicationCompareDataMessage
extends PacketImpl {
    private JournalLoadInformation[] journalInformation;

    public ReplicationCompareDataMessage(JournalLoadInformation[] journalInformation) {
        super((byte)102);
        this.journalInformation = journalInformation;
    }

    public ReplicationCompareDataMessage() {
        super((byte)102);
    }

    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeInt(this.journalInformation.length);
        for (JournalLoadInformation info : this.journalInformation) {
            buffer.writeInt(info.getNumberOfRecords());
            buffer.writeLong(info.getMaxID());
        }
    }

    public void decodeRest(HornetQBuffer buffer) {
        int numberOfJournals = buffer.readInt();
        this.journalInformation = new JournalLoadInformation[numberOfJournals];
        for (int i = 0; i < numberOfJournals; ++i) {
            this.journalInformation[i] = new JournalLoadInformation();
            this.journalInformation[i].setNumberOfRecords(buffer.readInt());
            this.journalInformation[i].setMaxID(buffer.readLong());
        }
    }

    public JournalLoadInformation[] getJournalInformation() {
        return this.journalInformation;
    }
}

