/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.formatter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.internal.formatter.CodeFormatterVisitor2;

public class InfixExpressionWrappingBuilder
extends ASTVisitor {
    private static final int DEFAULT_SIZE = 10;
    ArrayList fragments = new ArrayList();
    int[] operators = new int[10];
    int operatorCounter = 0;

    public int getFragmentsCounter() {
        return this.fragments.size();
    }

    public int[] getOperators() {
        if (this.operators.length != this.operatorCounter) {
            this.operators = new int[this.operatorCounter];
            System.arraycopy(this.operators, 0, this.operators, 0, this.operatorCounter);
        }
        return this.operators;
    }

    private boolean isSplittable(Expression expression) {
        return true;
    }

    public boolean visit(InfixExpression node) {
        Expression leftOperand = node.getLeftOperand();
        Expression rightOperand = node.getRightOperand();
        if (leftOperand.getNodeType() == 27 && this.isSplittable(leftOperand)) {
            leftOperand.accept(this);
        } else {
            this.fragments.add(leftOperand);
        }
        if (this.operatorCounter == this.operators.length) {
            this.operators = new int[this.operatorCounter * 2];
            System.arraycopy(this.operators, 0, this.operators, 0, this.operatorCounter);
        }
        int extractInfixExpressionOperator = CodeFormatterVisitor2.extractInfixExpressionOperator(node);
        this.operators[this.operatorCounter++] = extractInfixExpressionOperator;
        if (rightOperand.getNodeType() == 27 && this.isSplittable(leftOperand)) {
            rightOperand.accept(this);
        } else {
            this.fragments.add(rightOperand);
        }
        List extendedOperands = node.extendedOperands();
        int extendedOperandsLength = extendedOperands.size();
        if (extendedOperandsLength != 0) {
            int i = 0;
            while (i < extendedOperandsLength) {
                if (this.operatorCounter == this.operators.length) {
                    this.operators = new int[this.operatorCounter * 2];
                    System.arraycopy(this.operators, 0, this.operators, 0, this.operatorCounter);
                }
                this.operators[this.operatorCounter++] = extractInfixExpressionOperator;
                Expression extendedOperand = (Expression)extendedOperands.get(i);
                if (extendedOperand instanceof InfixExpression) {
                    extendedOperand.accept(this);
                } else {
                    this.fragments.add(extendedOperand);
                }
                ++i;
            }
        }
        return false;
    }
}

