/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateless;

import java.rmi.RemoteException;
import javax.ejb.EJBException;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.EJBContainerInvocation;
import org.jboss.ejb3.aop.AbstractInterceptor;
import org.jboss.ejb3.pool.Pool;
import org.jboss.ejb3.stateful.StatefulRemoveInterceptor;
import org.jboss.logging.Logger;

public class StatelessInstanceInterceptor
extends AbstractInterceptor {
    private static final Logger log = Logger.getLogger(StatelessInstanceInterceptor.class);

    @Override
    public String getName() {
        return "StatelessInstanceInterceptor";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        EJBContainerInvocation ejb = (EJBContainerInvocation)invocation;
        Object container = StatelessInstanceInterceptor.getEJBContainer(invocation);
        Pool pool = ((EJBContainer)container).getPool();
        BeanContext<?> ctx = pool.get();
        assert (ctx != null) : "pool returned null instance";
        ejb.setBeanContext(ctx);
        ((EJBContainer)container).pushContext(ctx);
        boolean discard = false;
        try {
            Object object = ejb.invokeNext();
            return object;
        }
        catch (Exception ex) {
            discard = ex instanceof EJBException || (ex instanceof RuntimeException || ex instanceof RemoteException) && !StatefulRemoveInterceptor.isApplicationException(ex, (MethodInvocation)invocation);
            throw ex;
        }
        finally {
            ((EJBContainer)container).popContext();
            ejb.setBeanContext(null);
            if (discard) {
                pool.discard(ctx);
            } else {
                pool.release(ctx);
            }
        }
    }
}

