/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TObjectDoubleHashMap;
import gnu.trove.TObjectDoubleIterator;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TObjectDoubleHashMapDecorator
extends AbstractMap
implements Map {
    protected final TObjectDoubleHashMap _map;

    public TObjectDoubleHashMapDecorator(TObjectDoubleHashMap map) {
        this._map = map;
    }

    public Object put(Object key, Object value) {
        return this.wrapValue(this._map.put(this.unwrapKey(key), this.unwrapValue(value)));
    }

    @Override
    public boolean equals(Object other) {
        if (this._map.equals(other)) {
            return true;
        }
        if (other instanceof Map) {
            Map that = (Map)other;
            if (that.size() != this._map.size()) {
                return false;
            }
            Iterator it = that.entrySet().iterator();
            int i = that.size();
            while (i-- > 0) {
                Map.Entry e = it.next();
                Object key = e.getKey();
                Object val = e.getValue();
                if (key instanceof Integer && val instanceof Integer) {
                    Object k = this.unwrapKey(key);
                    double v = this.unwrapValue(val);
                    if (this._map.containsKey(k) && v == this._map.get(k)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public Object get(Object key) {
        Object k = this.unwrapKey(key);
        double v = this._map.get(k);
        if (v == 0.0) {
            return this._map.containsKey(k) ? this.wrapValue(v) : null;
        }
        return this.wrapValue(v);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    public Object remove(Object key) {
        return this.wrapValue(this._map.remove(this.unwrapKey(key)));
    }

    public Set entrySet() {
        return new AbstractSet(){

            @Override
            public int size() {
                return TObjectDoubleHashMapDecorator.this._map.size();
            }

            @Override
            public boolean isEmpty() {
                return TObjectDoubleHashMapDecorator.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Object k = ((Map.Entry)o).getKey();
                    Object v = ((Map.Entry)o).getValue();
                    return TObjectDoubleHashMapDecorator.this.containsKey(k) && TObjectDoubleHashMapDecorator.this.get(k).equals(v);
                }
                return false;
            }

            @Override
            public Iterator iterator() {
                return new Iterator(){
                    private final TObjectDoubleIterator it;
                    {
                        this.it = TObjectDoubleHashMapDecorator.this._map.iterator();
                    }

                    public Object next() {
                        this.it.advance();
                        final Object key = TObjectDoubleHashMapDecorator.this.wrapKey(this.it.key());
                        final Double v = TObjectDoubleHashMapDecorator.this.wrapValue(this.it.value());
                        return new Map.Entry(){
                            private Object val;
                            {
                                this.val = v;
                            }

                            @Override
                            public boolean equals(Object o) {
                                return o instanceof Map.Entry && ((Map.Entry)o).getKey().equals(key) && ((Map.Entry)o).getValue().equals(this.val);
                            }

                            public Object getKey() {
                                return key;
                            }

                            public Object getValue() {
                                return this.val;
                            }

                            @Override
                            public int hashCode() {
                                return key.hashCode() + this.val.hashCode();
                            }

                            public Object setValue(Object value) {
                                this.val = value;
                                return TObjectDoubleHashMapDecorator.this.put(key, value);
                            }
                        };
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }

            @Override
            public boolean add(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                TObjectDoubleHashMapDecorator.this.clear();
            }
        };
    }

    @Override
    public boolean containsValue(Object val) {
        return this._map.containsValue(this.unwrapValue(val));
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(this.unwrapKey(key));
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void putAll(Map map) {
        Iterator it = map.entrySet().iterator();
        int i = map.size();
        while (i-- > 0) {
            Map.Entry e = it.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    protected final Object wrapKey(Object o) {
        return o;
    }

    protected final Object unwrapKey(Object key) {
        return key;
    }

    protected Double wrapValue(double k) {
        return new Double(k);
    }

    protected double unwrapValue(Object value) {
        return (Double)value;
    }
}

