/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;

public class TIntHashSetDecorator
extends AbstractSet
implements Set {
    protected final TIntHashSet _set;

    public TIntHashSetDecorator(TIntHashSet set) {
        this._set = set;
    }

    @Override
    public boolean add(Object value) {
        return this._set.add(this.unwrap(value));
    }

    @Override
    public boolean equals(Object other) {
        if (this._set.equals(other)) {
            return true;
        }
        if (other instanceof Set) {
            Set that = (Set)other;
            if (that.size() != this._set.size()) {
                return false;
            }
            Iterator it = that.iterator();
            int i = that.size();
            while (i-- > 0) {
                Object val = it.next();
                if (val instanceof Integer) {
                    int v = this.unwrap(val);
                    if (this._set.contains(v)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this._set.clear();
    }

    @Override
    public boolean remove(Object value) {
        return this._set.remove(this.unwrap(value));
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            private final TIntIterator it;
            {
                this.it = TIntHashSetDecorator.this._set.iterator();
            }

            public Object next() {
                return TIntHashSetDecorator.this.wrap(this.it.next());
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public void remove() {
                this.it.remove();
            }
        };
    }

    @Override
    public int size() {
        return this._set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    protected Integer wrap(int k) {
        return new Integer(k);
    }

    protected int unwrap(Object value) {
        return (Integer)value;
    }
}

