/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.jdk;

import java.util.ArrayList;
import java.util.EmptyStackException;
import org.jboss.logging.NDCProvider;

public class JDKNDCProvider
implements NDCProvider {
    private ThreadLocal<ArrayStack<Entry>> stack = new ThreadLocal();

    public void clear() {
        ArrayStack<Entry> stack = this.stack.get();
        if (stack != null) {
            stack.clear();
        }
    }

    public String get() {
        ArrayStack<Entry> stack = this.stack.get();
        return stack == null || stack.isEmpty() ? null : stack.peek().merged;
    }

    public int getDepth() {
        ArrayStack<Entry> stack = this.stack.get();
        return stack == null ? 0 : stack.size();
    }

    public String peek() {
        ArrayStack<Entry> stack = this.stack.get();
        return stack == null || stack.isEmpty() ? "" : stack.peek().current;
    }

    public String pop() {
        ArrayStack<Entry> stack = this.stack.get();
        return stack == null || stack.isEmpty() ? "" : stack.pop().current;
    }

    public void push(String message) {
        ArrayStack<Entry> stack = this.stack.get();
        if (stack == null) {
            stack = new ArrayStack();
            this.stack.set(stack);
        }
        stack.push(stack.isEmpty() ? new Entry(message) : new Entry(stack.peek(), message));
    }

    public void setMaxDepth(int maxDepth) {
        ArrayStack<Entry> stack = this.stack.get();
        if (stack != null) {
            stack.setSize(maxDepth);
        }
    }

    private class Entry {
        private String merged;
        private String current;

        public Entry(String current) {
            this.merged = current;
            this.current = current;
        }

        public Entry(Entry parent, String current) {
            this.merged = parent.merged + ' ' + current;
            this.current = current;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArrayStack<E>
    extends ArrayList<E> {
        private static final long serialVersionUID = -8520038422243642840L;

        private ArrayStack() {
        }

        public E pop() {
            int size = this.size();
            if (size == 0) {
                throw new EmptyStackException();
            }
            return this.remove(size - 1);
        }

        public E peek() {
            int size = this.size();
            if (size == 0) {
                throw new EmptyStackException();
            }
            return this.get(size - 1);
        }

        public void push(E val) {
            this.add(val);
        }

        public void setSize(int newSize) {
            int size = this.size();
            if (newSize >= size || newSize < 0) {
                return;
            }
            this.removeRange(newSize, size);
        }
    }
}

