/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.methods;

import org.apache.webdav.lib.methods.XMLResponseMethodBase;
import org.apache.webdav.lib.util.XMLPrinter;

public class UnbindMethod
extends XMLResponseMethodBase {
    public static final String NAME = "UNBIND";
    private String segment = null;

    public UnbindMethod() {
    }

    public UnbindMethod(String binding) {
        super(binding.substring(0, binding.lastIndexOf(47)));
        this.segment = binding.substring(binding.lastIndexOf(47) + 1);
    }

    public String getName() {
        return NAME;
    }

    protected String generateRequestBody() {
        if (this.segment == null) {
            throw new IllegalStateException("Segment must be set before calling this function.");
        }
        XMLPrinter printer = new XMLPrinter();
        printer.writeXMLHeader();
        printer.writeElement("D", "DAV:", "unbind", 0);
        printer.writeElement("D", "segment", 0);
        printer.writeText(this.segment);
        printer.writeElement("D", "segment", 1);
        printer.writeElement("D", "unbind", 1);
        return printer.toString();
    }

    public String getSegment() {
        return this.segment;
    }

    public void setSegment(String segment) {
        this.segment = segment;
    }
}

