/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.interceptors.dynamic;

import org.jboss.aop.proxy.ClassProxy;
import org.jboss.cache.Fqn;
import org.jboss.cache.pojo.PojoCacheAlreadyDetachedException;
import org.jboss.cache.pojo.impl.PojoCacheImpl;
import org.jboss.cache.pojo.impl.PojoInstance;
import org.jboss.cache.pojo.interceptors.dynamic.BaseInterceptor;
import org.jboss.cache.pojo.util.ObjectUtil;

public abstract class AbstractCollectionInterceptor
implements BaseInterceptor {
    Fqn fqn;
    PojoCacheImpl cache;
    ClassProxy boundProxy;
    private boolean attached_ = true;
    private PojoInstance pojoInstance_;

    AbstractCollectionInterceptor(PojoCacheImpl cache, Fqn fqn) {
        this.fqn = fqn;
        this.cache = cache;
    }

    public Fqn getFqn() {
        return this.fqn;
    }

    public void setFqn(Fqn fqn) {
        this.fqn = fqn;
    }

    public PojoInstance getAopInstance() {
        return this.pojoInstance_;
    }

    public void setAopInstance(PojoInstance pojoInstance) {
        this.pojoInstance_ = pojoInstance;
    }

    public void attach(Fqn fqn, boolean copyToCache) {
        if (fqn != null) {
            this.setFqn(fqn);
        }
        this.attached_ = true;
    }

    public void detach(boolean removeFromCache) {
        this.attached_ = false;
    }

    public boolean isAttached() {
        return this.attached_;
    }

    public void verifyAttached(Object target) {
        if (!this.isAttached()) {
            return;
        }
        if (this.cache.getCache().get(this.fqn, (Object)"POJOCache.PojoInstance") != null) {
            return;
        }
        String identity = ObjectUtil.identityString(target);
        throw new PojoCacheAlreadyDetachedException(identity + " has possibly been detached remotely. Internal id: " + this.fqn);
    }

    Object copyOrConstruct(Object mem) {
        if (mem instanceof Cloneable) {
            try {
                return mem.getClass().getMethod("clone", new Class[0]).invoke(mem, new Object[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            return mem.getClass().newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    abstract void setInMemoryCopy(Object var1);

    abstract Object getInMemoryCopy();

    public abstract Object getSerializationCopy();

    abstract void setCacheCopy(Object var1);

    abstract Object getCacheCopy();

    abstract void setCurrentCopy(Object var1);

    public abstract Object getCurrentCopy();

    public ClassProxy getBoundProxy() {
        return this.boundProxy;
    }

    public void setBoundProxy(ClassProxy boundProxy) {
        this.boundProxy = boundProxy;
    }
}

