/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.ejb.SessionBean;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.BigDecimalHolder;
import javax.xml.rpc.holders.BigIntegerHolder;
import javax.xml.rpc.holders.BooleanHolder;
import javax.xml.rpc.holders.BooleanWrapperHolder;
import javax.xml.rpc.holders.ByteArrayHolder;
import javax.xml.rpc.holders.ByteHolder;
import javax.xml.rpc.holders.ByteWrapperHolder;
import javax.xml.rpc.holders.CalendarHolder;
import javax.xml.rpc.holders.DoubleHolder;
import javax.xml.rpc.holders.DoubleWrapperHolder;
import javax.xml.rpc.holders.FloatHolder;
import javax.xml.rpc.holders.FloatWrapperHolder;
import javax.xml.rpc.holders.Holder;
import javax.xml.rpc.holders.IntHolder;
import javax.xml.rpc.holders.IntegerWrapperHolder;
import javax.xml.rpc.holders.LongHolder;
import javax.xml.rpc.holders.LongWrapperHolder;
import javax.xml.rpc.holders.ObjectHolder;
import javax.xml.rpc.holders.QNameHolder;
import javax.xml.rpc.holders.ShortHolder;
import javax.xml.rpc.holders.ShortWrapperHolder;
import javax.xml.rpc.holders.StringHolder;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.ws.WSException;
import org.jboss.ws.core.jaxrpc.ParameterWrapping;
import org.jboss.ws.core.utils.HolderUtils;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLTypes;
import org.jboss.ws.metadata.wsdl.XSModelTypes;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.wsf.common.JavaUtils;
import org.jboss.xb.binding.Util;

public class WSDLUtils {
    private String newline = "\n";
    private static WSDLUtils instance = new WSDLUtils();
    private List wrapperlist = null;
    private List primlist = null;
    private final Map primitiveMap = new HashMap();
    private static final Map<String, Class> schemaBasicTypes = new HashMap<String, Class>();
    private static final Map<Class, Class> holderTypes = new HashMap<Class, Class>();
    private static final Map<Class, Class> reverseHolderTypes = new HashMap<Class, Class>();
    private List<String> ignoredMethods;

    public static WSDLUtils getInstance() {
        return instance;
    }

    private WSDLUtils() {
        this.wrapperlist = new ArrayList();
        this.primlist = new ArrayList();
        this.populatePrimList();
        this.populateWrapperList();
        this.createPrimitiveMap();
    }

    public boolean isPrimitive(String str) {
        return this.primlist.contains(str);
    }

    public boolean isWrapper(String str) {
        return this.wrapperlist.contains(str);
    }

    public boolean isBaseTypeIgnorable(XSTypeDefinition baseType, XSComplexTypeDefinition t) {
        boolean bool = false;
        if (baseType != null && baseType.getNamespace() == "http://www.w3.org/2001/XMLSchema" && baseType.getName().equals("anyType")) {
            bool = true;
        }
        if (1 == t.getContentType()) {
            bool = true;
        }
        return bool;
    }

    public boolean checkIgnoreClass(Class cls) {
        if (cls == null) {
            throw new IllegalArgumentException("Illegal null argument:cls");
        }
        if (!cls.isArray()) {
            String pkgname;
            String string = pkgname = cls.getPackage() != null ? cls.getPackage().getName() : null;
            if (pkgname != null && pkgname.startsWith("java")) {
                return true;
            }
            if (ParameterWrapping.WrapperType.class.isAssignableFrom(cls)) {
                return true;
            }
        }
        return false;
    }

    public boolean checkIgnoreMethod(Method method) {
        String methodname = method.getName();
        if (this.ignoredMethods == null) {
            this.ignoredMethods = new ArrayList<String>();
            Method[] objMethods = Object.class.getMethods();
            for (int i = 0; i < objMethods.length; ++i) {
                this.ignoredMethods.add(objMethods[i].getName());
            }
            Method[] sbMethods = SessionBean.class.getMethods();
            for (int i = 0; i < sbMethods.length; ++i) {
                this.ignoredMethods.add(sbMethods[i].getName());
            }
        }
        boolean ignoreMethod = this.ignoredMethods.contains(methodname);
        if (method.getDeclaringClass().isAnnotationPresent(WebService.class) && !method.isAnnotationPresent(WebMethod.class)) {
            ignoreMethod = true;
        }
        return ignoreMethod;
    }

    public String chopPortType(String name) {
        int index = name.lastIndexOf("PortType");
        if (index > 0) {
            return name.substring(0, index);
        }
        return name;
    }

    public String chop(String name, String chopstr) {
        int index = name.lastIndexOf(chopstr);
        if (index > 0) {
            return name.substring(0, index);
        }
        return name;
    }

    public File createPackage(String path, String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException("Illegal Null Argument: packageName");
        }
        if (path == null) {
            throw new IllegalArgumentException("Illegal Null Argument: path");
        }
        String pac = packageName.replace('.', '/');
        File dir = new File(path + "/" + pac);
        dir.mkdirs();
        return dir;
    }

    public File createPhysicalFile(File loc, String fname) throws IOException {
        boolean boolCreate;
        if (loc == null) {
            throw new IllegalArgumentException("Illegal Null Argument: loc");
        }
        if (fname == null) {
            throw new IllegalArgumentException("Illegal Null Argument: fname");
        }
        File javaFile = new File(loc.getAbsolutePath() + "/" + fname + ".java");
        if (javaFile.exists()) {
            javaFile.delete();
        }
        if (!(boolCreate = javaFile.createNewFile())) {
            throw new WSException(fname + ".java cannot be created");
        }
        return javaFile;
    }

    public StringBuilder createClassBasicStructure(String pkgname, String fname, XSTypeDefinition type, List importList, String baseName) {
        StringBuilder buf = new StringBuilder();
        this.writeJbossHeader(buf);
        buf.append(this.newline);
        buf.append("package " + pkgname + ";");
        buf.append(this.newline);
        buf.append(this.newline);
        if (importList != null) {
            Iterator iter = importList.iterator();
            while (iter.hasNext()) {
                buf.append("import " + (String)iter.next() + ";");
                buf.append(this.newline);
            }
        }
        buf.append(this.newline);
        XSTypeDefinition baseType = null;
        if (type instanceof XSComplexTypeDefinition) {
            XSComplexTypeDefinition t = (XSComplexTypeDefinition)type;
            baseType = t.getBaseType();
            if (baseType != null && baseType.getNamespace() == "http://www.w3.org/2001/XMLSchema" && baseType.getName().equals("anyType")) {
                baseType = null;
            }
            if (1 == t.getContentType()) {
                baseType = null;
            }
        }
        buf.append("public class  " + fname);
        if (baseName == null && baseType != null) {
            baseName = baseType.getName();
        }
        if (baseName != null) {
            buf.append(" extends " + baseName);
        }
        buf.append(this.newline);
        buf.append("{");
        buf.append(this.newline);
        return buf;
    }

    public boolean doesPublicFieldExist(Class javaType, String name) {
        Field fld = null;
        try {
            fld = javaType.getField(name);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        int mod = fld.getModifiers();
        return mod == 1;
    }

    public String firstLetterUpperCase(String fname) {
        if (fname == null || fname.length() == 0) {
            throw new WSException("String passed is null");
        }
        char firstChar = fname.charAt(0);
        if (Character.isLowerCase(firstChar)) {
            StringBuilder sb = new StringBuilder(fname);
            sb.setCharAt(0, Character.toUpperCase(firstChar));
            fname = sb.toString();
        }
        return fname;
    }

    public int getArrayDimension(Class arr) {
        if (arr == null || !arr.isArray()) {
            throw new IllegalArgumentException("Illegal null or array arg:arr");
        }
        int counter = 0;
        while (arr.isArray()) {
            ++counter;
            arr = arr.getComponentType();
        }
        return counter;
    }

    public Class getHolder(Class cls) {
        return holderTypes.get(cls);
    }

    public Class getJavaTypeForHolder(Class cls) {
        if (Holder.class.isAssignableFrom(cls)) {
            return HolderUtils.getValueType(cls);
        }
        return cls;
    }

    public String getMessagePartForArray(Class javaType) {
        StringBuilder sb = new StringBuilder();
        while (javaType.isArray()) {
            sb.append("arrayOf");
            javaType = javaType.getComponentType();
        }
        sb.append(WSDLUtils.getJustClassName(javaType));
        return sb.toString();
    }

    public static String getJustClassName(Class cls) {
        if (cls == null) {
            return null;
        }
        if (cls.isArray()) {
            Class<?> c = cls.getComponentType();
            return WSDLUtils.getJustClassName(c.getName());
        }
        return WSDLUtils.getJustClassName(cls.getName());
    }

    public static String getJustClassName(String classname) {
        int index = classname.lastIndexOf(46);
        index = index < 0 ? 0 : ++index;
        return classname.substring(index);
    }

    public Field[] getPublicFields(Class cls) {
        ArrayList<Field> list = new ArrayList<Field>();
        Field[] fld = cls.getDeclaredFields();
        for (int i = 0; i < fld.length; ++i) {
            Field field = fld[i];
            int mod = field.getModifiers();
            if (mod != 1) continue;
            list.add(field);
        }
        Field[] retarr = new Field[list.size()];
        list.toArray(retarr);
        return retarr;
    }

    public Method[] getPublicProtectedMethods(Method[] methods) {
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method method : methods) {
            int mod = method.getModifiers();
            if (mod != 1 && mod != 4) continue;
            list.add(method);
        }
        Method[] retarr = new Method[list.size()];
        list.toArray(retarr);
        return retarr;
    }

    public Class getJavaType(QName xmlType) {
        if (xmlType == null) {
            return null;
        }
        String localPart = xmlType.getLocalPart();
        return schemaBasicTypes.get(localPart);
    }

    public String getMixedCase(String str) {
        if (str == null || str.length() == 0) {
            throw new IllegalArgumentException("String passed to WSDLUtils.getMixedCase is null");
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        char[] charr = str.toCharArray();
        charr[0] = Character.toUpperCase(charr[0]);
        return new String(charr);
    }

    public String getFormattedString(QName qn) {
        if (qn == null) {
            throw new IllegalArgumentException(" QName passed is null");
        }
        StringBuilder sb = new StringBuilder();
        String prefix = qn.getPrefix();
        String localpart = qn.getLocalPart();
        if (prefix == null || prefix.length() == 0) {
            prefix = "tns";
        }
        sb.append(prefix).append(':');
        sb.append(localpart);
        return sb.toString();
    }

    public QName getQName(String formattedStr) {
        QName qn = null;
        int ind = formattedStr.lastIndexOf(58);
        if (ind < 0) {
            throw new IllegalArgumentException("Formatted String is not of format prefix:localpart");
        }
        String prefix = formattedStr.substring(0, ind);
        String nsuri = null;
        if ("xsd".equals(prefix)) {
            nsuri = "http://www.w3.org/2001/XMLSchema";
        }
        qn = nsuri == null ? new QName(formattedStr.substring(ind + 1)) : new QName(nsuri, formattedStr.substring(ind + 1), prefix);
        return qn;
    }

    public String getPrimitive(String str) {
        return (String)this.primitiveMap.get(str);
    }

    public String getPackageName(String typeNS) {
        String pkgname = Util.xmlNamespaceToJavaPackage((String)typeNS);
        return pkgname;
    }

    public static String getTypeNamespace(Class javaType) {
        return WSDLUtils.getTypeNamespace(JavaUtils.getPackageName((Class)javaType));
    }

    public static String getTypeNamespace(String packageName) {
        String next;
        StringBuilder sb = new StringBuilder("http://");
        StringTokenizer st = new StringTokenizer(packageName, ".");
        Stack<String> stk = new Stack<String>();
        while (st != null && st.hasMoreTokens()) {
            stk.push(st.nextToken());
        }
        while (!stk.isEmpty() && (next = (String)stk.pop()) != null) {
            if (!sb.toString().equals("http://")) {
                sb.append('.');
            }
            sb.append(next);
        }
        sb.append('/');
        return sb.toString();
    }

    public String getWSDLStyle(WSDLDefinitions wsdl) {
        WSDLInterface wi = wsdl.getInterfaces()[0];
        WSDLInterfaceOperation wio = wi.getOperations()[0];
        String style = wio.getStyle();
        if (style == null || style.equals("http://www.w3.org/2004/03/wsdl/style/rpc") || "rpc".equalsIgnoreCase(style)) {
            return "RPC/Literal";
        }
        return "Document/Literal";
    }

    public static JBossXSModel getSchemaModel(WSDLTypes types) {
        if (types instanceof XSModelTypes) {
            return ((XSModelTypes)types).getSchemaModel();
        }
        throw new WSException("WSDLTypes is not an XSModelTypes");
    }

    public static void addSchemaModel(WSDLTypes types, String namespace, JBossXSModel model) {
        if (!(types instanceof XSModelTypes)) {
            throw new WSException("WSDLTypes is not an XSModelTypes");
        }
        XSModelTypes modelTypes = (XSModelTypes)types;
        modelTypes.addSchemaModel(namespace, model);
    }

    public boolean isStandardHolder(Class cls) {
        if (!Holder.class.isAssignableFrom(cls)) {
            return false;
        }
        return cls.getPackage().getName().startsWith("javax.xml.rpc");
    }

    public void writeJbossHeader(StringBuilder buf) {
        buf.append("/*").append(this.newline);
        buf.append(" * JBossWS WS-Tools Generated Source").append(this.newline);
        buf.append(" *").append(this.newline);
        buf.append(" * Generation Date: " + new Date() + this.newline);
        buf.append(" *").append(this.newline);
        buf.append(" * This generated source code represents a derivative work of the input to").append(this.newline);
        buf.append(" * the generator that produced it. Consult the input for the copyright and").append(this.newline);
        buf.append(" * terms of use that apply to this source code.").append(this.newline);
        buf.append(" */").append(this.newline);
    }

    protected void populatePrimList() {
        this.primlist.add("int");
        this.primlist.add("boolean");
        this.primlist.add("short");
        this.primlist.add("byte");
        this.primlist.add("long");
        this.primlist.add("float");
        this.primlist.add("double");
    }

    protected void populateWrapperList() {
        this.wrapperlist.add("java.lang.Integer");
        this.wrapperlist.add("java.lang.Boolean");
        this.wrapperlist.add("java.lang.Short");
        this.wrapperlist.add("java.lang.Byte");
        this.wrapperlist.add("java.lang.Long");
        this.wrapperlist.add("java.lang.Float");
        this.wrapperlist.add("java.lang.Double");
        this.wrapperlist.add("java.lang.String");
        this.wrapperlist.add("java.math.BigInteger");
        this.wrapperlist.add("java.math.BigDecimal");
        this.wrapperlist.add("java.util.Calendar");
        this.wrapperlist.add("javax.xml.namespace.QName");
    }

    private void createPrimitiveMap() {
        this.primitiveMap.put("Integer", "int");
        this.primitiveMap.put("Float", "float");
        this.primitiveMap.put("Long", "long");
        this.primitiveMap.put("Double", "double");
        this.primitiveMap.put("Short", "short");
        this.primitiveMap.put("Boolean", "boolean");
        this.primitiveMap.put("Byte", "byte");
        this.primitiveMap.put("java.lang.Integer", "int");
        this.primitiveMap.put("java.lang.Float", "float");
        this.primitiveMap.put("java.lang.Long", "long");
        this.primitiveMap.put("java.lang.Double", "double");
        this.primitiveMap.put("java.lang.Short", "short");
        this.primitiveMap.put("java.lang.Boolean", "boolean");
        this.primitiveMap.put("java.lang.Byte", "byte");
    }

    public static WSDLInterfaceOperationOutput getWsdl11Output(WSDLInterfaceOperation operation) {
        WSDLInterfaceOperationOutput[] outputs = operation.getOutputs();
        if (outputs == null) {
            return null;
        }
        switch (outputs.length) {
            case 0: {
                return null;
            }
            case 1: {
                return outputs[0];
            }
        }
        throw new WSException("Only Request-Only and Request-Response MEPs are allowed");
    }

    public static WSDLInterfaceOperationInput getWsdl11Input(WSDLInterfaceOperation operation) {
        WSDLInterfaceOperationInput[] inputs = operation.getInputs();
        if (inputs == null) {
            return null;
        }
        switch (inputs.length) {
            case 0: {
                return null;
            }
            case 1: {
                return inputs[0];
            }
        }
        throw new WSException("Only Request-Only and Request-Response MEPs are allowed");
    }

    static {
        schemaBasicTypes.put("anyURI", URI.class);
        schemaBasicTypes.put("boolean", Boolean.TYPE);
        schemaBasicTypes.put("byte", Byte.TYPE);
        schemaBasicTypes.put("decimal", BigDecimal.class);
        schemaBasicTypes.put("double", Double.TYPE);
        schemaBasicTypes.put("dateTime", Calendar.class);
        schemaBasicTypes.put("float", Float.TYPE);
        schemaBasicTypes.put("int", Integer.TYPE);
        schemaBasicTypes.put("integer", BigInteger.class);
        schemaBasicTypes.put("long", Long.TYPE);
        schemaBasicTypes.put("QName", QName.class);
        schemaBasicTypes.put("short", Short.TYPE);
        schemaBasicTypes.put("String", String.class);
        holderTypes.put(BigDecimal.class, BigDecimalHolder.class);
        holderTypes.put(BigInteger.class, BigIntegerHolder.class);
        holderTypes.put(Boolean.TYPE, BooleanHolder.class);
        holderTypes.put(Boolean.class, BooleanWrapperHolder.class);
        holderTypes.put(Byte.TYPE, ByteHolder.class);
        holderTypes.put(Byte.class, ByteWrapperHolder.class);
        holderTypes.put(Byte[].class, ByteArrayHolder.class);
        holderTypes.put(Calendar.class, CalendarHolder.class);
        holderTypes.put(Double.TYPE, DoubleHolder.class);
        holderTypes.put(Double.class, DoubleWrapperHolder.class);
        holderTypes.put(Float.TYPE, FloatHolder.class);
        holderTypes.put(Float.class, FloatWrapperHolder.class);
        holderTypes.put(Integer.TYPE, IntHolder.class);
        holderTypes.put(Integer.class, IntegerWrapperHolder.class);
        holderTypes.put(Long.TYPE, LongHolder.class);
        holderTypes.put(Long.class, LongWrapperHolder.class);
        holderTypes.put(Object.class, ObjectHolder.class);
        holderTypes.put(QName.class, QNameHolder.class);
        holderTypes.put(Short.TYPE, ShortHolder.class);
        holderTypes.put(Short.class, ShortWrapperHolder.class);
        holderTypes.put(String.class, StringHolder.class);
        reverseHolderTypes.put(BigDecimalHolder.class, BigDecimal.class);
        reverseHolderTypes.put(BigIntegerHolder.class, BigInteger.class);
        reverseHolderTypes.put(BooleanHolder.class, Boolean.TYPE);
        reverseHolderTypes.put(BooleanWrapperHolder.class, Boolean.class);
        reverseHolderTypes.put(ByteArrayHolder.class, Byte[].class);
        reverseHolderTypes.put(ByteHolder.class, Byte.TYPE);
        reverseHolderTypes.put(ByteWrapperHolder.class, Byte.class);
        reverseHolderTypes.put(CalendarHolder.class, Calendar.class);
        reverseHolderTypes.put(DoubleHolder.class, Double.TYPE);
        reverseHolderTypes.put(DoubleWrapperHolder.class, Double.class);
        reverseHolderTypes.put(FloatHolder.class, Float.TYPE);
        reverseHolderTypes.put(FloatWrapperHolder.class, Float.class);
        reverseHolderTypes.put(IntHolder.class, Integer.TYPE);
        reverseHolderTypes.put(IntegerWrapperHolder.class, Integer.class);
        reverseHolderTypes.put(LongHolder.class, Long.TYPE);
        reverseHolderTypes.put(LongWrapperHolder.class, Long.class);
        reverseHolderTypes.put(ObjectHolder.class, Object.class);
        reverseHolderTypes.put(QNameHolder.class, QName.class);
        reverseHolderTypes.put(ShortHolder.class, Short.TYPE);
        reverseHolderTypes.put(ShortWrapperHolder.class, Short.class);
        reverseHolderTypes.put(StringHolder.class, String.class);
    }
}

