/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security.operation;

import java.security.Key;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.jboss.ws.extensions.security.STRTransform;
import org.jboss.ws.extensions.security.SecurityStore;
import org.jboss.ws.extensions.security.SignatureKeysAssociation;
import org.jboss.ws.extensions.security.WsuIdResolver;
import org.jboss.ws.extensions.security.element.SecurityHeader;
import org.jboss.ws.extensions.security.element.SecurityProcess;
import org.jboss.ws.extensions.security.element.Signature;
import org.jboss.ws.extensions.security.exception.FailedCheckException;
import org.jboss.ws.extensions.security.exception.WSSecurityException;
import org.jboss.ws.extensions.security.operation.DecodingOperation;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureVerificationOperation
implements DecodingOperation {
    private SecurityHeader header;
    private SecurityStore store;

    public SignatureVerificationOperation(SecurityHeader header, SecurityStore store) throws WSSecurityException {
        this.header = header;
        this.store = store;
    }

    @Override
    public Collection<String> process(Document message, SecurityProcess process) throws WSSecurityException {
        Signature signature = (Signature)process;
        XMLSignature xmlSig = signature.getSignature();
        xmlSig.addResourceResolver((ResourceResolverSpi)new WsuIdResolver(message));
        STRTransform.setSecurityStore(this.store);
        try {
            if (!xmlSig.checkSignatureValue((Key)signature.getPublicKey())) {
                throw new FailedCheckException("Signature is invalid.");
            }
            SignatureKeysAssociation.saveKey(signature.getPublicKey());
        }
        catch (XMLSignatureException e) {
            throw new WSSecurityException("An unexpected error occured while verifying signature", e);
        }
        finally {
            STRTransform.setSecurityStore(null);
        }
        SignedInfo info = xmlSig.getSignedInfo();
        int length = info.getLength();
        ArrayList<String> processed = new ArrayList<String>(length);
        try {
            for (int i = 0; i < length; ++i) {
                String uri = info.item(i).getURI();
                if (uri == null || uri.length() <= 1 || uri.charAt(0) != '#') continue;
                processed.add(uri.substring(1));
            }
        }
        catch (XMLSecurityException e) {
            throw new WSSecurityException("Could not extract references", e);
        }
        return processed;
    }
}

