/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import org.hornetq.core.logging.Logger;
import org.hornetq.ra.HornetQRAMessage;
import org.hornetq.ra.HornetQRASession;

public class HornetQRAObjectMessage
extends HornetQRAMessage
implements ObjectMessage {
    private static final Logger log = Logger.getLogger(HornetQRAObjectMessage.class);
    private static boolean trace = log.isTraceEnabled();

    public HornetQRAObjectMessage(ObjectMessage message, HornetQRASession session) {
        super((Message)message, session);
        if (trace) {
            log.trace((Object)("constructor(" + message + ", " + session + ")"));
        }
    }

    public Serializable getObject() throws JMSException {
        if (trace) {
            log.trace((Object)"getObject()");
        }
        return ((ObjectMessage)this.message).getObject();
    }

    public void setObject(Serializable object) throws JMSException {
        if (trace) {
            log.trace((Object)("setObject(" + object + ")"));
        }
        ((ObjectMessage)this.message).setObject(object);
    }
}

