/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra;

import java.io.PrintWriter;
import java.util.Set;
import javax.jms.ConnectionMetaData;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.security.auth.Subject;
import org.hornetq.core.logging.Logger;
import org.hornetq.jms.client.HornetQConnectionFactory;
import org.hornetq.jms.server.recovery.HornetQResourceRecovery;
import org.hornetq.ra.HornetQRAConnectionFactoryImpl;
import org.hornetq.ra.HornetQRAConnectionManager;
import org.hornetq.ra.HornetQRAConnectionMetaData;
import org.hornetq.ra.HornetQRAConnectionRequestInfo;
import org.hornetq.ra.HornetQRACredential;
import org.hornetq.ra.HornetQRAMCFProperties;
import org.hornetq.ra.HornetQRAManagedConnection;
import org.hornetq.ra.HornetQResourceAdapter;

public class HornetQRAManagedConnectionFactory
implements ManagedConnectionFactory,
ResourceAdapterAssociation {
    static final long serialVersionUID = -1452379518562456741L;
    private static final Logger log = Logger.getLogger(HornetQRAManagedConnectionFactory.class);
    private static boolean trace = log.isTraceEnabled();
    private HornetQResourceAdapter ra;
    private ConnectionManager cm;
    private final HornetQRAMCFProperties mcfProperties;
    private HornetQConnectionFactory connectionFactory;
    private HornetQResourceRecovery resourceRecovery;

    public HornetQRAManagedConnectionFactory() {
        if (trace) {
            log.trace((Object)"constructor()");
        }
        this.ra = null;
        this.cm = null;
        this.mcfProperties = new HornetQRAMCFProperties();
    }

    public Object createConnectionFactory() throws ResourceException {
        if (trace) {
            log.debug((Object)"createConnectionFactory()");
        }
        return this.createConnectionFactory(new HornetQRAConnectionManager());
    }

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        if (trace) {
            log.trace((Object)("createConnectionFactory(" + cxManager + ")"));
        }
        this.cm = cxManager;
        HornetQRAConnectionFactoryImpl cf = new HornetQRAConnectionFactoryImpl(this, this.cm);
        if (trace) {
            log.trace((Object)("Created connection factory: " + cf + ", using connection manager: " + this.cm));
        }
        if (this.connectionFactory == null) {
            this.connectionFactory = this.ra.createHornetQConnectionFactory(this.mcfProperties);
            this.resourceRecovery = this.ra.getRecoveryManager().register(this.connectionFactory, null, null);
        }
        return cf;
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        if (trace) {
            log.trace((Object)("createManagedConnection(" + subject + ", " + cxRequestInfo + ")"));
        }
        HornetQRAConnectionRequestInfo cri = this.getCRI((HornetQRAConnectionRequestInfo)cxRequestInfo);
        HornetQRACredential credential = HornetQRACredential.getCredential(this, subject, cri);
        if (trace) {
            log.trace((Object)("jms credential: " + credential));
        }
        HornetQRAManagedConnection mc = new HornetQRAManagedConnection(this, cri, this.ra.getTM(), credential.getUserName(), credential.getPassword());
        if (trace) {
            log.trace((Object)("created new managed connection: " + mc));
        }
        return mc;
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        if (trace) {
            log.trace((Object)("matchManagedConnections(" + connectionSet + ", " + subject + ", " + cxRequestInfo + ")"));
        }
        HornetQRAConnectionRequestInfo cri = this.getCRI((HornetQRAConnectionRequestInfo)cxRequestInfo);
        HornetQRACredential credential = HornetQRACredential.getCredential(this, subject, cri);
        if (trace) {
            log.trace((Object)("Looking for connection matching credentials: " + credential));
        }
        for (Object obj : connectionSet) {
            if (!(obj instanceof HornetQRAManagedConnection)) continue;
            HornetQRAManagedConnection mc = (HornetQRAManagedConnection)obj;
            HornetQRAManagedConnectionFactory mcf = mc.getManagedConnectionFactory();
            if (mc.getUserName() != null && (mc.getUserName() == null || !mc.getUserName().equals(credential.getUserName())) || !((Object)mcf).equals(this) || !cri.equals(mc.getCRI())) continue;
            if (trace) {
                log.trace((Object)("Found matching connection: " + mc));
            }
            return mc;
        }
        if (trace) {
            log.trace((Object)"No matching connection was found");
        }
        return null;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        if (trace) {
            log.trace((Object)("setLogWriter(" + out + ")"));
        }
    }

    public PrintWriter getLogWriter() throws ResourceException {
        if (trace) {
            log.trace((Object)"getLogWriter()");
        }
        return null;
    }

    public ResourceAdapter getResourceAdapter() {
        if (trace) {
            log.trace((Object)"getResourceAdapter()");
        }
        return this.ra;
    }

    public void setResourceAdapter(ResourceAdapter ra) throws ResourceException {
        if (trace) {
            log.trace((Object)("setResourceAdapter(" + ra + ")"));
        }
        if (ra == null || !(ra instanceof HornetQResourceAdapter)) {
            throw new ResourceException("Resource adapter is " + ra);
        }
        this.ra = (HornetQResourceAdapter)ra;
    }

    public boolean equals(Object obj) {
        if (trace) {
            log.trace((Object)("equals(" + obj + ")"));
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof HornetQRAManagedConnectionFactory) {
            HornetQRAManagedConnectionFactory other = (HornetQRAManagedConnectionFactory)obj;
            return this.mcfProperties.equals(other.getProperties()) && this.ra.equals(other.getResourceAdapter());
        }
        return false;
    }

    public int hashCode() {
        if (trace) {
            log.trace((Object)"hashCode()");
        }
        int hash = this.mcfProperties.hashCode();
        return hash += 31 * this.ra.hashCode();
    }

    public String getSessionDefaultType() {
        if (trace) {
            log.trace((Object)"getSessionDefaultType()");
        }
        return this.mcfProperties.getSessionDefaultType();
    }

    public void setSessionDefaultType(String type) {
        if (trace) {
            log.trace((Object)("setSessionDefaultType(" + type + ")"));
        }
        this.mcfProperties.setSessionDefaultType(type);
    }

    public String getConnectionParameters() {
        return this.mcfProperties.getStrConnectionParameters();
    }

    public void setConnectionParameters(String configuration) {
        this.mcfProperties.setConnectionParameters(configuration);
    }

    public String getConnectorClassName() {
        return this.mcfProperties.getConnectorClassName();
    }

    public void setConnectorClassName(String value) {
        this.mcfProperties.setConnectorClassName(value);
    }

    public String getConnectionLoadBalancingPolicyClassName() {
        return this.mcfProperties.getConnectionLoadBalancingPolicyClassName();
    }

    public void setConnectionLoadBalancingPolicyClassName(String connectionLoadBalancingPolicyClassName) {
        this.mcfProperties.setConnectionLoadBalancingPolicyClassName(connectionLoadBalancingPolicyClassName);
    }

    public String getDiscoveryAddress() {
        return this.mcfProperties.getDiscoveryAddress();
    }

    public void setDiscoveryAddress(String discoveryAddress) {
        this.mcfProperties.setDiscoveryAddress(discoveryAddress);
    }

    public Integer getDiscoveryPort() {
        return this.mcfProperties.getDiscoveryPort();
    }

    public void setDiscoveryPort(Integer discoveryPort) {
        this.mcfProperties.setDiscoveryPort(discoveryPort);
    }

    public Long getDiscoveryRefreshTimeout() {
        return this.mcfProperties.getDiscoveryRefreshTimeout();
    }

    public void setDiscoveryRefreshTimeout(Long discoveryRefreshTimeout) {
        this.mcfProperties.setDiscoveryRefreshTimeout(discoveryRefreshTimeout);
    }

    public Long getDiscoveryInitialWaitTimeout() {
        return this.mcfProperties.getDiscoveryInitialWaitTimeout();
    }

    public void setDiscoveryInitialWaitTimeout(Long discoveryInitialWaitTimeout) {
        this.mcfProperties.setDiscoveryInitialWaitTimeout(discoveryInitialWaitTimeout);
    }

    public String getClientID() {
        return this.mcfProperties.getClientID();
    }

    public void setClientID(String clientID) {
        this.mcfProperties.setClientID(clientID);
    }

    public Integer getDupsOKBatchSize() {
        return this.mcfProperties.getDupsOKBatchSize();
    }

    public void setDupsOKBatchSize(Integer dupsOKBatchSize) {
        this.mcfProperties.setDupsOKBatchSize(dupsOKBatchSize);
    }

    public Integer getTransactionBatchSize() {
        return this.mcfProperties.getTransactionBatchSize();
    }

    public void setTransactionBatchSize(Integer transactionBatchSize) {
        this.mcfProperties.setTransactionBatchSize(transactionBatchSize);
    }

    public Long getClientFailureCheckPeriod() {
        return this.mcfProperties.getClientFailureCheckPeriod();
    }

    public void setClientFailureCheckPeriod(Long clientFailureCheckPeriod) {
        this.mcfProperties.setClientFailureCheckPeriod(clientFailureCheckPeriod);
    }

    public Long getConnectionTTL() {
        return this.mcfProperties.getConnectionTTL();
    }

    public void setConnectionTTL(Long connectionTTL) {
        this.mcfProperties.setConnectionTTL(connectionTTL);
    }

    public Long getCallTimeout() {
        return this.mcfProperties.getCallTimeout();
    }

    public void setCallTimeout(Long callTimeout) {
        this.mcfProperties.setCallTimeout(callTimeout);
    }

    public Integer getConsumerWindowSize() {
        return this.mcfProperties.getConsumerWindowSize();
    }

    public void setConsumerWindowSize(Integer consumerWindowSize) {
        this.mcfProperties.setConsumerWindowSize(consumerWindowSize);
    }

    public Integer getConsumerMaxRate() {
        return this.mcfProperties.getConsumerMaxRate();
    }

    public void setConsumerMaxRate(Integer consumerMaxRate) {
        this.mcfProperties.setConsumerMaxRate(consumerMaxRate);
    }

    public Integer getConfirmationWindowSize() {
        return this.mcfProperties.getConfirmationWindowSize();
    }

    public void setConfirmationWindowSize(Integer confirmationWindowSize) {
        this.mcfProperties.setConfirmationWindowSize(confirmationWindowSize);
    }

    public Integer getProducerMaxRate() {
        return this.mcfProperties.getProducerMaxRate();
    }

    public void setProducerMaxRate(Integer producerMaxRate) {
        this.mcfProperties.setProducerMaxRate(producerMaxRate);
    }

    public Integer getMinLargeMessageSize() {
        return this.mcfProperties.getMinLargeMessageSize();
    }

    public void setMinLargeMessageSize(Integer minLargeMessageSize) {
        this.mcfProperties.setMinLargeMessageSize(minLargeMessageSize);
    }

    public Boolean isBlockOnAcknowledge() {
        return this.mcfProperties.isBlockOnAcknowledge();
    }

    public void setBlockOnAcknowledge(Boolean blockOnAcknowledge) {
        this.mcfProperties.setBlockOnAcknowledge(blockOnAcknowledge);
    }

    public Boolean isBlockOnNonDurableSend() {
        return this.mcfProperties.isBlockOnNonDurableSend();
    }

    public void setBlockOnNonDurableSend(Boolean blockOnNonDurableSend) {
        this.mcfProperties.setBlockOnNonDurableSend(blockOnNonDurableSend);
    }

    public Boolean isBlockOnDurableSend() {
        return this.mcfProperties.isBlockOnDurableSend();
    }

    public void setBlockOnDurableSend(Boolean blockOnDurableSend) {
        this.mcfProperties.setBlockOnDurableSend(blockOnDurableSend);
    }

    public Boolean isAutoGroup() {
        return this.mcfProperties.isAutoGroup();
    }

    public void setAutoGroup(Boolean autoGroup) {
        this.mcfProperties.setAutoGroup(autoGroup);
    }

    public Boolean isPreAcknowledge() {
        return this.mcfProperties.isPreAcknowledge();
    }

    public void setPreAcknowledge(Boolean preAcknowledge) {
        this.mcfProperties.setPreAcknowledge(preAcknowledge);
    }

    public Long getRetryInterval() {
        return this.mcfProperties.getRetryInterval();
    }

    public void setRetryInterval(Long retryInterval) {
        this.mcfProperties.setRetryInterval(retryInterval);
    }

    public Double getRetryIntervalMultiplier() {
        return this.mcfProperties.getRetryIntervalMultiplier();
    }

    public void setRetryIntervalMultiplier(Double retryIntervalMultiplier) {
        this.mcfProperties.setRetryIntervalMultiplier(retryIntervalMultiplier);
    }

    public Integer getReconnectAttempts() {
        return this.mcfProperties.getReconnectAttempts();
    }

    public void setReconnectAttempts(Integer reconnectAttempts) {
        this.mcfProperties.setReconnectAttempts(reconnectAttempts);
    }

    public Boolean isUseGlobalPools() {
        return this.mcfProperties.isUseGlobalPools();
    }

    public void setUseGlobalPools(Boolean useGlobalPools) {
        this.mcfProperties.setUseGlobalPools(useGlobalPools);
    }

    public Integer getScheduledThreadPoolMaxSize() {
        return this.mcfProperties.getScheduledThreadPoolMaxSize();
    }

    public void setScheduledThreadPoolMaxSize(Integer scheduledThreadPoolMaxSize) {
        this.mcfProperties.setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize);
    }

    public Integer getThreadPoolMaxSize() {
        return this.mcfProperties.getThreadPoolMaxSize();
    }

    public void setThreadPoolMaxSize(Integer threadPoolMaxSize) {
        this.mcfProperties.setThreadPoolMaxSize(threadPoolMaxSize);
    }

    public Boolean isHA() {
        return this.mcfProperties.isHA();
    }

    public void setHA(Boolean ha) {
        this.mcfProperties.setHA(ha);
    }

    public Integer getUseTryLock() {
        if (trace) {
            log.trace((Object)"getUseTryLock()");
        }
        return this.mcfProperties.getUseTryLock();
    }

    public void setUseTryLock(Integer useTryLock) {
        if (trace) {
            log.trace((Object)("setUseTryLock(" + useTryLock + ")"));
        }
        this.mcfProperties.setUseTryLock(useTryLock);
    }

    public ConnectionMetaData getMetaData() {
        if (trace) {
            log.trace((Object)"getMetadata()");
        }
        return new HornetQRAConnectionMetaData();
    }

    protected synchronized HornetQConnectionFactory getHornetQConnectionFactory() throws ResourceException {
        if (this.connectionFactory == null) {
            this.connectionFactory = this.ra.createHornetQConnectionFactory(this.mcfProperties);
            this.resourceRecovery = this.ra.getRecoveryManager().register(this.connectionFactory, null, null);
        }
        return this.connectionFactory;
    }

    protected HornetQRAMCFProperties getProperties() {
        if (trace) {
            log.trace((Object)"getProperties()");
        }
        return this.mcfProperties;
    }

    private HornetQRAConnectionRequestInfo getCRI(HornetQRAConnectionRequestInfo info) {
        if (trace) {
            log.trace((Object)("getCRI(" + info + ")"));
        }
        if (info == null) {
            return new HornetQRAConnectionRequestInfo(this.ra.getProperties(), this.mcfProperties.getType());
        }
        info.setDefaults(this.ra.getProperties());
        return info;
    }

    public void stop() {
        if (this.resourceRecovery != null) {
            this.ra.getRecoveryManager().unRegister(this.resourceRecovery);
        }
    }
}

