/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.auth;

import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.auth.AuthChallengeParser;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.httpclient.auth.InvalidCredentialsException;
import org.apache.commons.httpclient.auth.MalformedChallengeException;
import org.apache.commons.httpclient.auth.NTLM;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NTLMScheme
implements AuthScheme {
    private static final Log LOG = LogFactory.getLog(NTLMScheme.class);
    private String ntlmchallenge = null;
    private static final int UNINITIATED = 0;
    private static final int INITIATED = 1;
    private static final int TYPE1_MSG_GENERATED = 2;
    private static final int TYPE2_MSG_RECEIVED = 3;
    private static final int TYPE3_MSG_GENERATED = 4;
    private static final int FAILED = Integer.MAX_VALUE;
    private int state;

    public NTLMScheme() {
        this.state = 0;
    }

    public NTLMScheme(String string) throws MalformedChallengeException {
        this.processChallenge(string);
    }

    @Override
    public void processChallenge(String string) throws MalformedChallengeException {
        String string2 = AuthChallengeParser.extractScheme(string);
        if (!string2.equalsIgnoreCase(this.getSchemeName())) {
            throw new MalformedChallengeException("Invalid NTLM challenge: " + string);
        }
        int n = string.indexOf(32);
        if (n != -1) {
            string2 = string.substring(n, string.length());
            this.ntlmchallenge = string2.trim();
            this.state = 3;
        } else {
            this.ntlmchallenge = "";
            this.state = this.state == 0 ? 1 : Integer.MAX_VALUE;
        }
    }

    @Override
    public boolean isComplete() {
        return this.state == 4 || this.state == Integer.MAX_VALUE;
    }

    @Override
    public String getSchemeName() {
        return "ntlm";
    }

    @Override
    public String getRealm() {
        return null;
    }

    @Override
    public String getID() {
        return this.ntlmchallenge;
    }

    @Override
    public String getParameter(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter name may not be null");
        }
        return null;
    }

    @Override
    public boolean isConnectionBased() {
        return true;
    }

    public static String authenticate(NTCredentials nTCredentials, String string) throws AuthenticationException {
        LOG.trace((Object)"enter NTLMScheme.authenticate(NTCredentials, String)");
        if (nTCredentials == null) {
            throw new IllegalArgumentException("Credentials may not be null");
        }
        NTLM nTLM = new NTLM();
        String string2 = nTLM.getResponseFor(string, nTCredentials.getUserName(), nTCredentials.getPassword(), nTCredentials.getHost(), nTCredentials.getDomain());
        return "NTLM " + string2;
    }

    public static String authenticate(NTCredentials nTCredentials, String string, String string2) throws AuthenticationException {
        LOG.trace((Object)"enter NTLMScheme.authenticate(NTCredentials, String)");
        if (nTCredentials == null) {
            throw new IllegalArgumentException("Credentials may not be null");
        }
        NTLM nTLM = new NTLM();
        nTLM.setCredentialCharset(string2);
        String string3 = nTLM.getResponseFor(string, nTCredentials.getUserName(), nTCredentials.getPassword(), nTCredentials.getHost(), nTCredentials.getDomain());
        return "NTLM " + string3;
    }

    @Override
    public String authenticate(Credentials credentials, String string, String string2) throws AuthenticationException {
        LOG.trace((Object)"enter NTLMScheme.authenticate(Credentials, String, String)");
        NTCredentials nTCredentials = null;
        try {
            nTCredentials = (NTCredentials)credentials;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidCredentialsException("Credentials cannot be used for NTLM authentication: " + credentials.getClass().getName());
        }
        return NTLMScheme.authenticate(nTCredentials, this.ntlmchallenge);
    }

    @Override
    public String authenticate(Credentials credentials, HttpMethod httpMethod) throws AuthenticationException {
        LOG.trace((Object)"enter NTLMScheme.authenticate(Credentials, HttpMethod)");
        if (this.state == 0) {
            throw new IllegalStateException("NTLM authentication process has not been initiated");
        }
        NTCredentials nTCredentials = null;
        try {
            nTCredentials = (NTCredentials)credentials;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidCredentialsException("Credentials cannot be used for NTLM authentication: " + credentials.getClass().getName());
        }
        NTLM nTLM = new NTLM();
        nTLM.setCredentialCharset(httpMethod.getParams().getCredentialCharset());
        String string = null;
        if (this.state == 1 || this.state == Integer.MAX_VALUE) {
            string = nTLM.getType1Message(nTCredentials.getHost(), nTCredentials.getDomain());
            this.state = 2;
        } else {
            string = nTLM.getType3Message(nTCredentials.getUserName(), nTCredentials.getPassword(), nTCredentials.getHost(), nTCredentials.getDomain(), nTLM.parseType2Message(this.ntlmchallenge));
            this.state = 4;
        }
        return "NTLM " + string;
    }
}

