/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jms.integration.mdb;

import javax.jms.Connection;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.test.JBossTestSetup;
import org.jboss.test.jms.integration.MessagingIntegrationTestBase;
import org.jboss.test.jms.integration.mdb.MDBTestBase;
import org.jboss.test.jms.integration.util.JMSAdmin;

public class SimpleMDBTest
extends MDBTestBase {
    public SimpleMDBTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleMDB() throws Exception {
        Connection conn = this.cf.createConnection();
        conn.start();
        Session sess = null;
        try {
            sess = conn.createSession(false, 1);
            MessageProducer producer = sess.createProducer(this.queueDestination);
            MessageConsumer consumer = sess.createConsumer(this.responseDestination);
            TextMessage message = sess.createTextMessage("Message " + this.random.nextLong());
            message.setJMSReplyTo(this.responseDestination);
            producer.send((Message)message);
            TextMessage messageResponse = (TextMessage)consumer.receive(10000L);
            SimpleMDBTest.assertNotNull((Object)messageResponse);
            System.out.println("Received message " + messageResponse.getText());
            messageResponse = (TextMessage)consumer.receive(1000L);
            SimpleMDBTest.assertNull((Object)messageResponse);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleWithExceptionOnMDB() throws Exception {
        Connection conn = this.cf.createConnection();
        conn.start();
        Session sess = null;
        try {
            sess = conn.createSession(false, 1);
            MessageProducer producer = sess.createProducer(this.queueDestination);
            MessageConsumer consumer = sess.createConsumer(this.responseDestination);
            TextMessage message = sess.createTextMessage("Message " + this.random.nextLong());
            message.setJMSReplyTo(this.responseDestination);
            message.setBooleanProperty("throwException", true);
            producer.send((Message)message);
            TextMessage messageResponse = (TextMessage)consumer.receive(10000L);
            SimpleMDBTest.assertNotNull((Object)messageResponse);
            System.out.println("Received message " + messageResponse.getText());
            messageResponse = (TextMessage)consumer.receive(1000L);
            SimpleMDBTest.assertNull((Object)messageResponse);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public static Test suite() throws Exception {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new JBossTestSetup((Test)new TestSuite(SimpleMDBTest.class)){

            protected void setUp() throws Exception {
                super.setUp();
                JMSAdmin admin = MessagingIntegrationTestBase.getDestManager();
                try {
                    admin.deployTopic("testTopic_Integration", "topic/testTopic_Integration");
                    admin.deployQueue("testQueue_Integration", "queue/testQueue_Integration");
                    admin.deployQueue("A_Integration", "queue/A_Integration");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.deploy("integration-mdb20.jar");
            }

            protected void tearDown() throws Exception {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                JMSAdmin admin = MessagingIntegrationTestBase.getDestManager();
                admin.destroyQueue("testQueue_Integration");
                admin.destroyTopic("testTopic_Integration");
                admin.destroyQueue("A_Integration");
                this.undeploy("integration-mdb20.jar");
                super.tearDown();
            }
        });
        return suite;
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }
}

