/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.aop.Advisor;
import org.springframework.aop.IntroductionAdvisor;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.PointcutAdvisor;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AdvisorChainFactory;
import org.springframework.aop.framework.InterceptorAndDynamicMethodMatcher;
import org.springframework.aop.framework.adapter.AdvisorAdapterRegistry;
import org.springframework.aop.framework.adapter.GlobalAdvisorAdapterRegistry;
import org.springframework.aop.support.MethodMatchers;

public class DefaultAdvisorChainFactory
implements AdvisorChainFactory,
Serializable {
    public List getInterceptorsAndDynamicInterceptionAdvice(Advised config, Method method, Class targetClass) {
        ArrayList<InterceptorAndDynamicMethodMatcher> interceptorList = new ArrayList<InterceptorAndDynamicMethodMatcher>(config.getAdvisors().length);
        boolean hasIntroductions = DefaultAdvisorChainFactory.hasMatchingIntroductions(config, targetClass);
        AdvisorAdapterRegistry registry = GlobalAdvisorAdapterRegistry.getInstance();
        Advisor[] advisors = config.getAdvisors();
        for (int i = 0; i < advisors.length; ++i) {
            MethodInterceptor[] interceptors;
            Advisor advisor = advisors[i];
            if (advisor instanceof PointcutAdvisor) {
                PointcutAdvisor pointcutAdvisor = (PointcutAdvisor)advisor;
                if (!config.isPreFiltered() && !pointcutAdvisor.getPointcut().getClassFilter().matches(targetClass)) continue;
                interceptors = registry.getInterceptors(advisor);
                MethodMatcher mm = pointcutAdvisor.getPointcut().getMethodMatcher();
                if (!MethodMatchers.matches(mm, method, targetClass, hasIntroductions)) continue;
                if (mm.isRuntime()) {
                    for (int j = 0; j < interceptors.length; ++j) {
                        interceptorList.add(new InterceptorAndDynamicMethodMatcher(interceptors[j], mm));
                    }
                    continue;
                }
                interceptorList.addAll(Arrays.asList(interceptors));
                continue;
            }
            if (advisor instanceof IntroductionAdvisor) {
                IntroductionAdvisor ia = (IntroductionAdvisor)advisor;
                if (!config.isPreFiltered() && !ia.getClassFilter().matches(targetClass)) continue;
                interceptors = registry.getInterceptors(advisor);
                interceptorList.addAll(Arrays.asList(interceptors));
                continue;
            }
            MethodInterceptor[] interceptors2 = registry.getInterceptors(advisor);
            interceptorList.addAll(Arrays.asList(interceptors2));
        }
        return interceptorList;
    }

    private static boolean hasMatchingIntroductions(Advised config, Class targetClass) {
        for (int i = 0; i < config.getAdvisors().length; ++i) {
            IntroductionAdvisor ia;
            Advisor advisor = config.getAdvisors()[i];
            if (!(advisor instanceof IntroductionAdvisor) || !(ia = (IntroductionAdvisor)advisor).getClassFilter().matches(targetClass)) continue;
            return true;
        }
        return false;
    }
}

