/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.annotations;

import java.net.URL;
import java.util.List;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.deployers.spi.annotations.PathMetaData;
import org.jboss.deployers.spi.annotations.ScanningMetaData;
import org.jboss.deployers.vfs.plugins.annotations.ScanningMetaDataResourceFilter;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnitFilter;
import org.jboss.logging.Logger;

public class ScanningDeploymentUnitFilter
implements VFSDeploymentUnitFilter {
    private Logger log = Logger.getLogger(this.getClass());

    public boolean accepts(VFSDeploymentUnit unit) {
        ScanningMetaData smd = (ScanningMetaData)unit.getAttachment(ScanningMetaData.class);
        if (smd != null) {
            ResourceFilter previousFilter;
            ResourceFilter filter;
            ResourceFilter previousRecurse;
            ResourceFilter recurse = this.createRecurseFilter(smd);
            if (recurse != null && (previousRecurse = (ResourceFilter)unit.addAttachment(ResourceFilter.class.getName() + ".recurse", (Object)recurse, ResourceFilter.class)) != null) {
                this.log.debug((Object)("Overridding previous recurse filter: " + previousRecurse));
            }
            if ((filter = this.createResourceFilter(smd)) != null && (previousFilter = (ResourceFilter)unit.addAttachment(ResourceFilter.class.getName() + ".resource", (Object)filter, ResourceFilter.class)) != null) {
                this.log.debug((Object)("Overridding previous resource filter: " + previousFilter));
            }
        }
        return true;
    }

    protected ResourceFilter createRecurseFilter(ScanningMetaData smd) {
        return new ScanningMetaDataRecurseFilter(smd);
    }

    protected ResourceFilter createResourceFilter(ScanningMetaData smd) {
        return new ScanningMetaDataResourceFilter(smd);
    }

    private class ScanningMetaDataRecurseFilter
    implements ResourceFilter {
        private ScanningMetaData smd;

        private ScanningMetaDataRecurseFilter(ScanningMetaData smd) {
            this.smd = smd;
        }

        public boolean accepts(ResourceContext resource) {
            URL url = resource.getUrl();
            String urlString = url.toExternalForm();
            List paths = this.smd.getPaths();
            if (paths != null && !paths.isEmpty()) {
                for (PathMetaData pmd : paths) {
                    String name = pmd.getPathName();
                    if (!urlString.contains(name)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

