/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.system;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessExecution {
    private String executable;
    private List<String> arguments;
    private Map<String, String> environmentVariables;
    private String workingDirectory;
    private long waitForCompletion = 30000L;
    private boolean captureOutput = false;
    private boolean killOnTimeout = false;
    private boolean checkExecutableExists = true;

    public ProcessExecution(String executable) {
        if (executable == null) {
            throw new IllegalArgumentException("executable cannot be null");
        }
        this.setExecutable(executable);
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public String[] getArgumentsAsArray() {
        String[] argArray = this.arguments == null ? null : this.arguments.toArray(new String[this.arguments.size()]);
        return argArray;
    }

    public void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }

    public void setArguments(String[] arguments) {
        this.arguments = new ArrayList<String>(Arrays.asList(arguments));
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public String[] getEnvironmentVariablesAsArray() {
        String[] envVarArray;
        if (this.environmentVariables == null) {
            envVarArray = null;
        } else {
            envVarArray = new String[this.environmentVariables.size()];
            int i = 0;
            for (String varName : this.environmentVariables.keySet()) {
                envVarArray[i++] = varName + "=" + this.environmentVariables.get(varName);
            }
        }
        return envVarArray;
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public long getWaitForCompletion() {
        return this.waitForCompletion;
    }

    public void setWaitForCompletion(long waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
    }

    public boolean isCaptureOutput() {
        return this.captureOutput;
    }

    public void setCaptureOutput(boolean captureOutput) {
        this.captureOutput = captureOutput;
    }

    public boolean isKillOnTimeout() {
        return this.killOnTimeout;
    }

    public void setKillOnTimeout(boolean killOnTimeout) {
        this.killOnTimeout = killOnTimeout;
    }

    public boolean isCheckExecutableExists() {
        return this.checkExecutableExists;
    }

    public void setCheckExecutableExists(boolean checkExecutableExists) {
        this.checkExecutableExists = checkExecutableExists;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("ProcessExecution: ");
        buf.append("executable=[").append(this.executable);
        buf.append("], args=[").append(this.arguments);
        buf.append("], env-vars=[").append(this.environmentVariables);
        buf.append("], working-dir=[").append(this.workingDirectory);
        buf.append("], wait=[").append(this.waitForCompletion);
        buf.append("], capture-output=[").append(this.captureOutput);
        buf.append("], kill-on-timeout=[").append(this.killOnTimeout);
        buf.append("], executable-is-command=[").append(this.checkExecutableExists);
        buf.append("]");
        return buf.toString();
    }
}

