/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import javax.persistence.Column;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import org.hibernate.AnnotationException;
import org.hibernate.cfg.AbstractPropertyHolder;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.PropertyData;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;

public class ComponentPropertyHolder
extends AbstractPropertyHolder {
    private Component component;

    @Override
    public String getEntityName() {
        return this.component.getComponentClassName();
    }

    @Override
    public void addProperty(Property prop, Ejb3Column[] columns) {
        Table table = columns[0].getTable();
        if (!table.equals(this.component.getTable())) {
            if (this.component.getPropertySpan() == 0) {
                this.component.setTable(table);
            } else {
                throw new AnnotationException("A component cannot hold properties split into 2 different tables: " + this.getPath());
            }
        }
        this.addProperty(prop);
    }

    @Override
    public Join addJoin(JoinTable joinTableAnn, boolean noDelayInPkColumnCreation) {
        return this.parent.addJoin(joinTableAnn, noDelayInPkColumnCreation);
    }

    public ComponentPropertyHolder(Component component, String path, PropertyData inferredData, PropertyHolder parent, ExtendedMappings mappings) {
        super(path, parent, inferredData.getPropertyClass(), mappings);
        this.setCurrentProperty(inferredData.getProperty());
        this.component = component;
    }

    @Override
    public String getClassName() {
        return this.component.getComponentClassName();
    }

    @Override
    public String getEntityOwnerClassName() {
        return this.component.getOwner().getClassName();
    }

    @Override
    public Table getTable() {
        return this.component.getTable();
    }

    @Override
    public void addProperty(Property prop) {
        this.component.addProperty(prop);
    }

    @Override
    public KeyValue getIdentifier() {
        return this.component.getOwner().getIdentifier();
    }

    @Override
    public PersistentClass getPersistentClass() {
        return this.component.getOwner();
    }

    @Override
    public boolean isComponent() {
        return true;
    }

    @Override
    public boolean isEntity() {
        return false;
    }

    @Override
    public void setParentProperty(String parentProperty) {
        this.component.setParentProperty(parentProperty);
    }

    @Override
    public Column[] getOverriddenColumn(String propertyName) {
        String userPropertyName;
        Column[] result = super.getOverriddenColumn(propertyName);
        if (result == null && (userPropertyName = this.extractUserPropertyName("id", propertyName)) != null) {
            result = super.getOverriddenColumn(userPropertyName);
        }
        if (result == null && (userPropertyName = this.extractUserPropertyName("_identifierMapper", propertyName)) != null) {
            result = super.getOverriddenColumn(userPropertyName);
        }
        return result;
    }

    private String extractUserPropertyName(String redundantString, String propertyName) {
        String result = null;
        String className = this.component.getOwner().getClassName();
        if (propertyName.startsWith(className) && propertyName.length() > className.length() + 2 + redundantString.length() && propertyName.substring(className.length() + 1, className.length() + 1 + redundantString.length()).equals(redundantString)) {
            result = className + propertyName.substring(className.length() + 1 + redundantString.length());
        }
        return result;
    }

    @Override
    public JoinColumn[] getOverriddenJoinColumn(String propertyName) {
        return super.getOverriddenJoinColumn(propertyName);
    }
}

