/*
 * Decompiled with CFR 0.152.
 */
package pretty;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;

public final class CVSUtil {
    private HashMap entries = new HashMap();
    private static TimeZone tz = TimeZone.getTimeZone("GMT");

    public boolean isFileModified(File file) {
        CVSEntry cVSEntry = (CVSEntry)this.entries.get(file.toString().replace(File.separatorChar, '/'));
        if (cVSEntry == null && (cVSEntry = this.loadEntriesFileFor(file)) == null) {
            return true;
        }
        return cVSEntry.equalsTime(file.lastModified()) ^ true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CVSEntry loadEntriesFileFor(File file) {
        File file2 = file.getParentFile();
        int n = 0;
        String string = null;
        BufferedReader bufferedReader = null;
        File file3 = new File(String.valueOf(String.valueOf(file2)) + "/CVS/Entries");
        if (!file3.exists()) {
            return null;
        }
        try {
            try {
                bufferedReader = new BufferedReader(new FileReader(file3));
                n = 1;
                while (true) {
                    try {
                        string = bufferedReader.readLine();
                    }
                    catch (IOException iOException) {
                        string = null;
                        break;
                    }
                    if (string == null) break;
                    if (string.startsWith("/")) {
                        try {
                            CVSEntry cVSEntry = CVSEntry.parseEntryLine(file2, string);
                            this.entries.put(cVSEntry.getFileName(), cVSEntry);
                        }
                        catch (ParseException parseException) {
                            System.err.println("Bad 'Entries' line " + n + ", '" + string + "' - " + parseException.getMessage());
                        }
                    }
                    ++n;
                }
            }
            catch (IOException iOException) {
                bufferedReader = null;
            }
            Object var8_9 = null;
            if (bufferedReader == null) return (CVSEntry)this.entries.get(file.toString().replace(File.separatorChar, '/'));
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            bufferedReader.close();
            return (CVSEntry)this.entries.get(file.toString().replace(File.separatorChar, '/'));
        }
        catch (IOException iOException) {}
        return (CVSEntry)this.entries.get(file.toString().replace(File.separatorChar, '/'));
    }

    public static class CVSEntry {
        private String fileName;
        private Date date;

        public boolean equals(Object object) {
            if (object instanceof CVSEntry) {
                return this.fileName.equals(((CVSEntry)object).getFileName());
            }
            return false;
        }

        public boolean equalsTime(long l) {
            return this.date.getTime() > l ? this.date.getTime() - l < 1000L : l - this.date.getTime() < 1000L;
        }

        private Date getDate() {
            return this.date;
        }

        public String getFileName() {
            return this.fileName;
        }

        public int hashCode() {
            return this.fileName.hashCode();
        }

        private static String parseAToken(StringTokenizer stringTokenizer) {
            String string = null;
            try {
                string = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                string = null;
            }
            return string;
        }

        public static CVSEntry parseEntryLine(File file, String string) throws ParseException {
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/", true);
            int n = stringTokenizer.countTokens();
            if (n < 6) {
                throw new ParseException("not enough tokens in entries line (min 6, parsed " + n + ")", 0);
            }
            string2 = CVSEntry.parseAToken(stringTokenizer);
            string3 = CVSEntry.parseAToken(stringTokenizer);
            if (string3 == null) {
                throw new ParseException("could not parse entry name", 0);
            }
            if (string3.equals("/")) {
                throw new ParseException("entry has an empty name", 0);
            }
            string2 = CVSEntry.parseAToken(stringTokenizer);
            if (string2 == null || !string2.equals("/")) {
                throw new ParseException("could not parse version's starting slash", 0);
            }
            string4 = CVSEntry.parseAToken(stringTokenizer);
            if (string4 == null) {
                throw new ParseException("out of tokens getting version field", 0);
            }
            if (string4.equals("/")) {
                string4 = "";
            } else {
                string2 = CVSEntry.parseAToken(stringTokenizer);
                if (string2 == null || !string2.equals("/")) {
                    throw new ParseException("could not parse conflict's starting slash", 0);
                }
            }
            string5 = CVSEntry.parseAToken(stringTokenizer);
            if (string5 == null) {
                throw new ParseException("out of tokens getting conflict field", 0);
            }
            if (string5.equals("/")) {
                string5 = "";
            } else {
                string2 = CVSEntry.parseAToken(stringTokenizer);
                if (string2 == null || !string2.equals("/")) {
                    throw new ParseException("could not parse options' starting slash", 0);
                }
            }
            string6 = CVSEntry.parseAToken(stringTokenizer);
            if (string6 == null) {
                throw new ParseException("out of tokens getting options field", 0);
            }
            if (string6.equals("/")) {
                string6 = "";
            } else {
                string2 = CVSEntry.parseAToken(stringTokenizer);
                if (string2 == null || !string2.equals("/")) {
                    throw new ParseException("could not parse tag's starting slash", 0);
                }
            }
            string7 = CVSEntry.parseAToken(stringTokenizer);
            if (string7 == null || string7.equals("/")) {
                string7 = "";
            }
            CVSEntry cVSEntry = new CVSEntry();
            string3 = String.valueOf(file.toString()) + "/" + string3;
            cVSEntry.fileName = string3.replace(File.separatorChar, '/');
            cVSEntry.setTimestamp(string5);
            return cVSEntry;
        }

        public Date parseTimestamp(String string) throws ParseException {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", Locale.US);
            simpleDateFormat.setTimeZone(tz);
            Date date = simpleDateFormat.parse(string, new ParsePosition(0));
            if (date == null) {
                throw new ParseException("invalid timestamp '" + string + "'", 0);
            }
            return date;
        }

        public void setTimestamp(String string) {
            block12: {
                String string2 = new String(string);
                String string3 = null;
                if (string2.length() < 1) {
                    this.date = null;
                } else if (string2.startsWith("+")) {
                    string3 = string2.substring(1);
                    if (string3.equals("=")) {
                        string3 = "";
                    }
                } else {
                    int n = string2.indexOf(43);
                    if (n < 0) {
                        this.date = null;
                    } else {
                        string3 = string2.substring(n + 1);
                        string2 = string2.substring(0, n);
                        this.date = null;
                        if (string2.equals("Result of merge")) {
                            if ((string == null || string.length() == 0) && string3.length() > 0) {
                                string = string3;
                            }
                        } else {
                            string = string2;
                        }
                    }
                }
                if (this.date != null || string.length() <= 0) break block12;
                try {
                    this.date = this.parseTimestamp(string);
                }
                catch (ParseException parseException) {
                    this.date = null;
                }
            }
        }

        public String toString() {
            return "fileName=" + this.fileName + " date=" + this.date;
        }
    }
}

