/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.reflect.opt;

import com.sun.xml.bind.Util;
import com.sun.xml.bind.v2.runtime.reflect.Accessor;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

final class Injector {
    private static final Map<ClassLoader, Injector> injectors = Collections.synchronizedMap(new WeakHashMap());
    private static final Logger logger = Util.getClassLogger();
    private final Map<String, WeakReference<Class>> classes = new HashMap<String, WeakReference<Class>>();
    private final boolean loadable;
    private static final Method defineClass;
    private static final Method resolveClass;

    static Class inject(ClassLoader cl, String className, byte[] image) {
        Injector injector = Injector.get(cl);
        if (injector != null) {
            return injector.internalInject(cl, className, image);
        }
        return null;
    }

    static Class find(ClassLoader cl, String className) {
        Injector injector = Injector.get(cl);
        if (injector != null) {
            return injector.internalFind(cl, className);
        }
        return null;
    }

    private static Injector get(ClassLoader cl) {
        Injector injector = injectors.get(cl);
        if (injector == null) {
            try {
                injector = new Injector(cl);
                injectors.put(cl, injector);
            }
            catch (SecurityException e) {
                logger.log(Level.FINE, "Unable to set up a back-door for the injector", e);
                return null;
            }
        }
        return injector;
    }

    private Injector(ClassLoader parent) {
        assert (parent != null);
        boolean loadable = false;
        try {
            loadable = parent.loadClass(Accessor.class.getName()) == Accessor.class;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.loadable = loadable;
    }

    private synchronized Class internalInject(ClassLoader parent, String className, byte[] image) {
        if (!this.loadable) {
            return null;
        }
        Class c = null;
        WeakReference<Class> ref = this.classes.get(className);
        if (ref != null) {
            c = (Class)ref.get();
        }
        if (c == null) {
            try {
                c = (Class)defineClass.invoke((Object)parent, className.replace('/', '.'), image, 0, image.length);
                resolveClass.invoke((Object)parent, c);
            }
            catch (IllegalAccessException e) {
                logger.log(Level.FINE, "Unable to inject " + className, e);
                return null;
            }
            catch (InvocationTargetException e) {
                logger.log(Level.FINE, "Unable to inject " + className, e);
                return null;
            }
            catch (SecurityException e) {
                logger.log(Level.FINE, "Unable to inject " + className, e);
                return null;
            }
            catch (LinkageError e) {
                logger.log(Level.FINE, "Unable to inject " + className, e);
                return null;
            }
            this.classes.put(className, new WeakReference<Class>(c));
        }
        return c;
    }

    private synchronized Class internalFind(ClassLoader parent, String className) {
        Class<?> clazz = null;
        WeakReference<Class> ref = this.classes.get(className);
        if (ref != null && (clazz = (Class<?>)ref.get()) == null) {
            try {
                clazz = parent.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                logger.log(Level.FINE, "Unable to load " + className, e);
            }
        }
        return clazz;
    }

    static {
        try {
            defineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            resolveClass = ClassLoader.class.getDeclaredMethod("resolveClass", Class.class);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                defineClass.setAccessible(true);
                resolveClass.setAccessible(true);
                return null;
            }
        });
    }
}

