/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.configuration.PlexusConfigurationResourceException;

public class PlexusContainerHost
implements Runnable {
    private DefaultPlexusContainer container;
    private boolean shouldStop;
    private boolean isStopped;
    private Object shutdownSignal = new Object();

    public PlexusContainer start(ClassWorld classWorld, String configurationResource) throws FileNotFoundException, PlexusConfigurationResourceException, PlexusContainerException {
        this.container = this.getPlexusContainer();
        this.container.setClassWorld(classWorld);
        this.container.setConfigurationResource(new FileReader(configurationResource));
        this.customizeContainer(this.container);
        File plexusLogs = new File(System.getProperty("plexus.home") + "/logs");
        if (!plexusLogs.exists()) {
            plexusLogs.mkdirs();
        }
        this.container.initialize();
        this.container.start();
        Thread thread = new Thread(this);
        thread.setDaemon(false);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                try {
                    PlexusContainerHost.this.shutdown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }));
        thread.start();
        return this.container;
    }

    protected DefaultPlexusContainer getPlexusContainer() {
        return new DefaultPlexusContainer();
    }

    protected void customizeContainer(PlexusContainer container) {
        container.addContextValue("plexus.home", System.getProperty("plexus.home"));
        container.addContextValue("plexus.work", System.getProperty("plexus.home") + "/work");
        container.addContextValue("plexus.logs", System.getProperty("plexus.home") + "/logs");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        PlexusContainerHost plexusContainerHost = this;
        synchronized (plexusContainerHost) {
            while (!this.shouldStop) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        plexusContainerHost = this;
        synchronized (plexusContainerHost) {
            this.isStopped = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        PlexusContainerHost plexusContainerHost = this;
        synchronized (plexusContainerHost) {
            this.shouldStop = true;
            this.container.dispose();
            this.notifyAll();
        }
        plexusContainerHost = this;
        synchronized (plexusContainerHost) {
            while (!this.isStopped()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            Object object = this.shutdownSignal;
            synchronized (object) {
                this.shutdownSignal.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForContainerShutdown() {
        while (!this.isStopped()) {
            try {
                Object object = this.shutdownSignal;
                synchronized (object) {
                    this.shutdownSignal.wait();
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public static void main(String[] args, ClassWorld classWorld) {
        if (args.length != 1) {
            System.err.println("usage: plexus <plexus.conf>");
            System.exit(1);
        }
        try {
            PlexusContainerHost host = new PlexusContainerHost();
            host.start(classWorld, args[0]);
            host.waitForContainerShutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
    }
}

