/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.webdav.ui;

import hidden.org.apache.commons.httpclient.HttpURL;
import hidden.org.apache.commons.httpclient.HttpsURL;
import hidden.org.apache.commons.httpclient.URIException;
import hidden.org.apache.webdav.lib.WebdavResource;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;

public class WebdavSystemView
extends FileSystemView {
    private WebdavResource webdavResource = null;
    private HttpURL rootURL = null;
    private WebdavFile homedir = null;
    private String username = null;
    private String password = null;
    private String uri = null;
    private String rootPath = null;
    private static final String newFolderString = UIManager.getString("FileChooser.other.newFolder");
    static FileSystemView fsv = null;

    public WebdavSystemView(String uri, String rootPath, String username, String password) throws IllegalAccessError, URIException, IOException {
        try {
            this.rootURL = WebdavSystemView.uriToHttpURL(uri + rootPath);
            this.uri = uri;
            this.rootURL.setUserinfo(username, password);
            this.username = username;
            this.password = password;
            this.rootPath = rootPath;
            this.connect();
            this.disconnect();
            this.homedir = new WebdavFile(this.rootURL, this.rootURL);
        }
        catch (IllegalAccessError e) {
            System.err.println(e.toString());
            e.printStackTrace();
            throw e;
        }
        catch (URIException e) {
            System.err.println(e.toString());
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            System.err.println(e.toString());
            e.printStackTrace();
            throw e;
        }
    }

    private static HttpURL uriToHttpURL(String uri) throws URIException {
        HttpURL url = null;
        if (uri.startsWith("http://")) {
            url = new HttpURL(uri);
        } else if (uri.startsWith("https://")) {
            url = new HttpsURL(uri);
        } else {
            throw new URIException("Unknown protocol in URL " + uri);
        }
        return url;
    }

    public void disconnect() throws UnknownError {
        try {
            this.webdavResource.close();
        }
        catch (Exception e) {
            System.err.println(e.toString());
            throw new UnknownError();
        }
    }

    public void connect() throws IllegalAccessError {
        try {
            this.webdavResource = new WebdavResource(this.rootURL);
        }
        catch (Exception e) {
            System.err.println(e.toString());
            throw new IllegalAccessError();
        }
    }

    public static FileSystemView getFileSystemView() {
        try {
            if (fsv == null) {
                fsv = new WebdavSystemView("http://127.0.0.1", "/", "", "");
            }
            return fsv;
        }
        catch (Exception e) {
            System.err.println(e.toString());
            return null;
        }
    }

    public File createFileObject(File dir, String filename) {
        File file = null;
        file = dir == null ? new File(filename) : new File(dir, filename);
        return file;
    }

    public File createFileObject(String path) {
        File f = new File(path);
        if (this.isFileSystemRoot(f)) {
            f = this.createFileSystemRoot(f);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createNewFolder(File containingDir) throws IOException {
        try {
            if (containingDir == null) {
                throw new IOException("Containing directory is null:");
            }
            WebdavFile newFolder = null;
            HttpURL url = null;
            url = WebdavSystemView.uriToHttpURL(containingDir.getPath() + WebdavFile.davSeparator + newFolderString);
            url.setUserinfo(this.username, this.password);
            newFolder = new WebdavFile(url, this.rootURL);
            this.connect();
            if (this.webdavResource.mkcolMethod(newFolder.getAbsolutePath())) {
                WebdavFile webdavFile = newFolder;
                return webdavFile;
            }
            try {
                System.err.println("failed.");
                System.err.println(this.webdavResource.getStatusMessage());
                throw new IOException(this.webdavResource.getStatusMessage());
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                System.err.println(e.toString());
                e.printStackTrace();
                File file = null;
                return file;
            }
        }
        finally {
            this.disconnect();
        }
    }

    public File[] getRoots() {
        try {
            return new WebdavFile[]{this.homedir};
        }
        catch (Exception e) {
            System.err.println(e.toString());
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean isTraversable(File f) {
        try {
            Boolean bl = f.isDirectory() ? Boolean.TRUE : Boolean.FALSE;
            return bl;
        }
        catch (Exception e) {
            System.err.println(e.toString());
            e.printStackTrace();
            Boolean bl = Boolean.FALSE;
            return bl;
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSystemDisplayName(File f) {
        try {
            String string = f.getName();
            return string;
        }
        catch (Exception e) {
            System.err.println(e.toString());
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            this.disconnect();
        }
    }

    public String getSystemTypeDescription(File f) {
        return null;
    }

    public boolean isFileSystem(File f) {
        return true;
    }

    public boolean isHiddenFile(File f) {
        return f.isHidden();
    }

    public boolean isFileSystemRoot(File dir) {
        try {
            return this.rootURL.getPath().equals(dir.getPath());
        }
        catch (Exception e) {
            System.err.println("isFileSystemRoot" + e.toString());
            e.printStackTrace();
            return false;
        }
    }

    public boolean isDrive(File dir) {
        return false;
    }

    public boolean isFloppyDrive(File dir) {
        return false;
    }

    public boolean isComputerNode(File dir) {
        return false;
    }

    public File getHomeDirectory() {
        return this.homedir;
    }

    public File getDefaultDirectory() {
        return this.homedir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] getFiles(File dir, boolean useFileHiding) {
        try {
            String[] filenames = null;
            File[] files = null;
            HttpURL url = null;
            String path = null;
            String localDir = null;
            this.connect();
            path = dir.getPath();
            if (path.startsWith("http")) {
                path = path.replaceAll(this.uri, "");
            }
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            this.webdavResource.setPath(path);
            filenames = this.webdavResource.list();
            files = new WebdavFile[filenames.length];
            for (int i = 0; i < filenames.length; ++i) {
                localDir = dir.getPath();
                if (!localDir.endsWith("/")) {
                    localDir = localDir + "/";
                }
                String filepath = localDir + filenames[i];
                url = WebdavSystemView.uriToHttpURL(filepath);
                url.setUserinfo(this.username, this.password);
                files[i] = new WebdavFile(url, this.rootURL);
            }
            File[] fileArray = files;
            return fileArray;
        }
        catch (Exception e) {
            System.err.println(e.toString());
            e.printStackTrace();
            File[] fileArray = null;
            return fileArray;
        }
        finally {
            this.disconnect();
        }
    }

    public File getParentDirectory(File dir) {
        if (dir == null) {
            return null;
        }
        if (dir.equals(this.homedir)) {
            return this.homedir;
        }
        return dir.getParentFile();
    }

    protected File createFileSystemRoot(File f) {
        try {
            return new FileSystemRoot((WebdavFile)f);
        }
        catch (Exception e) {
            System.err.println("createFileSystemRoot : " + e.toString());
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        JFrame frame = new JFrame();
        JFileChooser fc = new JFileChooser(new WebdavSystemView("http://localhost:8080", "/slide/files", "root", "root"));
        fc.showOpenDialog(frame);
    }

    static class FileSystemRoot
    extends WebdavFile {
        public FileSystemRoot(HttpURL rootUrl) throws URIException, IOException {
            super(rootUrl, rootUrl);
        }

        public FileSystemRoot(WebdavFile webdavFile) throws URIException, IOException {
            super(webdavFile.rootUrl, webdavFile.rootUrl);
        }
    }

    static class WebdavFile
    extends hidden.org.apache.webdav.lib.WebdavFile {
        protected WebdavResource webdavResource = null;
        protected HttpURL rootUrl = null;

        public WebdavFile(HttpURL pathUrl, HttpURL rootUrl) throws URIException, IOException {
            super(pathUrl);
            this.webdavResource = new WebdavResource(pathUrl);
            this.rootUrl = rootUrl;
        }

        public String getName() {
            String name = null;
            name = super.getName();
            if (this.isDirectory()) {
                name = name + "/";
            }
            return name;
        }

        public boolean isRoot() {
            try {
                String path = null;
                String root = null;
                root = this.rootUrl.getPath();
                path = this.webdavResource.getHttpURL().getPath();
                return root.equalsIgnoreCase(path);
            }
            catch (Exception e) {
                System.err.println(e.toString());
                e.printStackTrace();
                return false;
            }
        }

        public String getParent() {
            try {
                if (this.isRoot()) {
                    return null;
                }
                String escapedPath = this.webdavResource.getHttpURL().getPath();
                String parent = escapedPath.substring(0, escapedPath.lastIndexOf(47, escapedPath.length() - 2) + 1);
                return super.getParent();
            }
            catch (Exception e) {
                System.err.println(e.toString());
                e.printStackTrace();
                return null;
            }
        }

        public File getParentFile() {
            try {
                HttpURL httpURL = null;
                String parent = null;
                parent = this.getParent();
                if (parent == null) {
                    return null;
                }
                httpURL = this.rootUrl;
                httpURL.setPath(parent);
                return new WebdavFile(httpURL, this.rootUrl);
            }
            catch (Exception e) {
                System.err.println(e.toString());
                e.printStackTrace();
                return null;
            }
        }

        public boolean exists() {
            return this.webdavResource.exists();
        }

        public boolean isDirectory() {
            return this.webdavResource.isCollection();
        }
    }
}

