/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.array;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.aop.array.ArrayReference;
import org.jboss.aop.array.ArrayReferenceImpl;
import org.jboss.aop.array.ArrayRegistryEntry;
import org.jboss.aop.array.ElementArrayRegistryEntry;
import org.jboss.aop.array.FieldArrayRegistryEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayRegistry {
    private static final ArrayRegistryEntryFactory ELEMENT_ARRAY_REGISTRY_ENTRY_FACTORY = new ElementArrayRegistryEntryFactory();
    private static final ArrayRegistryEntryFactory FIELD_ARRAY_REGISTRY_ENTRY_FACTORY = new FieldArrayRegistryEntryFactory();
    private ArrayReferenceBuilder referenceBuilder = new ArrayReferenceBuilder();
    private static ArrayRegistry singleton = new ArrayRegistry();
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private WeakHashMap<Object, WeakHashMap<Object, HashMap<Object, ArrayRegistryEntry>>> cache = new WeakHashMap();

    public static ArrayRegistry getInstance() {
        return singleton;
    }

    private ArrayRegistry() {
    }

    public void addFieldReference(Object owner, String fieldName, Object array) {
        if (array == null) {
            return;
        }
        this.addReference(owner, fieldName, array, FIELD_ARRAY_REGISTRY_ENTRY_FACTORY);
    }

    public void addElementReference(Object owner, int index, Object array) {
        if (array == null) {
            return;
        }
        this.addReference(owner, new Integer(index), array, ELEMENT_ARRAY_REGISTRY_ENTRY_FACTORY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReference(Object owner, Object qualifier, Object array, ArrayRegistryEntryFactory factory) {
        if (array == null) {
            return;
        }
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            ArrayRegistryEntry regEntry;
            HashMap<Object, ArrayRegistryEntry> ownerReferences;
            WeakHashMap<Object, HashMap<Object, ArrayRegistryEntry>> arrayReferences = this.cache.get(array);
            if (arrayReferences == null) {
                arrayReferences = new WeakHashMap();
                this.cache.put(array, arrayReferences);
            }
            if ((ownerReferences = arrayReferences.get(owner)) == null) {
                ownerReferences = new HashMap();
                arrayReferences.put(owner, ownerReferences);
            }
            if ((regEntry = ownerReferences.get(qualifier)) == null || regEntry.getArray() != array) {
                ArrayRegistryEntry entry = factory.createArrayRegistryEntry(owner, qualifier, factory);
                ownerReferences.put(qualifier, entry);
            }
            this.addNestedArrays(array);
        }
        finally {
            writeLock.unlock();
        }
    }

    public void removeFieldReference(Object owner, String fieldName, Object array) {
        if (array == null) {
            return;
        }
        this.removeReference(owner, fieldName, array);
    }

    public void removeElementReference(Object owner, int index, Object array) {
        if (array == null) {
            return;
        }
        this.removeReference(owner, new Integer(index), array);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReference(Object owner, Object qualifier, Object array) {
        if (array == null) {
            return;
        }
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            ArrayRegistryEntry regEntry;
            HashMap<Object, ArrayRegistryEntry> ownerReferences;
            WeakHashMap<Object, HashMap<Object, ArrayRegistryEntry>> arrayReferences = this.cache.get(array);
            if (arrayReferences != null && (ownerReferences = arrayReferences.get(owner)) != null && (regEntry = ownerReferences.remove(qualifier)) != null) {
                if (ownerReferences.size() == 0) {
                    arrayReferences.remove(owner);
                    if (arrayReferences.size() == 0) {
                        this.cache.remove(array);
                    }
                }
                this.removeNestedArrays(array);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegistered(Object array) {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            WeakHashMap<Object, HashMap<Object, ArrayRegistryEntry>> arrayReferences = this.cache.get(array);
            if (arrayReferences == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ArrayReference> getArrayOwners(Object array) {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            List list = this.referenceBuilder.getArrayReferences(array);
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    private void addNestedArrays(Object array) {
        block4: {
            ArrayType type;
            block3: {
                if (array == null) {
                    return;
                }
                type = this.isArray(array);
                if (type != ArrayType.MULTIDIM_ARRAY) break block3;
                for (int i = 0; i < ((Object[])array).length; ++i) {
                    this.addElementReference(array, i, ((Object[])array)[i]);
                    this.addNestedArrays(((Object[])array)[i]);
                }
                break block4;
            }
            if (type != ArrayType.OBJECT_ARRAY) break block4;
            for (int i = 0; i < ((Object[])array).length; ++i) {
                Object val = ((Object[])array)[i];
                if (val == null || !val.getClass().isArray()) continue;
                this.addElementReference(array, i, ((Object[])array)[i]);
                this.addNestedArrays(((Object[])array)[i]);
            }
        }
    }

    private void removeNestedArrays(Object array) {
        block4: {
            ArrayType type;
            block3: {
                if (array == null) {
                    return;
                }
                type = this.isArray(array);
                if (type != ArrayType.MULTIDIM_ARRAY) break block3;
                for (int i = 0; i < ((Object[])array).length; ++i) {
                    this.removeElementReference(array, i, ((Object[])array)[i]);
                    this.removeNestedArrays(((Object[])array)[i]);
                }
                break block4;
            }
            if (type != ArrayType.OBJECT_ARRAY) break block4;
            for (int i = 0; i < ((Object[])array).length; ++i) {
                Object val = ((Object[])array)[i];
                if (val == null || !val.getClass().isArray()) continue;
                this.removeElementReference(array, i, ((Object[])array)[i]);
                this.removeNestedArrays(((Object[])array)[i]);
            }
        }
    }

    private ArrayType isArray(Object arrayCandidate) {
        Class<?> candidateClass = arrayCandidate.getClass();
        if (candidateClass.isArray()) {
            Class<?> componentType = candidateClass.getComponentType();
            if (componentType.isArray()) {
                return ArrayType.MULTIDIM_ARRAY;
            }
            if (componentType == Object.class) {
                return ArrayType.OBJECT_ARRAY;
            }
        }
        return ArrayType.NOT_ARRAY;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ArrayType {
        NOT_ARRAY,
        MULTIDIM_ARRAY,
        OBJECT_ARRAY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArrayReferenceBuilder {
        private ArrayReferenceBuilder() {
        }

        private List<ArrayReference> getArrayReferences(Object array) {
            ArrayList<ArrayReference> references = null;
            WeakHashMap arrayReferences = (WeakHashMap)ArrayRegistry.this.cache.get(array);
            if (arrayReferences != null && arrayReferences.size() > 0) {
                for (Object owner : arrayReferences.keySet()) {
                    HashMap ownerReferences = (HashMap)arrayReferences.get(owner);
                    for (Object qualifier : ownerReferences.keySet()) {
                        ArrayRegistryEntry regEntry = (ArrayRegistryEntry)ownerReferences.get(qualifier);
                        if (regEntry.isOwnerRoot()) {
                            ArrayReference reference = this.getRootReference((FieldArrayRegistryEntry)regEntry);
                            if (reference == null) continue;
                            if (references == null) {
                                references = new ArrayList<ArrayReference>();
                            }
                            references.add(reference);
                            continue;
                        }
                        List<ArrayReference> parentReferences = this.getElementReferences((ElementArrayRegistryEntry)regEntry);
                        if (parentReferences == null) continue;
                        if (references == null) {
                            references = new ArrayList();
                        }
                        references.addAll(parentReferences);
                    }
                }
            }
            return references;
        }

        private ArrayReference getRootReference(FieldArrayRegistryEntry regEntry) {
            Object root = regEntry.getOwner();
            if (root != null) {
                String fieldName = regEntry.getFieldName();
                return new ArrayReferenceImpl(root, fieldName);
            }
            return null;
        }

        private List<ArrayReference> getElementReferences(ElementArrayRegistryEntry regEntry) {
            Object ownerArray = regEntry.getOwner();
            if (ownerArray != null) {
                List<ArrayReference> references = this.getArrayReferences(ownerArray);
                if (references != null && references.size() > 0) {
                    for (ArrayReference reference : references) {
                        ((ArrayReferenceImpl)reference).addNestedArrayIndex(regEntry.getIndex());
                    }
                }
                return references;
            }
            return null;
        }
    }

    private static class ElementArrayRegistryEntryFactory
    implements ArrayRegistryEntryFactory {
        private ElementArrayRegistryEntryFactory() {
        }

        public ArrayRegistryEntry createArrayRegistryEntry(Object owner, Object qualifier, Object array) {
            return new ElementArrayRegistryEntry(owner, (Integer)qualifier, array);
        }
    }

    private static class FieldArrayRegistryEntryFactory
    implements ArrayRegistryEntryFactory {
        private FieldArrayRegistryEntryFactory() {
        }

        public ArrayRegistryEntry createArrayRegistryEntry(Object owner, Object qualifier, Object array) {
            return new FieldArrayRegistryEntry(owner, (String)qualifier, array);
        }
    }

    private static interface ArrayRegistryEntryFactory {
        public ArrayRegistryEntry createArrayRegistryEntry(Object var1, Object var2, Object var3);
    }
}

