/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.cluster.impl;

import java.util.HashSet;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.management.ManagementHelper;
import org.hornetq.api.core.management.NotificationType;
import org.hornetq.core.client.impl.ClientSessionFactoryInternal;
import org.hornetq.core.client.impl.ServerLocatorInternal;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.message.impl.MessageImpl;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.postoffice.BindingType;
import org.hornetq.core.remoting.FailureListener;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.cluster.ClusterConnection;
import org.hornetq.core.server.cluster.MessageFlowRecord;
import org.hornetq.core.server.cluster.Transformer;
import org.hornetq.core.server.cluster.impl.BridgeImpl;
import org.hornetq.core.server.cluster.impl.ClusterManagerInternal;
import org.hornetq.utils.UUID;
import org.hornetq.utils.UUIDGenerator;

public class ClusterConnectionBridge
extends BridgeImpl {
    private static final Logger log = Logger.getLogger(ClusterConnectionBridge.class);
    private static final boolean isTrace = log.isTraceEnabled();
    private final ClusterConnection clusterConnection;
    private final ClusterManagerInternal clusterManager;
    private final MessageFlowRecord flowRecord;
    private final SimpleString managementAddress;
    private final SimpleString managementNotificationAddress;
    private ClientConsumer notifConsumer;
    private final SimpleString idsHeaderName;
    private final String targetNodeID;
    private final long targetNodeEventUID;
    private final ServerLocatorInternal discoveryLocator;

    public ClusterConnectionBridge(ClusterConnection clusterConnection, ClusterManagerInternal clusterManager, ServerLocatorInternal targetLocator, ServerLocatorInternal discoveryLocator, int reconnectAttempts, long retryInterval, double retryMultiplier, long maxRetryInterval, UUID nodeUUID, long targetNodeEventUID, String targetNodeID, SimpleString name, Queue queue, Executor executor, SimpleString filterString, SimpleString forwardingAddress, ScheduledExecutorService scheduledExecutor, Transformer transformer, boolean useDuplicateDetection, String user, String password, boolean activated, StorageManager storageManager, SimpleString managementAddress, SimpleString managementNotificationAddress, MessageFlowRecord flowRecord, TransportConfiguration connector) throws Exception {
        super(targetLocator, reconnectAttempts, retryInterval, retryMultiplier, maxRetryInterval, nodeUUID, name, queue, executor, filterString, forwardingAddress, scheduledExecutor, transformer, useDuplicateDetection, user, password, activated, storageManager);
        this.discoveryLocator = discoveryLocator;
        this.idsHeaderName = MessageImpl.HDR_ROUTE_TO_IDS.concat(name);
        this.clusterConnection = clusterConnection;
        this.clusterManager = clusterManager;
        this.targetNodeEventUID = targetNodeEventUID;
        this.targetNodeID = targetNodeID;
        this.managementAddress = managementAddress;
        this.managementNotificationAddress = managementNotificationAddress;
        this.flowRecord = flowRecord;
        queue.setInternalQueue(true);
        if (log.isDebugEnabled()) {
            log.debug("Setting up bridge between " + clusterConnection.getConnector() + " and " + targetLocator, new Exception("trace"));
        }
    }

    @Override
    protected ClientSessionFactoryInternal createSessionFactory() throws Exception {
        ClientSessionFactoryInternal factory = (ClientSessionFactoryInternal)this.serverLocator.createSessionFactory(this.targetNodeID);
        if (factory == null) {
            log.warn("NodeID=" + this.targetNodeID + " is not available on the topology. Retrying the connection to that node now");
            return null;
        }
        factory.setReconnectAttempts(0);
        factory.getConnection().addFailureListener(new FailureListener(){

            @Override
            public void connectionFailed(HornetQException exception, boolean failedOver) {
                if (exception.getCode() == 4) {
                    ClusterConnectionBridge.this.flowRecord.serverDisconnected();
                    ClusterConnectionBridge.this.clusterManager.removeClusterLocator(ClusterConnectionBridge.this.serverLocator);
                }
            }
        });
        return factory;
    }

    @Override
    protected ServerMessage beforeForward(ServerMessage message) {
        ServerMessage messageCopy = message.copy();
        if (log.isTraceEnabled()) {
            log.trace("Clustered bridge  copied message " + message + " as " + messageCopy + " before delivery");
        }
        HashSet<SimpleString> propNames = new HashSet<SimpleString>(messageCopy.getPropertyNames());
        byte[] queueIds = message.getBytesProperty(this.idsHeaderName);
        if (queueIds == null) {
            log.warn("no queue IDs defined!,  originalMessage  = " + message + ", copiedMessage = " + messageCopy + ", props=" + this.idsHeaderName);
            throw new IllegalStateException("no queueIDs defined");
        }
        for (SimpleString propName : propNames) {
            if (!propName.startsWith(MessageImpl.HDR_ROUTE_TO_IDS)) continue;
            messageCopy.removeProperty(propName);
        }
        messageCopy.putBytesProperty(MessageImpl.HDR_ROUTE_TO_IDS, queueIds);
        messageCopy = super.beforeForward(messageCopy);
        return messageCopy;
    }

    private void setupNotificationConsumer() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Setting up notificationConsumer between " + this.clusterConnection.getConnector() + " and " + this.flowRecord.getBridge().getForwardingConnection() + " clusterConnection = " + this.clusterConnection.getName() + " on server " + this.clusterConnection.getServer());
        }
        if (this.flowRecord != null) {
            this.flowRecord.reset();
            if (this.notifConsumer != null) {
                try {
                    log.debug("Closing notification Consumer for reopening " + this.notifConsumer + " on bridge " + this.getName());
                    this.notifConsumer.close();
                    this.notifConsumer = null;
                }
                catch (HornetQException e) {
                    log.error("Failed to close consumer", e);
                }
            }
            String qName = "notif." + UUIDGenerator.getInstance().generateStringUUID() + "." + this.clusterConnection.getServer();
            SimpleString notifQueueName = new SimpleString(qName);
            SimpleString filter = new SimpleString(ManagementHelper.HDR_BINDING_TYPE + "<>" + BindingType.DIVERT.toInt() + " AND " + ManagementHelper.HDR_NOTIFICATION_TYPE + " IN ('" + (Object)((Object)NotificationType.BINDING_ADDED) + "','" + (Object)((Object)NotificationType.BINDING_REMOVED) + "','" + (Object)((Object)NotificationType.CONSUMER_CREATED) + "','" + (Object)((Object)NotificationType.CONSUMER_CLOSED) + "','" + (Object)((Object)NotificationType.PROPOSAL) + "','" + (Object)((Object)NotificationType.PROPOSAL_RESPONSE) + "') AND " + ManagementHelper.HDR_DISTANCE + "<" + this.flowRecord.getMaxHops() + " AND (" + ManagementHelper.HDR_ADDRESS + " LIKE '" + this.flowRecord.getAddress() + "%')");
            this.session.createTemporaryQueue(this.managementNotificationAddress, notifQueueName, filter);
            this.notifConsumer = this.session.createConsumer(notifQueueName);
            this.notifConsumer.setMessageHandler(this.flowRecord);
            this.session.start();
            ClientMessage message = this.session.createMessage(false);
            log.debug("Requesting sendQueueInfoToQueue through " + this, new Exception("trace"));
            ManagementHelper.putOperationInvocation(message, "core.server", "sendQueueInfoToQueue", notifQueueName.toString(), this.flowRecord.getAddress());
            ClientProducer prod = this.session.createProducer(this.managementAddress);
            if (log.isDebugEnabled()) {
                log.debug("Cluster connetion bridge on " + this.clusterConnection + " requesting information on queues");
            }
            prod.send(message);
        }
    }

    @Override
    protected void afterConnect() throws Exception {
        super.afterConnect();
        this.setupNotificationConsumer();
    }

    @Override
    public void stop() throws Exception {
        super.stop();
    }

    @Override
    protected void tryScheduleRetryReconnect(int code) {
        if (code != 4) {
            this.scheduleRetryConnect();
        }
    }

    @Override
    protected void fail(boolean permanently) {
        log.debug("Cluster Bridge " + this.getName() + " failed, permanently=" + permanently);
        super.fail(permanently);
        if (permanently) {
            log.debug("cluster node for bridge " + this.getName() + " is permanently down");
            this.discoveryLocator.notifyNodeDown(System.currentTimeMillis(), this.targetNodeID);
        }
    }
}

