/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.replication.impl;

import java.util.LinkedHashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.SessionFailureListener;
import org.hornetq.core.client.impl.ClientSessionFactoryInternal;
import org.hornetq.core.journal.EncodingSupport;
import org.hornetq.core.journal.JournalLoadInformation;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.paging.PagedMessage;
import org.hornetq.core.persistence.OperationContext;
import org.hornetq.core.persistence.impl.journal.OperationContextImpl;
import org.hornetq.core.protocol.core.Channel;
import org.hornetq.core.protocol.core.ChannelHandler;
import org.hornetq.core.protocol.core.CoreRemotingConnection;
import org.hornetq.core.protocol.core.Packet;
import org.hornetq.core.protocol.core.impl.wireformat.CreateReplicationSessionMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationAddMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationAddTXMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationCommitMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationCompareDataMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationDeleteMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationDeleteTXMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationLargeMessageBeingMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationLargeMessageWriteMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationLargemessageEndMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationPageEventMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationPageWriteMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationPrepareMessage;
import org.hornetq.core.replication.ReplicationManager;
import org.hornetq.utils.ExecutorFactory;

public class ReplicationManagerImpl
implements ReplicationManager {
    private static final Logger log = Logger.getLogger(ReplicationManagerImpl.class);
    private final ResponseHandler responseHandler = new ResponseHandler();
    private final ClientSessionFactoryInternal sessionFactory;
    private CoreRemotingConnection replicatingConnection;
    private Channel replicatingChannel;
    private boolean started;
    private volatile boolean enabled;
    private final Object replicationLock = new Object();
    private final Queue<OperationContext> pendingTokens = new ConcurrentLinkedQueue<OperationContext>();
    private final ExecutorFactory executorFactory;
    private SessionFailureListener failureListener;

    public ReplicationManagerImpl(ClientSessionFactoryInternal sessionFactory, ExecutorFactory executorFactory) {
        this.sessionFactory = sessionFactory;
        this.executorFactory = executorFactory;
    }

    @Override
    public void appendAddRecord(byte journalID, long id, byte recordType, EncodingSupport record) {
        if (this.enabled) {
            this.sendReplicatePacket(new ReplicationAddMessage(journalID, false, id, recordType, record));
        }
    }

    @Override
    public void appendUpdateRecord(byte journalID, long id, byte recordType, EncodingSupport record) throws Exception {
        if (this.enabled) {
            this.sendReplicatePacket(new ReplicationAddMessage(journalID, true, id, recordType, record));
        }
    }

    @Override
    public void appendDeleteRecord(byte journalID, long id) throws Exception {
        if (this.enabled) {
            this.sendReplicatePacket(new ReplicationDeleteMessage(journalID, id));
        }
    }

    @Override
    public void appendAddRecordTransactional(byte journalID, long txID, long id, byte recordType, EncodingSupport record) throws Exception {
        if (this.enabled) {
            this.sendReplicatePacket(new ReplicationAddTXMessage(journalID, false, txID, id, recordType, record));
        }
    }

    @Override
    public void appendUpdateRecordTransactional(byte journalID, long txID, long id, byte recordType, EncodingSupport record) throws Exception {
        if (this.enabled) {
            this.sendReplicatePacket(new ReplicationAddTXMessage(journalID, true, txID, id, recordType, record));
        }
    }

    @Override
    public void appendCommitRecord(byte journalID, long txID, boolean lineUp) throws Exception {
        if (this.enabled) {
            this.sendReplicatePacket(new ReplicationCommitMessage(journalID, false, txID), lineUp);
        }
    }

    @Override
    public void appendDeleteRecordTransactional(byte journalID, long txID, long id, EncodingSupport record) throws Exception {
        if (this.enabled) {
            this.sendReplicatePacket(new ReplicationDeleteTXMessage(journalID, txID, id, record));
        }
    }

    @Override
    public void appendDeleteRecordTransactional(byte journalID, long txID, long id) throws Exception {
        if (this.enabled) {
            this.sendReplicatePacket(new ReplicationDeleteTXMessage(journalID, txID, id, NullEncoding.instance));
        }
    }

    @Override
    public void appendPrepareRecord(byte journalID, long txID, EncodingSupport transactionData) throws Exception {
        if (this.enabled) {
            this.sendReplicatePacket(new ReplicationPrepareMessage(journalID, txID, transactionData));
        }
    }

    @Override
    public void appendRollbackRecord(byte journalID, long txID) throws Exception {
        if (this.enabled) {
            this.sendReplicatePacket(new ReplicationCommitMessage(journalID, false, txID));
        }
    }

    @Override
    public void pageClosed(SimpleString storeName, int pageNumber) {
        if (this.enabled) {
            this.sendReplicatePacket(new ReplicationPageEventMessage(storeName, pageNumber, false));
        }
    }

    @Override
    public void pageDeleted(SimpleString storeName, int pageNumber) {
        if (this.enabled) {
            this.sendReplicatePacket(new ReplicationPageEventMessage(storeName, pageNumber, true));
        }
    }

    @Override
    public void pageWrite(PagedMessage message, int pageNumber) {
        if (this.enabled) {
            this.sendReplicatePacket(new ReplicationPageWriteMessage(message, pageNumber));
        }
    }

    @Override
    public void largeMessageBegin(long messageId) {
        if (this.enabled) {
            this.sendReplicatePacket(new ReplicationLargeMessageBeingMessage(messageId));
        }
    }

    @Override
    public void largeMessageDelete(long messageId) {
        if (this.enabled) {
            this.sendReplicatePacket(new ReplicationLargemessageEndMessage(messageId));
        }
    }

    @Override
    public void largeMessageWrite(long messageId, byte[] body) {
        if (this.enabled) {
            this.sendReplicatePacket(new ReplicationLargeMessageWriteMessage(messageId, body));
        }
    }

    @Override
    public synchronized boolean isStarted() {
        return this.started;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.started) {
            throw new IllegalStateException("ReplicationManager is already started");
        }
        this.replicatingConnection = this.sessionFactory.getConnection();
        if (this.replicatingConnection == null) {
            log.warn("Backup server MUST be started before live server. Initialisation will not proceed.");
            throw new HornetQException(104, "Backup server MUST be started before live server. Initialisation will not proceed.");
        }
        long channelID = this.replicatingConnection.generateChannelID();
        Channel mainChannel = this.replicatingConnection.getChannel(1L, -1);
        this.replicatingChannel = this.replicatingConnection.getChannel(channelID, -1);
        this.replicatingChannel.setHandler(this.responseHandler);
        CreateReplicationSessionMessage replicationStartPackage = new CreateReplicationSessionMessage(channelID);
        mainChannel.sendBlocking(replicationStartPackage);
        this.failureListener = new SessionFailureListener(){

            @Override
            public void connectionFailed(HornetQException me, boolean failedOver) {
                if (me.getCode() == 4) {
                    log.warn("The backup node has been shut-down, replication will now stop");
                } else {
                    log.warn("Connection to the backup node failed, removing replication now", me);
                }
                try {
                    ReplicationManagerImpl.this.stop();
                }
                catch (Exception e) {
                    log.warn(e.getMessage(), e);
                }
            }

            @Override
            public void beforeReconnect(HornetQException me) {
            }
        };
        this.sessionFactory.addFailureListener(this.failureListener);
        this.started = true;
        this.enabled = true;
    }

    @Override
    public void stop() throws Exception {
        if (!this.started) {
            return;
        }
        this.enabled = false;
        while (!this.pendingTokens.isEmpty()) {
            OperationContext ctx = this.pendingTokens.poll();
            try {
                ctx.replicationDone();
            }
            catch (Throwable e) {
                log.warn("Error completing callback on replication manager", e);
            }
        }
        if (this.replicatingChannel != null) {
            this.replicatingChannel.close();
        }
        this.sessionFactory.causeExit();
        this.sessionFactory.removeFailureListener(this.failureListener);
        if (this.replicatingConnection != null) {
            this.replicatingConnection.destroy();
        }
        this.replicatingConnection = null;
        this.started = false;
    }

    @Override
    public Set<OperationContext> getActiveTokens() {
        LinkedHashSet<OperationContext> activeContexts = new LinkedHashSet<OperationContext>();
        for (OperationContext ctx : this.pendingTokens) {
            activeContexts.add(ctx);
        }
        return activeContexts;
    }

    @Override
    public void compareJournals(JournalLoadInformation[] journalInfo) throws HornetQException {
        this.replicatingChannel.sendBlocking(new ReplicationCompareDataMessage(journalInfo));
    }

    private void sendReplicatePacket(Packet packet) {
        this.sendReplicatePacket(packet, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendReplicatePacket(Packet packet, boolean lineUp) {
        boolean runItNow = false;
        OperationContext repliToken = OperationContextImpl.getContext(this.executorFactory);
        if (lineUp) {
            repliToken.replicationLineUp();
        }
        Object object = this.replicationLock;
        synchronized (object) {
            if (!this.enabled) {
                runItNow = true;
            } else {
                this.pendingTokens.add(repliToken);
                this.replicatingChannel.send(packet);
            }
        }
        if (runItNow) {
            repliToken.replicationDone();
        }
    }

    private void replicated() {
        OperationContext ctx = this.pendingTokens.poll();
        if (ctx == null) {
            throw new IllegalStateException("Missing replication token on the queue.");
        }
        ctx.replicationDone();
    }

    private static class NullEncoding
    implements EncodingSupport {
        static NullEncoding instance = new NullEncoding();

        private NullEncoding() {
        }

        @Override
        public void decode(HornetQBuffer buffer) {
        }

        @Override
        public void encode(HornetQBuffer buffer) {
        }

        @Override
        public int getEncodeSize() {
            return 0;
        }
    }

    protected class ResponseHandler
    implements ChannelHandler {
        protected ResponseHandler() {
        }

        @Override
        public void handlePacket(Packet packet) {
            if (packet.getType() == 90) {
                ReplicationManagerImpl.this.replicated();
            }
        }
    }
}

