/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.client.impl;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Interceptor;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.ClusterTopologyListener;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.api.core.client.loadbalance.ConnectionLoadBalancingPolicy;
import org.hornetq.core.client.impl.AfterConnectInternalListener;
import org.hornetq.core.client.impl.ClientSessionFactoryImpl;
import org.hornetq.core.client.impl.ClientSessionFactoryInternal;
import org.hornetq.core.client.impl.ServerLocatorInternal;
import org.hornetq.core.client.impl.Topology;
import org.hornetq.core.client.impl.TopologyMember;
import org.hornetq.core.cluster.DiscoveryEntry;
import org.hornetq.core.cluster.DiscoveryGroup;
import org.hornetq.core.cluster.DiscoveryListener;
import org.hornetq.core.cluster.impl.DiscoveryGroupImpl;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.remoting.FailureListener;
import org.hornetq.utils.HornetQThreadFactory;
import org.hornetq.utils.UUIDGenerator;

public class ServerLocatorImpl
implements ServerLocatorInternal,
DiscoveryListener,
Serializable {
    private final Set<ClusterTopologyListener> topologyListeners = new HashSet<ClusterTopologyListener>();
    private static final long serialVersionUID = -1615857864410205260L;
    private static final Logger log = Logger.getLogger(ServerLocatorImpl.class);
    private final boolean ha;
    private boolean finalizeCheck = true;
    private boolean clusterConnection;
    private transient String identity;
    private final Set<ClientSessionFactoryInternal> factories = new HashSet<ClientSessionFactoryInternal>();
    private final Set<ClientSessionFactoryInternal> connectingFactories = new HashSet<ClientSessionFactoryInternal>();
    private TransportConfiguration[] initialConnectors;
    private DiscoveryGroupConfiguration discoveryGroupConfiguration;
    private StaticConnector staticConnector = new StaticConnector();
    private final Topology topology;
    private volatile Pair<TransportConfiguration, TransportConfiguration>[] topologyArray;
    private volatile boolean receivedTopology;
    private boolean compressLargeMessage;
    private transient boolean shutdownPool;
    private ExecutorService threadPool;
    private ScheduledExecutorService scheduledThreadPool;
    private DiscoveryGroup discoveryGroup;
    private ConnectionLoadBalancingPolicy loadBalancingPolicy;
    private boolean readOnly;
    private boolean cacheLargeMessagesClient;
    private long clientFailureCheckPeriod;
    private long connectionTTL;
    private long callTimeout;
    private int minLargeMessageSize;
    private int consumerWindowSize;
    private int consumerMaxRate;
    private int confirmationWindowSize;
    private int producerWindowSize;
    private int producerMaxRate;
    private boolean blockOnAcknowledge;
    private boolean blockOnDurableSend;
    private boolean blockOnNonDurableSend;
    private boolean autoGroup;
    private boolean preAcknowledge;
    private String connectionLoadBalancingPolicyClassName;
    private int ackBatchSize;
    private boolean useGlobalPools;
    private int scheduledThreadPoolMaxSize;
    private int threadPoolMaxSize;
    private long retryInterval;
    private double retryIntervalMultiplier;
    private long maxRetryInterval;
    private int reconnectAttempts;
    private int initialConnectAttempts;
    private boolean failoverOnInitialConnection;
    private int initialMessagePacketSize;
    private volatile STATE state;
    private final List<Interceptor> interceptors = new CopyOnWriteArrayList<Interceptor>();
    private static ExecutorService globalThreadPool;
    private Executor startExecutor;
    private static ScheduledExecutorService globalScheduledThreadPool;
    private AfterConnectInternalListener afterConnectListener;
    private String groupID;
    private String nodeID;
    private TransportConfiguration clusterTransportConfiguration;
    private boolean backup;
    private final Exception e = new Exception();
    public static Runnable finalizeCallback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void clearThreadPools() {
        if (globalThreadPool != null) {
            globalThreadPool.shutdown();
            try {
                if (!globalThreadPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                    throw new IllegalStateException("Couldn't finish the globalThreadPool");
                }
            }
            catch (InterruptedException e) {
            }
            finally {
                globalThreadPool = null;
            }
        }
        if (globalScheduledThreadPool != null) {
            globalScheduledThreadPool.shutdown();
            try {
                if (!globalScheduledThreadPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                    throw new IllegalStateException("Couldn't finish the globalScheduledThreadPool");
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                globalScheduledThreadPool = null;
            }
        }
    }

    private static synchronized ExecutorService getGlobalThreadPool() {
        if (globalThreadPool == null) {
            HornetQThreadFactory factory = new HornetQThreadFactory("HornetQ-client-global-threads", true, ServerLocatorImpl.getThisClassLoader());
            globalThreadPool = Executors.newCachedThreadPool(factory);
        }
        return globalThreadPool;
    }

    public static synchronized ScheduledExecutorService getGlobalScheduledThreadPool() {
        if (globalScheduledThreadPool == null) {
            HornetQThreadFactory factory = new HornetQThreadFactory("HornetQ-client-global-scheduled-threads", true, ServerLocatorImpl.getThisClassLoader());
            globalScheduledThreadPool = Executors.newScheduledThreadPool(5, factory);
        }
        return globalScheduledThreadPool;
    }

    private synchronized void setThreadPools() {
        if (this.threadPool != null) {
            return;
        }
        if (this.useGlobalPools) {
            this.threadPool = ServerLocatorImpl.getGlobalThreadPool();
            this.scheduledThreadPool = ServerLocatorImpl.getGlobalScheduledThreadPool();
        } else {
            this.shutdownPool = true;
            HornetQThreadFactory factory = new HornetQThreadFactory("HornetQ-client-factory-threads-" + System.identityHashCode(this), true, ServerLocatorImpl.getThisClassLoader());
            this.threadPool = this.threadPoolMaxSize == -1 ? Executors.newCachedThreadPool(factory) : Executors.newFixedThreadPool(this.threadPoolMaxSize, factory);
            factory = new HornetQThreadFactory("HornetQ-client-factory-pinger-threads-" + System.identityHashCode(this), true, ServerLocatorImpl.getThisClassLoader());
            this.scheduledThreadPool = Executors.newScheduledThreadPool(this.scheduledThreadPoolMaxSize, factory);
        }
    }

    private static ClassLoader getThisClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClientSessionFactoryImpl.class.getClassLoader();
            }
        });
    }

    private void instantiateLoadBalancingPolicy() {
        if (this.connectionLoadBalancingPolicyClassName == null) {
            throw new IllegalStateException("Please specify a load balancing policy class name on the session factory");
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                try {
                    Class<?> clazz = loader.loadClass(ServerLocatorImpl.this.connectionLoadBalancingPolicyClassName);
                    ServerLocatorImpl.this.loadBalancingPolicy = (ConnectionLoadBalancingPolicy)clazz.newInstance();
                    return null;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Unable to instantiate load balancing policy \"" + ServerLocatorImpl.this.connectionLoadBalancingPolicyClassName + "\"", e);
                }
            }
        });
    }

    private synchronized void initialise() throws HornetQException {
        if (this.readOnly) {
            return;
        }
        try {
            this.state = STATE.INITIALIZED;
            this.setThreadPools();
            this.instantiateLoadBalancingPolicy();
            if (this.discoveryGroupConfiguration != null) {
                InetAddress groupAddress = InetAddress.getByName(this.discoveryGroupConfiguration.getGroupAddress());
                InetAddress lbAddress = this.discoveryGroupConfiguration.getLocalBindAddress() != null ? InetAddress.getByName(this.discoveryGroupConfiguration.getLocalBindAddress()) : null;
                this.discoveryGroup = new DiscoveryGroupImpl(this.nodeID, this.discoveryGroupConfiguration.getName(), lbAddress, groupAddress, this.discoveryGroupConfiguration.getGroupPort(), this.discoveryGroupConfiguration.getRefreshTimeout());
                this.discoveryGroup.registerListener(this);
                this.discoveryGroup.start();
            }
            this.readOnly = true;
        }
        catch (Exception e) {
            this.state = null;
            throw new HornetQException(0, "Failed to initialise session factory", e);
        }
    }

    private ServerLocatorImpl(Topology topology, boolean useHA, DiscoveryGroupConfiguration discoveryGroupConfiguration, TransportConfiguration[] transportConfigs) {
        this.e.fillInStackTrace();
        this.topology = topology == null ? new Topology(this) : topology;
        this.ha = useHA;
        this.discoveryGroupConfiguration = discoveryGroupConfiguration;
        this.initialConnectors = transportConfigs;
        this.nodeID = UUIDGenerator.getInstance().generateStringUUID();
        this.clientFailureCheckPeriod = 30000L;
        this.connectionTTL = 60000L;
        this.callTimeout = 30000L;
        this.minLargeMessageSize = 102400;
        this.consumerWindowSize = 0x100000;
        this.consumerMaxRate = -1;
        this.confirmationWindowSize = -1;
        this.producerWindowSize = 65536;
        this.producerMaxRate = -1;
        this.blockOnAcknowledge = false;
        this.blockOnDurableSend = true;
        this.blockOnNonDurableSend = false;
        this.autoGroup = false;
        this.preAcknowledge = false;
        this.ackBatchSize = 0x100000;
        this.connectionLoadBalancingPolicyClassName = HornetQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME;
        this.useGlobalPools = true;
        this.scheduledThreadPoolMaxSize = 5;
        this.threadPoolMaxSize = -1;
        this.retryInterval = 2000L;
        this.retryIntervalMultiplier = 1.0;
        this.maxRetryInterval = 2000L;
        this.reconnectAttempts = 0;
        this.initialConnectAttempts = 1;
        this.failoverOnInitialConnection = false;
        this.cacheLargeMessagesClient = false;
        this.initialMessagePacketSize = 1500;
        this.cacheLargeMessagesClient = false;
        this.compressLargeMessage = false;
        this.clusterConnection = false;
    }

    public ServerLocatorImpl(boolean useHA, DiscoveryGroupConfiguration groupConfiguration) {
        this(new Topology(null), useHA, groupConfiguration, null);
        if (useHA) {
            this.topology.setOwner(this);
        }
    }

    public ServerLocatorImpl(boolean useHA, TransportConfiguration ... transportConfigs) {
        this(new Topology(null), useHA, (DiscoveryGroupConfiguration)null, transportConfigs);
        if (useHA) {
            this.topology.setOwner(this);
        }
    }

    public ServerLocatorImpl(Topology topology, boolean useHA, DiscoveryGroupConfiguration groupConfiguration) {
        this(topology, useHA, groupConfiguration, null);
    }

    public ServerLocatorImpl(Topology topology, boolean useHA, TransportConfiguration ... transportConfigs) {
        this(topology, useHA, (DiscoveryGroupConfiguration)null, transportConfigs);
    }

    private synchronized TransportConfiguration selectConnector() {
        if (this.receivedTopology) {
            int pos = this.loadBalancingPolicy.select(this.topologyArray.length);
            Pair<TransportConfiguration, TransportConfiguration> pair = this.topologyArray[pos];
            return pair.getA();
        }
        int pos = this.loadBalancingPolicy.select(this.initialConnectors.length);
        return this.initialConnectors[pos];
    }

    @Override
    public void start(Executor executor) throws Exception {
        this.initialise();
        this.startExecutor = executor;
        executor.execute(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        ServerLocatorImpl.this.connect();
                    }
                    catch (Exception e) {
                        if (ServerLocatorImpl.this.isClosed()) break block2;
                        log.warn("did not connect the cluster connection to other nodes", e);
                    }
                }
            }
        });
    }

    @Override
    public Executor getExecutor() {
        return this.startExecutor;
    }

    @Override
    public void disableFinalizeCheck() {
        this.finalizeCheck = false;
    }

    @Override
    public ClientSessionFactoryInternal connect() throws Exception {
        if (this.initialConnectors != null && this.discoveryGroup == null) {
            ClientSessionFactoryInternal sf = (ClientSessionFactoryInternal)this.staticConnector.connect();
            this.addFactory(sf);
            return sf;
        }
        return (ClientSessionFactoryInternal)this.createSessionFactory();
    }

    @Override
    public void setAfterConnectionInternalListener(AfterConnectInternalListener listener) {
        this.afterConnectListener = listener;
    }

    @Override
    public AfterConnectInternalListener getAfterConnectInternalListener() {
        return this.afterConnectListener;
    }

    @Override
    public ClientSessionFactory createSessionFactory(String nodeID) throws Exception {
        TopologyMember topologyMember = this.topology.getMember(nodeID);
        if (log.isTraceEnabled()) {
            log.trace("Creating connection factory towards " + nodeID + " = " + topologyMember + ", topology=" + this.topology.describe());
        }
        if (topologyMember == null) {
            return null;
        }
        if (topologyMember.getA() != null) {
            ClientSessionFactoryInternal factory = (ClientSessionFactoryInternal)this.createSessionFactory(topologyMember.getA());
            if (topologyMember.getB() != null) {
                factory.setBackupConnector(topologyMember.getA(), topologyMember.getB());
            }
            return factory;
        }
        if (topologyMember.getA() == null && topologyMember.getB() != null) {
            ClientSessionFactoryInternal factory = (ClientSessionFactoryInternal)this.createSessionFactory(topologyMember.getB());
            return factory;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientSessionFactory createSessionFactory(TransportConfiguration transportConfiguration) throws Exception {
        this.assertOpen();
        this.initialise();
        ClientSessionFactoryImpl factory = new ClientSessionFactoryImpl(this, transportConfiguration, this.callTimeout, this.clientFailureCheckPeriod, this.connectionTTL, this.retryInterval, this.retryIntervalMultiplier, this.maxRetryInterval, this.reconnectAttempts, this.threadPool, this.scheduledThreadPool, this.interceptors);
        this.addToConnecting(factory);
        try {
            try {
                factory.connect(this.reconnectAttempts, this.failoverOnInitialConnection);
            }
            catch (HornetQException e1) {
                factory.close();
                throw e1;
            }
            this.addFactory(factory);
            ClientSessionFactoryImpl clientSessionFactoryImpl = factory;
            return clientSessionFactoryImpl;
        }
        finally {
            this.removeFromConnecting(factory);
        }
    }

    private void removeFromConnecting(ClientSessionFactoryInternal factory) {
        this.connectingFactories.remove(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToConnecting(ClientSessionFactoryInternal factory) {
        Set<ClientSessionFactoryInternal> set = this.connectingFactories;
        synchronized (set) {
            this.assertOpen();
            this.connectingFactories.add(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientSessionFactory createSessionFactory() throws Exception {
        long timeout;
        boolean ok;
        this.assertOpen();
        this.initialise();
        if (this.initialConnectors == null && this.discoveryGroup != null && !(ok = this.discoveryGroup.waitForBroadcast(timeout = this.clusterConnection ? 0L : this.discoveryGroupConfiguration.getDiscoveryInitialWaitTimeout()))) {
            throw new HornetQException(3, "Timed out waiting to receive initial broadcast from cluster");
        }
        ClientSessionFactory factory = null;
        ServerLocatorImpl serverLocatorImpl = this;
        synchronized (serverLocatorImpl) {
            boolean retry;
            int attempts = 0;
            do {
                retry = false;
                TransportConfiguration tc = this.selectConnector();
                try {
                    factory = new ClientSessionFactoryImpl(this, tc, this.callTimeout, this.clientFailureCheckPeriod, this.connectionTTL, this.retryInterval, this.retryIntervalMultiplier, this.maxRetryInterval, this.reconnectAttempts, this.threadPool, this.scheduledThreadPool, this.interceptors);
                    try {
                        this.addToConnecting((ClientSessionFactoryInternal)factory);
                        factory.connect(this.initialConnectAttempts, this.failoverOnInitialConnection);
                    }
                    finally {
                        this.removeFromConnecting((ClientSessionFactoryInternal)factory);
                    }
                }
                catch (HornetQException e) {
                    factory.close();
                    factory = null;
                    if (e.getCode() == 2) {
                        if (this.topologyArray != null && ++attempts == this.topologyArray.length) {
                            throw new HornetQException(2, "Cannot connect to server(s). Tried with all available servers.");
                        }
                        if (this.topologyArray == null && this.initialConnectors != null && attempts == this.initialConnectors.length) {
                            throw new HornetQException(2, "Cannot connect to server(s). Tried with all available servers.");
                        }
                        retry = true;
                        continue;
                    }
                    throw e;
                }
            } while (retry);
            if (this.ha || this.clusterConnection) {
                long timeout2 = System.currentTimeMillis() + 30000L;
                while (!this.isClosed() && !this.receivedTopology && timeout2 > System.currentTimeMillis()) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException ignore) {}
                }
                if (System.currentTimeMillis() > timeout2 && !this.receivedTopology) {
                    throw new HornetQException(3, "Timed out waiting to receive cluster topology. Group:" + this.discoveryGroup);
                }
            }
            this.addFactory((ClientSessionFactoryInternal)factory);
            return factory;
        }
    }

    @Override
    public boolean isHA() {
        return this.ha;
    }

    @Override
    public boolean isCacheLargeMessagesClient() {
        return this.cacheLargeMessagesClient;
    }

    @Override
    public void setCacheLargeMessagesClient(boolean cached) {
        this.cacheLargeMessagesClient = cached;
    }

    @Override
    public long getClientFailureCheckPeriod() {
        return this.clientFailureCheckPeriod;
    }

    @Override
    public void setClientFailureCheckPeriod(long clientFailureCheckPeriod) {
        this.checkWrite();
        this.clientFailureCheckPeriod = clientFailureCheckPeriod;
    }

    @Override
    public long getConnectionTTL() {
        return this.connectionTTL;
    }

    @Override
    public void setConnectionTTL(long connectionTTL) {
        this.checkWrite();
        this.connectionTTL = connectionTTL;
    }

    @Override
    public long getCallTimeout() {
        return this.callTimeout;
    }

    @Override
    public void setCallTimeout(long callTimeout) {
        this.checkWrite();
        this.callTimeout = callTimeout;
    }

    @Override
    public int getMinLargeMessageSize() {
        return this.minLargeMessageSize;
    }

    @Override
    public void setMinLargeMessageSize(int minLargeMessageSize) {
        this.checkWrite();
        this.minLargeMessageSize = minLargeMessageSize;
    }

    @Override
    public int getConsumerWindowSize() {
        return this.consumerWindowSize;
    }

    @Override
    public void setConsumerWindowSize(int consumerWindowSize) {
        this.checkWrite();
        this.consumerWindowSize = consumerWindowSize;
    }

    @Override
    public int getConsumerMaxRate() {
        return this.consumerMaxRate;
    }

    @Override
    public void setConsumerMaxRate(int consumerMaxRate) {
        this.checkWrite();
        this.consumerMaxRate = consumerMaxRate;
    }

    @Override
    public int getConfirmationWindowSize() {
        return this.confirmationWindowSize;
    }

    @Override
    public void setConfirmationWindowSize(int confirmationWindowSize) {
        this.checkWrite();
        this.confirmationWindowSize = confirmationWindowSize;
    }

    @Override
    public int getProducerWindowSize() {
        return this.producerWindowSize;
    }

    @Override
    public void setProducerWindowSize(int producerWindowSize) {
        this.checkWrite();
        this.producerWindowSize = producerWindowSize;
    }

    @Override
    public int getProducerMaxRate() {
        return this.producerMaxRate;
    }

    @Override
    public void setProducerMaxRate(int producerMaxRate) {
        this.checkWrite();
        this.producerMaxRate = producerMaxRate;
    }

    @Override
    public boolean isBlockOnAcknowledge() {
        return this.blockOnAcknowledge;
    }

    @Override
    public void setBlockOnAcknowledge(boolean blockOnAcknowledge) {
        this.checkWrite();
        this.blockOnAcknowledge = blockOnAcknowledge;
    }

    @Override
    public boolean isBlockOnDurableSend() {
        return this.blockOnDurableSend;
    }

    @Override
    public void setBlockOnDurableSend(boolean blockOnDurableSend) {
        this.checkWrite();
        this.blockOnDurableSend = blockOnDurableSend;
    }

    @Override
    public boolean isBlockOnNonDurableSend() {
        return this.blockOnNonDurableSend;
    }

    @Override
    public void setBlockOnNonDurableSend(boolean blockOnNonDurableSend) {
        this.checkWrite();
        this.blockOnNonDurableSend = blockOnNonDurableSend;
    }

    @Override
    public boolean isAutoGroup() {
        return this.autoGroup;
    }

    @Override
    public void setAutoGroup(boolean autoGroup) {
        this.checkWrite();
        this.autoGroup = autoGroup;
    }

    @Override
    public boolean isPreAcknowledge() {
        return this.preAcknowledge;
    }

    @Override
    public void setPreAcknowledge(boolean preAcknowledge) {
        this.checkWrite();
        this.preAcknowledge = preAcknowledge;
    }

    @Override
    public int getAckBatchSize() {
        return this.ackBatchSize;
    }

    @Override
    public void setAckBatchSize(int ackBatchSize) {
        this.checkWrite();
        this.ackBatchSize = ackBatchSize;
    }

    @Override
    public boolean isUseGlobalPools() {
        return this.useGlobalPools;
    }

    @Override
    public void setUseGlobalPools(boolean useGlobalPools) {
        this.checkWrite();
        this.useGlobalPools = useGlobalPools;
    }

    @Override
    public int getScheduledThreadPoolMaxSize() {
        return this.scheduledThreadPoolMaxSize;
    }

    @Override
    public void setScheduledThreadPoolMaxSize(int scheduledThreadPoolMaxSize) {
        this.checkWrite();
        this.scheduledThreadPoolMaxSize = scheduledThreadPoolMaxSize;
    }

    @Override
    public int getThreadPoolMaxSize() {
        return this.threadPoolMaxSize;
    }

    @Override
    public void setThreadPoolMaxSize(int threadPoolMaxSize) {
        this.checkWrite();
        this.threadPoolMaxSize = threadPoolMaxSize;
    }

    @Override
    public long getRetryInterval() {
        return this.retryInterval;
    }

    @Override
    public void setRetryInterval(long retryInterval) {
        this.checkWrite();
        this.retryInterval = retryInterval;
    }

    @Override
    public long getMaxRetryInterval() {
        return this.maxRetryInterval;
    }

    @Override
    public void setMaxRetryInterval(long retryInterval) {
        this.checkWrite();
        this.maxRetryInterval = retryInterval;
    }

    @Override
    public double getRetryIntervalMultiplier() {
        return this.retryIntervalMultiplier;
    }

    @Override
    public void setRetryIntervalMultiplier(double retryIntervalMultiplier) {
        this.checkWrite();
        this.retryIntervalMultiplier = retryIntervalMultiplier;
    }

    @Override
    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    @Override
    public void setReconnectAttempts(int reconnectAttempts) {
        this.checkWrite();
        this.reconnectAttempts = reconnectAttempts;
    }

    @Override
    public void setInitialConnectAttempts(int initialConnectAttempts) {
        this.checkWrite();
        this.initialConnectAttempts = initialConnectAttempts;
    }

    @Override
    public int getInitialConnectAttempts() {
        return this.initialConnectAttempts;
    }

    @Override
    public boolean isFailoverOnInitialConnection() {
        return this.failoverOnInitialConnection;
    }

    @Override
    public void setFailoverOnInitialConnection(boolean failover) {
        this.checkWrite();
        this.failoverOnInitialConnection = failover;
    }

    @Override
    public String getConnectionLoadBalancingPolicyClassName() {
        return this.connectionLoadBalancingPolicyClassName;
    }

    @Override
    public void setConnectionLoadBalancingPolicyClassName(String loadBalancingPolicyClassName) {
        this.checkWrite();
        this.connectionLoadBalancingPolicyClassName = loadBalancingPolicyClassName;
    }

    @Override
    public TransportConfiguration[] getStaticTransportConfigurations() {
        return this.initialConnectors;
    }

    @Override
    public DiscoveryGroupConfiguration getDiscoveryGroupConfiguration() {
        return this.discoveryGroupConfiguration;
    }

    @Override
    public void addInterceptor(Interceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    @Override
    public boolean removeInterceptor(Interceptor interceptor) {
        return this.interceptors.remove(interceptor);
    }

    @Override
    public int getInitialMessagePacketSize() {
        return this.initialMessagePacketSize;
    }

    @Override
    public void setInitialMessagePacketSize(int size) {
        this.checkWrite();
        this.initialMessagePacketSize = size;
    }

    @Override
    public void setGroupID(String groupID) {
        this.checkWrite();
        this.groupID = groupID;
    }

    @Override
    public String getGroupID() {
        return this.groupID;
    }

    @Override
    public boolean isCompressLargeMessage() {
        return this.compressLargeMessage;
    }

    @Override
    public void setCompressLargeMessage(boolean compress) {
        this.compressLargeMessage = compress;
    }

    private void checkWrite() {
        if (this.readOnly) {
            throw new IllegalStateException("Cannot set attribute on SessionFactory after it has been used");
        }
    }

    @Override
    public String getIdentity() {
        return this.identity;
    }

    @Override
    public void setIdentity(String identity) {
        this.identity = identity;
    }

    @Override
    public void setNodeID(String nodeID) {
        this.nodeID = nodeID;
    }

    @Override
    public String getNodeID() {
        return this.nodeID;
    }

    @Override
    public void setClusterConnection(boolean clusterConnection) {
        this.clusterConnection = clusterConnection;
    }

    @Override
    public boolean isClusterConnection() {
        return this.clusterConnection;
    }

    @Override
    public TransportConfiguration getClusterTransportConfiguration() {
        return this.clusterTransportConfiguration;
    }

    @Override
    public void setClusterTransportConfiguration(TransportConfiguration tc) {
        this.clusterTransportConfiguration = tc;
    }

    @Override
    public boolean isBackup() {
        return this.backup;
    }

    @Override
    public void setBackup(boolean backup) {
        this.backup = backup;
    }

    protected void finalize() throws Throwable {
        if (this.finalizeCheck) {
            this.close();
        }
        super.finalize();
    }

    @Override
    public void cleanup() {
        this.doClose(false);
    }

    @Override
    public void close() {
        this.doClose(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose(boolean sendClose) {
        Set<ClientSessionFactoryInternal> set;
        if (this.state == STATE.CLOSED) {
            if (log.isDebugEnabled()) {
                log.debug(this + " is already closed when calling closed");
            }
            return;
        }
        this.state = STATE.CLOSING;
        if (this.discoveryGroup != null) {
            set = this;
            synchronized (set) {
                try {
                    this.discoveryGroup.stop();
                }
                catch (Exception e) {
                    log.error("Failed to stop discovery group", e);
                }
            }
        }
        this.staticConnector.disconnect();
        set = this.connectingFactories;
        synchronized (set) {
            for (ClientSessionFactoryInternal csf : this.connectingFactories) {
                csf.close();
            }
            this.connectingFactories.clear();
        }
        set = this.factories;
        synchronized (set) {
            HashSet<ClientSessionFactoryInternal> clonedFactory = new HashSet<ClientSessionFactoryInternal>(this.factories);
            for (ClientSessionFactoryInternal factory : clonedFactory) {
                if (sendClose) {
                    factory.close();
                    continue;
                }
                factory.cleanup();
            }
            this.factories.clear();
        }
        if (this.shutdownPool) {
            if (this.threadPool != null) {
                this.threadPool.shutdown();
                try {
                    if (!this.threadPool.awaitTermination(10000L, TimeUnit.MILLISECONDS)) {
                        log.warn("Timed out waiting for pool to terminate");
                    }
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
            if (this.scheduledThreadPool != null) {
                this.scheduledThreadPool.shutdown();
                try {
                    if (!this.scheduledThreadPool.awaitTermination(10000L, TimeUnit.MILLISECONDS)) {
                        log.warn("Timed out waiting for scheduled pool to terminate");
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.readOnly = false;
        this.state = STATE.CLOSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyNodeDown(long eventTime, String nodeID) {
        if (!this.ha) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("nodeDown " + this + " nodeID=" + nodeID + " as being down", new Exception("trace"));
        }
        this.topology.removeMember(eventTime, nodeID);
        if (this.clusterConnection) {
            this.updateArraysAndPairs();
        } else {
            ServerLocatorImpl serverLocatorImpl = this;
            synchronized (serverLocatorImpl) {
                if (this.topology.isEmpty()) {
                    this.receivedTopology = false;
                    this.topologyArray = null;
                } else {
                    this.updateArraysAndPairs();
                    if (this.topology.nodes() == 1 && this.topology.getMember(this.nodeID) != null) {
                        this.receivedTopology = false;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyNodeUp(long uniqueEventID, String nodeID, Pair<TransportConfiguration, TransportConfiguration> connectorPair, boolean last) {
        if (!this.ha) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("NodeUp " + this + "::nodeID=" + nodeID + ", connectorPair=" + connectorPair, new Exception("trace"));
        }
        TopologyMember member = new TopologyMember(connectorPair.getA(), connectorPair.getB());
        this.topology.updateMember(uniqueEventID, nodeID, member);
        TopologyMember actMember = this.topology.getMember(nodeID);
        if (actMember != null && actMember.getConnector().getA() != null && actMember.getConnector().getB() != null) {
            for (ClientSessionFactoryInternal factory : this.factories) {
                factory.setBackupConnector(actMember.getConnector().getA(), actMember.getConnector().getB());
            }
        }
        this.updateArraysAndPairs();
        if (last) {
            ServerLocatorImpl serverLocatorImpl = this;
            synchronized (serverLocatorImpl) {
                this.receivedTopology = true;
                this.notifyAll();
            }
        }
    }

    public String toString() {
        if (this.identity != null) {
            return "ServerLocatorImpl (identity=" + this.identity + ") [initialConnectors=" + Arrays.toString(this.initialConnectors) + ", discoveryGroupConfiguration=" + this.discoveryGroupConfiguration + "]";
        }
        return "ServerLocatorImpl [initialConnectors=" + Arrays.toString(this.initialConnectors) + ", discoveryGroupConfiguration=" + this.discoveryGroupConfiguration + "]";
    }

    private synchronized void updateArraysAndPairs() {
        Collection<TopologyMember> membersCopy = this.topology.getMembers();
        this.topologyArray = (Pair[])Array.newInstance(Pair.class, membersCopy.size());
        int count = 0;
        for (TopologyMember pair : membersCopy) {
            this.topologyArray[count++] = pair.getConnector();
        }
    }

    @Override
    public synchronized void connectorsChanged() {
        List<DiscoveryEntry> newConnectors = this.discoveryGroup.getDiscoveryEntries();
        this.initialConnectors = (TransportConfiguration[])Array.newInstance(TransportConfiguration.class, newConnectors.size());
        int count = 0;
        for (DiscoveryEntry entry : newConnectors) {
            this.initialConnectors[count++] = entry.getConnector();
            if (!this.ha || this.topology.getMember(entry.getNodeID()) != null) continue;
            TopologyMember member = new TopologyMember(entry.getConnector(), null);
            this.topology.updateMember(0L, entry.getNodeID(), member);
        }
        if (this.clusterConnection && !this.receivedTopology && this.initialConnectors.length > 0) {
            try {
                this.connect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public synchronized void factoryClosed(ClientSessionFactory factory) {
        this.factories.remove(factory);
        if (!this.clusterConnection && this.factories.isEmpty()) {
            this.receivedTopology = false;
            this.topologyArray = null;
        }
    }

    @Override
    public Topology getTopology() {
        return this.topology;
    }

    @Override
    public void addClusterTopologyListener(ClusterTopologyListener listener) {
        this.topology.addClusterTopologyListener(listener);
    }

    @Override
    public void removeClusterTopologyListener(ClusterTopologyListener listener) {
        this.topology.removeClusterTopologyListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void addFactory(ClientSessionFactoryInternal factory) {
        if (factory == null) {
            return;
        }
        Set<ClientSessionFactoryInternal> set = this.factories;
        synchronized (set) {
            if (this.isClosed()) {
                factory.close();
                return;
            }
            TransportConfiguration backup = null;
            if (this.ha) {
                backup = this.topology.getBackupForConnector(factory.getConnectorConfiguration());
            }
            factory.setBackupConnector(factory.getConnectorConfiguration(), backup);
            this.factories.add(factory);
        }
    }

    private void assertOpen() {
        if (this.state != null && this.state != STATE.INITIALIZED) {
            throw new IllegalStateException("Cannot create session factory, server locator is closed (maybe it has been garbage collected)");
        }
    }

    @Override
    public boolean isClosed() {
        return this.state != STATE.INITIALIZED;
    }

    static {
        finalizeCallback = null;
    }

    class StaticConnector
    implements Serializable {
        private static final long serialVersionUID = 6772279632415242634L;
        private List<Connector> connectors;

        StaticConnector() {
        }

        public ClientSessionFactory connect() throws HornetQException {
            ServerLocatorImpl.this.assertOpen();
            ServerLocatorImpl.this.initialise();
            ClientSessionFactory csf = null;
            this.createConnectors();
            try {
                int retryNumber = 0;
                while (csf == null && !ServerLocatorImpl.this.isClosed()) {
                    ++retryNumber;
                    for (Connector conn : this.connectors) {
                        if (log.isDebugEnabled()) {
                            log.debug(this + "::Submitting connect towards " + conn);
                        }
                        if ((csf = conn.tryConnect()) == null) continue;
                        csf.getConnection().addFailureListener(new FailureListener(){

                            @Override
                            public void connectionFailed(HornetQException exception, boolean failedOver) {
                                if (ServerLocatorImpl.this.clusterConnection && exception.getCode() == 4) {
                                    try {
                                        ServerLocatorImpl.this.start(ServerLocatorImpl.this.startExecutor);
                                    }
                                    catch (Exception e) {
                                        log.warn(e.getMessage());
                                    }
                                }
                            }
                        });
                        if (log.isDebugEnabled()) {
                            log.debug("Returning " + csf + " after " + retryNumber + " retries on StaticConnector " + ServerLocatorImpl.this);
                        }
                        return csf;
                    }
                    if (ServerLocatorImpl.this.initialConnectAttempts < 0 || retryNumber <= ServerLocatorImpl.this.initialConnectAttempts) {
                        if (ServerLocatorImpl.this.isClosed()) continue;
                        Thread.sleep(ServerLocatorImpl.this.retryInterval);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                log.warn(e.getMessage(), e);
                throw new HornetQException(2, "Failed to connect to any static connectors", e);
            }
            if (csf == null && !ServerLocatorImpl.this.isClosed()) {
                log.warn("Failed to connecto to any static connector, throwing exception now");
                throw new HornetQException(2, "Failed to connect to any static connectors");
            }
            if (log.isDebugEnabled()) {
                log.debug("Returning " + csf + " on " + ServerLocatorImpl.this);
            }
            return csf;
        }

        private synchronized void createConnectors() {
            if (this.connectors != null) {
                for (Connector conn : this.connectors) {
                    if (conn == null) continue;
                    conn.disconnect();
                }
            }
            this.connectors = new ArrayList<Connector>();
            for (TransportConfiguration initialConnector : ServerLocatorImpl.this.initialConnectors) {
                ClientSessionFactoryImpl factory = new ClientSessionFactoryImpl(ServerLocatorImpl.this, initialConnector, ServerLocatorImpl.this.callTimeout, ServerLocatorImpl.this.clientFailureCheckPeriod, ServerLocatorImpl.this.connectionTTL, ServerLocatorImpl.this.retryInterval, ServerLocatorImpl.this.retryIntervalMultiplier, ServerLocatorImpl.this.maxRetryInterval, ServerLocatorImpl.this.reconnectAttempts, ServerLocatorImpl.this.threadPool, ServerLocatorImpl.this.scheduledThreadPool, ServerLocatorImpl.this.interceptors);
                factory.disableFinalizeCheck();
                this.connectors.add(new Connector(initialConnector, factory));
            }
        }

        public synchronized void disconnect() {
            if (this.connectors != null) {
                for (Connector connector : this.connectors) {
                    connector.disconnect();
                }
            }
        }

        public void finalize() throws Throwable {
            if (!ServerLocatorImpl.this.isClosed() && ServerLocatorImpl.this.finalizeCheck) {
                log.warn("I'm closing a core ServerLocator you left open. Please make sure you close all ServerLocators explicitly before letting them go out of scope! " + System.identityHashCode(this));
                log.warn("The ServerLocator you didn't close was created here:", ServerLocatorImpl.this.e);
                if (finalizeCallback != null) {
                    finalizeCallback.run();
                }
                ServerLocatorImpl.this.close();
            }
            super.finalize();
        }

        class Connector {
            private TransportConfiguration initialConnector;
            private volatile ClientSessionFactoryInternal factory;
            private boolean interrupted = false;
            private Exception e;

            public Connector(TransportConfiguration initialConnector, ClientSessionFactoryInternal factory) {
                this.initialConnector = initialConnector;
                this.factory = factory;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ClientSessionFactory tryConnect() throws HornetQException {
                if (log.isDebugEnabled()) {
                    log.debug(this + "::Trying to connect to " + this.factory);
                }
                try {
                    ClientSessionFactoryInternal factoryToUse = this.factory;
                    if (factoryToUse != null) {
                        try {
                            ServerLocatorImpl.this.addToConnecting(factoryToUse);
                            factoryToUse.connect(1, false);
                        }
                        finally {
                            ServerLocatorImpl.this.removeFromConnecting(factoryToUse);
                        }
                    }
                    return factoryToUse;
                }
                catch (HornetQException e) {
                    log.debug(this + "::Exception on establish connector initial connection", e);
                    return null;
                }
            }

            public void disconnect() {
                this.interrupted = true;
                if (this.factory != null) {
                    this.factory.causeExit();
                    this.factory.cleanup();
                    this.factory = null;
                }
            }

            public String toString() {
                return "Connector [initialConnector=" + this.initialConnector + "]";
            }
        }
    }

    private static enum STATE {
        INITIALIZED,
        CLOSED,
        CLOSING;

    }
}

