/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.bayeux;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletResponse;
import org.apache.tomcat.bayeux.BayeuxException;
import org.apache.tomcat.bayeux.BayeuxRequest;
import org.apache.tomcat.bayeux.ClientImpl;
import org.apache.tomcat.bayeux.RequestBase;
import org.apache.tomcat.bayeux.RequestFactory;
import org.apache.tomcat.bayeux.TomcatBayeux;
import org.apache.tomcat.util.json.JSONArray;
import org.apache.tomcat.util.json.JSONException;
import org.apache.tomcat.util.json.JSONObject;
import org.jboss.logging.Logger;
import org.jboss.servlet.http.HttpEvent;
import org.jboss.servlet.http.HttpEventServlet;

public class BayeuxServlet
extends HttpServlet
implements HttpEventServlet {
    private static Logger log = Logger.getLogger(BayeuxServlet.class);
    protected int timeout = 0;
    protected int reconnectInterval = 0;
    public static final String TOMCAT_BAYEUX_ATTR = "dojox.cometd.bayeux";
    protected TomcatBayeux tb;

    public void destroy() {
        this.tb = null;
    }

    protected int getTimeout() {
        return this.timeout;
    }

    protected int getReconnectInterval() {
        return this.reconnectInterval;
    }

    public void event(HttpEvent cometEvent) throws IOException, ServletException {
        HttpEvent.EventType type = cometEvent.getType();
        if (log.isTraceEnabled()) {
            log.trace((Object)("[" + Thread.currentThread().getName() + "] Received Comet Event type=" + (Object)((Object)type)));
        }
        switch (type) {
            case BEGIN: {
                cometEvent.setTimeout(this.getTimeout());
                break;
            }
            case READ: {
                this.checkBayeux(cometEvent);
                break;
            }
            case EOF: 
            case EVENT: 
            case WRITE: {
                break;
            }
            case ERROR: 
            case END: 
            case TIMEOUT: {
                this.tb.remove(cometEvent);
                cometEvent.close();
            }
        }
    }

    protected void checkBayeux(HttpEvent cometEvent) throws IOException, UnsupportedOperationException {
        if ("text/json".equals(cometEvent.getHttpServletRequest().getContentType())) {
            int contentlength = cometEvent.getHttpServletRequest().getContentLength();
            throw new UnsupportedOperationException("Decoding text/json not yet implemented.");
        }
        String message = cometEvent.getHttpServletRequest().getParameter("message");
        if (log.isTraceEnabled()) {
            log.trace((Object)("[" + Thread.currentThread().getName() + "] Received JSON message:" + message));
        }
        try {
            int action = this.handleBayeux(message, cometEvent);
            if (log.isTraceEnabled()) {
                log.trace((Object)("[" + Thread.currentThread().getName() + "] Bayeux handling complete, action result=" + action));
            }
            if (action <= 0) {
                cometEvent.close();
            }
        }
        catch (Exception e) {
            this.tb.remove(cometEvent);
            log.warn((Object)"Exception in check", (Throwable)e);
            cometEvent.close();
        }
    }

    protected int handleBayeux(String message, HttpEvent event) throws IOException, ServletException {
        int result = 0;
        if (message == null || message.length() == 0) {
            return result;
        }
        try {
            BayeuxRequest request = null;
            JSONArray jsArray = new JSONArray(message);
            for (int i = 0; i < jsArray.length(); ++i) {
                JSONObject msg = jsArray.getJSONObject(i);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("[" + Thread.currentThread().getName() + "] Processing bayeux message:" + msg));
                }
                request = RequestFactory.getRequest(this.tb, event, msg);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("[" + Thread.currentThread().getName() + "] Processing bayeux message using request:" + request));
                }
                result = request.process(result);
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("[" + Thread.currentThread().getName() + "] Processing bayeux message result:" + result));
            }
            if (result > 0 && request != null) {
                event.getHttpServletRequest().setAttribute("org.apache.cometd.bayeux.last_request", request);
                ClientImpl ci = (ClientImpl)this.tb.getClient(((RequestBase)request).getClientId());
                ci.addCometEvent(event);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("[" + Thread.currentThread().getName() + "] Done bayeux message added to request attribute"));
                }
            } else if (result == 0 && request != null) {
                RequestBase.deliver(event, (ClientImpl)this.tb.getClient(((RequestBase)request).getClientId()));
                if (log.isTraceEnabled()) {
                    log.trace((Object)("[" + Thread.currentThread().getName() + "] Done bayeux message, delivered to client"));
                }
            }
        }
        catch (JSONException e) {
            log.warn((Object)"Error", (Throwable)e);
            result = -1;
        }
        catch (BayeuxException e) {
            log.warn((Object)"Error", (Throwable)e);
            result = -1;
        }
        return result;
    }

    public String getServletInfo() {
        return "Tomcat/BayeuxServlet/1.0";
    }

    public void init() throws ServletException {
        ServletContext ctx;
        if (this.getServletConfig().getInitParameter("timeout") != null) {
            this.timeout = Integer.parseInt(this.getServletConfig().getInitParameter("timeout"));
        }
        if (this.getServletConfig().getInitParameter("reconnectInterval") != null) {
            this.reconnectInterval = Integer.parseInt(this.getServletConfig().getInitParameter("reconnectInterval"));
        }
        if ((ctx = this.getServletConfig().getServletContext()).getAttribute(TOMCAT_BAYEUX_ATTR) == null) {
            ctx.setAttribute(TOMCAT_BAYEUX_ATTR, (Object)new TomcatBayeux());
        }
        this.tb = (TomcatBayeux)ctx.getAttribute(TOMCAT_BAYEUX_ATTR);
        this.tb.setReconnectInterval(this.getReconnectInterval());
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        if (!(servletResponse instanceof HttpServletResponse)) {
            throw new ServletException("Misconfigured Tomcat server, must be configured to support Comet operations for the Bayeux protocol.");
        }
        ((HttpServletResponse)servletResponse).sendError(500, "Misconfigured Tomcat server, must be configured to support Comet operations.");
    }
}

