/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.net.InetAddress;
import org.opennms.protocols.snmp.SnmpParameters;

public class SnmpPeer
implements Cloneable {
    private InetAddress m_peer;
    private int m_port;
    private InetAddress m_serveraddress;
    private int m_serverport = 0;
    private int m_retries;
    private int m_timeout;
    private SnmpParameters m_params;
    public static final int defaultRemotePort = 161;
    public static final int defaultRetries = 3;
    public static final int defaultTimeout = 8000;

    public SnmpPeer(InetAddress peer) {
        this.m_peer = peer;
        this.m_port = 161;
        this.m_timeout = 8000;
        this.m_retries = 3;
        this.m_params = new SnmpParameters();
    }

    public SnmpPeer(InetAddress peer, int port) {
        this(peer);
        this.m_port = port;
    }

    public SnmpPeer(InetAddress peer, int port, InetAddress laddr, int lport) {
        this(peer);
        this.m_port = port;
        this.m_serveraddress = laddr;
        this.m_serverport = lport;
    }

    public SnmpPeer(SnmpPeer second) {
        this.m_peer = second.m_peer;
        this.m_port = second.m_port;
        this.m_serveraddress = second.m_serveraddress;
        this.m_serverport = second.m_serverport;
        this.m_timeout = second.m_timeout;
        this.m_retries = second.m_retries;
        this.m_params = (SnmpParameters)second.m_params.clone();
    }

    public InetAddress getPeer() {
        return this.m_peer;
    }

    public void setPeer(InetAddress addr) {
        this.m_peer = addr;
    }

    public void setPeer(InetAddress addr, int port) {
        this.m_peer = addr;
        this.m_port = port;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setPort(int port) {
        this.m_port = port;
    }

    public int getServerPort() {
        return this.m_serverport;
    }

    public void setServerPort(int port) {
        this.m_serverport = port;
    }

    public InetAddress getServerAddress() {
        return this.m_serveraddress;
    }

    public void setServerAddress(InetAddress laddr) {
        this.m_serveraddress = laddr;
    }

    public int getRetries() {
        return this.m_retries;
    }

    public void setRetries(int retry) {
        this.m_retries = retry;
    }

    public int getTimeout() {
        return this.m_timeout;
    }

    public void setTimeout(int timeout) {
        this.m_timeout = timeout;
    }

    public SnmpParameters getParameters() {
        return this.m_params;
    }

    public void setParameters(SnmpParameters params) {
        this.m_params = params;
    }

    public Object clone() {
        return new SnmpPeer(this);
    }
}

