/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.gui.table.renderer;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.rhq.core.gui.table.component.RowSelectorComponent;
import org.rhq.core.gui.table.component.SelectedRowsCommandButtonComponent;
import org.rhq.core.gui.table.renderer.AbstractButtonRenderer;
import org.rhq.core.gui.util.FacesComponentUtility;

public class SelectedRowsCommandButtonRenderer
extends AbstractButtonRenderer {
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        super.encodeBegin(context, component);
        SelectedRowsCommandButtonComponent selectedRowsCommandButton = (SelectedRowsCommandButtonComponent)component;
        ResponseWriter writer = context.getResponseWriter();
        Integer minimum = selectedRowsCommandButton.getMinimum();
        writer.writeAttribute("minimum", (Object)minimum, "minimum");
        Integer maximum = selectedRowsCommandButton.getMaximum();
        if (maximum != null) {
            writer.writeAttribute("maximum", (Object)maximum, "maximum");
        }
        UIData data = this.getTargetUIData(selectedRowsCommandButton);
        RowSelectorComponent rowSelector = this.getRowSelector(data);
        String rowSelectorClientId = rowSelector.getClientId(context);
        writer.writeAttribute("target", (Object)rowSelectorClientId, null);
    }

    protected void renderBooleanAttributes(ResponseWriter writer, UIComponent component) throws IOException {
        SelectedRowsCommandButtonComponent selectedRowsCommandButton = (SelectedRowsCommandButtonComponent)component;
        Integer minimum = selectedRowsCommandButton.getMinimum();
        if (minimum > 0) {
            writer.writeAttribute("disabled", (Object)true, "disabled");
        }
    }

    private RowSelectorComponent getRowSelector(UIData data) {
        List<RowSelectorComponent> rowSelectors = FacesComponentUtility.getDescendantsOfType((UIComponent)data, RowSelectorComponent.class);
        if (rowSelectors.isEmpty()) {
            throw new IllegalStateException("No rowSelector component was found within the target dataTable component " + data + ".");
        }
        if (rowSelectors.size() > 1) {
            throw new IllegalStateException("More than one rowSelector component was found within the target dataTable component " + data + ".");
        }
        RowSelectorComponent rowSelector = rowSelectors.get(0);
        return rowSelector;
    }

    private UIData getTargetUIData(SelectedRowsCommandButtonComponent selectedRowsCommandButton) {
        UIData data;
        String dataTableId = selectedRowsCommandButton.getDataTableId();
        if (dataTableId != null) {
            data = (UIData)selectedRowsCommandButton.findComponent(dataTableId);
            if (data == null) {
                throw new IllegalStateException("UIData component (i.e. h:dataTable or rich:*dataTable) with id '" + dataTableId + "' not found within naming scope of component " + (Object)((Object)selectedRowsCommandButton) + ". The allRowsSelector component must either be within a UIData component or must specify the id of a UIData component within its naming scope via the 'dataTableId' attribute.");
            }
        } else {
            data = FacesComponentUtility.getAncestorOfType((UIComponent)selectedRowsCommandButton, UIData.class);
            if (data == null) {
                throw new IllegalStateException("Enclosing UIData component (i.e. h:dataTable or rich:*dataTable) not found for component " + (Object)((Object)selectedRowsCommandButton) + ". The allRowsSelector component must either be within a UIData component or must specify the id of a UIData component within its naming scope via the 'dataTableId' attribute.");
            }
        }
        return data;
    }
}

