/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.web.spec;

import java.util.HashMap;
import org.jboss.metadata.javaee.spec.EnvironmentRefsGroupMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationsMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.metadata.web.spec.ServletsMetaData;
import org.jboss.metadata.web.spec.WebMetaData;

public class AnnotationMergedView {
    public static void merge(WebMetaData merged, WebMetaData xml, WebMetaData annotation) {
        ServletsMetaData servletsMetaData = new ServletsMetaData();
        AnnotationMergedView.merge(servletsMetaData, xml.getServlets(), annotation.getServlets());
        merged.setServlets(servletsMetaData);
        SecurityRolesMetaData securityRolesMetaData = new SecurityRolesMetaData();
        AnnotationMergedView.merge(securityRolesMetaData, xml.getSecurityRoles(), annotation.getSecurityRoles());
        merged.setSecurityRoles(securityRolesMetaData);
        EnvironmentRefsGroupMetaData environmentRefsGroup = new EnvironmentRefsGroupMetaData();
        EnvironmentRefsGroupMetaData xmlEnv = xml != null ? xml.getJndiEnvironmentRefsGroup() : null;
        EnvironmentRefsGroupMetaData annEnv = annotation != null ? annotation.getJndiEnvironmentRefsGroup() : null;
        environmentRefsGroup.merge(xmlEnv, annEnv, "", "", false);
        merged.setJndiEnvironmentRefsGroup(environmentRefsGroup);
        MessageDestinationsMetaData messageDestinations = new MessageDestinationsMetaData();
        messageDestinations.merge(xml.getMessageDestinations(), annotation.getMessageDestinations());
        merged.setMessageDestinations(messageDestinations);
        AnnotationMergedView.mergeIn(merged, annotation);
        AnnotationMergedView.mergeIn(merged, xml);
    }

    private static void merge(ServletsMetaData merged, ServletsMetaData xml, ServletsMetaData annotation) {
        HashMap<String, String> servletClassToName = new HashMap<String, String>();
        if (xml != null) {
            if (xml.getId() != null) {
                merged.setId(xml.getId());
            }
            for (ServletMetaData servlet : xml) {
                String className = servlet.getServletName();
                if (className == null) continue;
                int dot = className.lastIndexOf(46);
                if (dot >= 0) {
                    className = className.substring(dot + 1);
                }
                servletClassToName.put(className, servlet.getServletName());
            }
        }
        if (annotation != null) {
            for (ServletMetaData servlet : annotation) {
                if (xml != null) {
                    String xmlServletName;
                    String servletName = servlet.getServletName();
                    ServletMetaData match = (ServletMetaData)xml.get(servletName);
                    if (match != null || (xmlServletName = (String)servletClassToName.get(servletName)) != null) continue;
                    merged.add(servlet);
                    continue;
                }
                merged.add(servlet);
            }
        }
        if (xml != null) {
            for (ServletMetaData servlet : xml) {
                String className;
                String name;
                ServletMetaData annServlet = null;
                if (annotation != null && (annServlet = (ServletMetaData)annotation.get(name = servlet.getServletName())) == null && (className = servlet.getServletClass()) != null) {
                    int dot = className.lastIndexOf(46);
                    if (dot >= 0) {
                        className = className.substring(dot + 1);
                    }
                    annServlet = (ServletMetaData)annotation.get(className);
                }
                ServletMetaData mergedServletMetaData = servlet;
                if (annServlet != null) {
                    mergedServletMetaData = new ServletMetaData();
                    mergedServletMetaData.merge(servlet, annServlet);
                }
                merged.add(mergedServletMetaData);
            }
        }
    }

    private static void merge(SecurityRolesMetaData merged, SecurityRolesMetaData xml, SecurityRolesMetaData annotation) {
        merged.merge(xml, annotation);
    }

    private static void mergeIn(WebMetaData merged, WebMetaData xml) {
        merged.setDTD("", xml.getDtdPublicId(), xml.getDtdSystemId());
        if (xml.getVersion() != null) {
            merged.setVersion(xml.getVersion());
        }
        if (xml.getDescriptionGroup() != null) {
            merged.setDescriptionGroup(xml.getDescriptionGroup());
        }
        if (xml.getContextParams() != null) {
            merged.setContextParams(xml.getContextParams());
        }
        if (xml.getDistributable() != null) {
            merged.setDistributable(xml.getDistributable());
        }
        if (xml.getSessionConfig() != null) {
            merged.setSessionConfig(xml.getSessionConfig());
        }
        if (xml.getFilters() != null) {
            merged.setFilters(xml.getFilters());
        }
        if (xml.getErrorPages() != null) {
            merged.setErrorPages(xml.getErrorPages());
        }
        if (xml.getJspConfig() != null) {
            merged.setJspConfig(xml.getJspConfig());
        }
        if (xml.getListeners() != null) {
            merged.setListeners(xml.getListeners());
        }
        if (xml.getLoginConfig() != null) {
            merged.setLoginConfig(xml.getLoginConfig());
        }
        if (xml.getMimeMappings() != null) {
            merged.setMimeMappings(xml.getMimeMappings());
        }
        if (xml.getServletMappings() != null) {
            merged.setServletMappings(xml.getServletMappings());
        }
        if (xml.getSecurityContraints() != null) {
            merged.setSecurityContraints(xml.getSecurityContraints());
        }
        if (xml.getWelcomeFileList() != null) {
            merged.setWelcomeFileList(xml.getWelcomeFileList());
        }
        if (xml.getLocalEncodings() != null) {
            merged.setLocalEncodings(xml.getLocalEncodings());
        }
    }
}

