/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.http.servlet;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.resources.WsservletMessages;
import com.sun.xml.ws.transport.http.DeploymentDescriptorParser;
import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import com.sun.xml.ws.transport.http.servlet.ServletAdapterList;
import com.sun.xml.ws.transport.http.servlet.ServletContainer;
import com.sun.xml.ws.transport.http.servlet.ServletResourceLoader;
import com.sun.xml.ws.transport.http.servlet.WSServletDelegate;
import com.sun.xml.ws.transport.http.servlet.WSServletException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.xml.ws.WebServiceException;

public final class WSServletContextListener
implements ServletContextAttributeListener,
ServletContextListener {
    private WSServletDelegate delegate;
    private static final String JAXWS_RI_RUNTIME = "/WEB-INF/sun-jaxws.xml";
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server.http");

    public void attributeAdded(ServletContextAttributeEvent event) {
    }

    public void attributeRemoved(ServletContextAttributeEvent event) {
    }

    public void attributeReplaced(ServletContextAttributeEvent event) {
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (this.delegate != null) {
            this.delegate.destroy();
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info(WsservletMessages.LISTENER_INFO_DESTROY());
        }
    }

    public void contextInitialized(ServletContextEvent event) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info(WsservletMessages.LISTENER_INFO_INITIALIZE());
        }
        ServletContext context = event.getServletContext();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        try {
            DeploymentDescriptorParser<ServletAdapter> parser = new DeploymentDescriptorParser<ServletAdapter>(classLoader, new ServletResourceLoader(context), this.createContainer(context), new ServletAdapterList());
            URL sunJaxWsXml = context.getResource(JAXWS_RI_RUNTIME);
            if (sunJaxWsXml == null) {
                throw new WebServiceException(WsservletMessages.NO_SUNJAXWS_XML(JAXWS_RI_RUNTIME));
            }
            List<ServletAdapter> adapters = parser.parse(sunJaxWsXml.toExternalForm(), sunJaxWsXml.openStream());
            this.delegate = this.createDelegate(adapters, context);
            context.setAttribute("com.sun.xml.ws.server.http.servletDelegate", (Object)this.delegate);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, WsservletMessages.LISTENER_PARSING_FAILED(e), e);
            context.removeAttribute("com.sun.xml.ws.server.http.servletDelegate");
            throw new WSServletException("listener.parsingFailed", e);
        }
    }

    @NotNull
    protected Container createContainer(ServletContext context) {
        return new ServletContainer(context);
    }

    @NotNull
    protected WSServletDelegate createDelegate(List<ServletAdapter> adapters, ServletContext context) {
        return new WSServletDelegate(adapters, context);
    }
}

