/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.model.wsdl;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.model.ParameterBinding;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundPortType;
import com.sun.xml.ws.model.wsdl.AbstractFeaturedObjectImpl;
import com.sun.xml.ws.model.wsdl.WSDLBoundOperationImpl;
import com.sun.xml.ws.model.wsdl.WSDLModelImpl;
import com.sun.xml.ws.model.wsdl.WSDLPortTypeImpl;
import com.sun.xml.ws.resources.ClientMessages;
import com.sun.xml.ws.util.QNameMap;
import com.sun.xml.ws.util.exception.LocatableWebServiceException;
import javax.jws.WebParam;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.MTOMFeature;

public final class WSDLBoundPortTypeImpl
extends AbstractFeaturedObjectImpl
implements WSDLBoundPortType {
    private final QName name;
    private final QName portTypeName;
    private WSDLPortTypeImpl portType;
    private BindingID bindingId;
    @NotNull
    private final WSDLModelImpl owner;
    private final QNameMap<WSDLBoundOperationImpl> bindingOperations = new QNameMap();
    private QNameMap<WSDLBoundOperationImpl> payloadMap;
    private WSDLBoundOperationImpl emptyPayloadOperation;
    private SOAPBinding.Style style = SOAPBinding.Style.DOCUMENT;

    public WSDLBoundPortTypeImpl(XMLStreamReader xsr, @NotNull WSDLModelImpl owner, QName name, QName portTypeName) {
        super(xsr);
        this.owner = owner;
        this.name = name;
        this.portTypeName = portTypeName;
        owner.addBinding(this);
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    @NotNull
    public WSDLModelImpl getOwner() {
        return this.owner;
    }

    @Override
    public WSDLBoundOperationImpl get(QName operationName) {
        return this.bindingOperations.get(operationName);
    }

    public void put(QName opName, WSDLBoundOperationImpl ptOp) {
        this.bindingOperations.put(opName, ptOp);
    }

    @Override
    public QName getPortTypeName() {
        return this.portTypeName;
    }

    @Override
    public WSDLPortTypeImpl getPortType() {
        return this.portType;
    }

    public Iterable<WSDLBoundOperationImpl> getBindingOperations() {
        return this.bindingOperations.values();
    }

    @Override
    public BindingID getBindingId() {
        return this.bindingId == null ? BindingID.SOAP11_HTTP : this.bindingId;
    }

    public void setBindingId(BindingID bindingId) {
        this.bindingId = bindingId;
    }

    public void setStyle(SOAPBinding.Style style) {
        this.style = style;
    }

    @Override
    public SOAPBinding.Style getStyle() {
        return this.style;
    }

    public boolean isRpcLit() {
        return SOAPBinding.Style.RPC == this.style;
    }

    public boolean isDoclit() {
        return SOAPBinding.Style.DOCUMENT == this.style;
    }

    public ParameterBinding getBinding(QName operation, String part, WebParam.Mode mode) {
        WSDLBoundOperationImpl op = this.get(operation);
        if (op == null) {
            return null;
        }
        if (WebParam.Mode.IN == mode || WebParam.Mode.INOUT == mode) {
            return op.getInputBinding(part);
        }
        return op.getOutputBinding(part);
    }

    public String getMimeType(QName operation, String part, WebParam.Mode mode) {
        WSDLBoundOperationImpl op = this.get(operation);
        if (WebParam.Mode.IN == mode) {
            return op.getMimeTypeForInputPart(part);
        }
        return op.getMimeTypeForOutputPart(part);
    }

    @Override
    public WSDLBoundOperationImpl getOperation(String namespaceUri, String localName) {
        if (namespaceUri == null && localName == null) {
            return this.emptyPayloadOperation;
        }
        return this.payloadMap.get(namespaceUri == null ? "" : namespaceUri, localName);
    }

    public void enableMTOM() {
        this.features.add((WebServiceFeature)new MTOMFeature());
    }

    public boolean isMTOMEnabled() {
        return this.features.isEnabled(MTOMFeature.class);
    }

    public SOAPVersion getSOAPVersion() {
        return this.getBindingId().getSOAPVersion();
    }

    void freeze() {
        this.portType = this.owner.getPortType(this.portTypeName);
        if (this.portType == null) {
            throw new LocatableWebServiceException(ClientMessages.UNDEFINED_PORT_TYPE(this.portTypeName), this.getLocation());
        }
        this.portType.freeze();
        for (WSDLBoundOperationImpl op : this.bindingOperations.values()) {
            op.freeze(this.owner);
        }
        this.freezePayloadMap();
        this.owner.finalizeRpcLitBinding(this);
    }

    private void freezePayloadMap() {
        if (this.style == SOAPBinding.Style.RPC) {
            this.payloadMap = new QNameMap();
            for (WSDLBoundOperationImpl op : this.bindingOperations.values()) {
                this.payloadMap.put(op.getReqPayloadName(), op);
            }
        } else {
            this.payloadMap = new QNameMap();
            for (WSDLBoundOperationImpl op : this.bindingOperations.values()) {
                QName name = op.getReqPayloadName();
                if (name == null) {
                    this.emptyPayloadOperation = op;
                    continue;
                }
                this.payloadMap.put(name, op);
            }
        }
    }
}

