/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pluginapi.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.calltime.CallTimeData;
import org.rhq.core.pluginapi.util.RegexSubstitution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseTimeLogParser {
    public static final int DEFAULT_TIME_MULTIPLIER = 1;
    protected final Log log = LogFactory.getLog(this.getClass());
    private double timeMultiplier;
    private long startingOffset;
    protected File logFile;
    protected List<Pattern> excludes;
    protected List<RegexSubstitution> transforms;

    public ResponseTimeLogParser(File logFile) {
        this(logFile, 1.0);
    }

    public ResponseTimeLogParser(File logFile, double timeMultiplier) {
        this.logFile = logFile;
        this.timeMultiplier = timeMultiplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void parseLog(CallTimeData callTimeData) throws IOException {
        this.log.debug((Object)("Parsing response-time log file " + this.logFile + "..."));
        BufferedReader in = null;
        try {
            String currentLine;
            in = new BufferedReader(new FileReader(this.logFile));
            in.skip(this.startingOffset);
            while ((currentLine = in.readLine()) != null) {
                LogEntry logEntry;
                try {
                    logEntry = this.parseLine(currentLine);
                }
                catch (Exception e) {
                    this.log.debug((Object)("Problem parsing line [" + currentLine + "] - cause: " + e));
                    continue;
                }
                String url = logEntry.getUrl();
                if (url.charAt(0) != '/') {
                    String truncatedUrl = url.substring(0, Math.min(url.length(), 120));
                    if (url.length() > 120) {
                        truncatedUrl = truncatedUrl + "...";
                    }
                    this.log.error((Object)("URL ('" + truncatedUrl + "') parsed from response-time log file does not begin with '/'. " + "Line being parsed is [" + currentLine + "]."));
                    continue;
                }
                if (this.isExcluded(url) || logEntry.getStatusCode() != null && (logEntry.getStatusCode() < 200 || logEntry.getStatusCode() >= 400)) continue;
                String transformedUrl = this.applyTransforms(url);
                callTimeData.addCallData(transformedUrl, new Date(logEntry.getStartTime()), logEntry.getDuration());
            }
        }
        catch (FileNotFoundException e) {
            this.log.warn((Object)("Response-time log file '" + this.logFile + "' does not exist."));
            return;
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    this.log.error((Object)"Unable to close response-time log file.", (Throwable)e);
                }
            }
        }
        this.truncateLog(this.logFile);
        this.startingOffset = this.logFile.length();
    }

    protected boolean isExcluded(String url) {
        boolean excluded = false;
        if (this.excludes != null) {
            for (Pattern exclude : this.excludes) {
                Matcher matcher = exclude.matcher(url);
                if (!matcher.find()) continue;
                this.log.debug((Object)("URL '" + url + "' excluded by exclude '" + exclude + "'"));
                excluded = true;
            }
        }
        return excluded;
    }

    protected String applyTransforms(String url) {
        String transformedUrl = null;
        if (this.transforms != null) {
            for (RegexSubstitution transform : this.transforms) {
                Matcher matcher = transform.getPattern().matcher(url);
                if (!matcher.find()) continue;
                transformedUrl = matcher.replaceFirst(transform.getReplacement());
                this.log.debug((Object)("URL '" + url + "' transformed to '" + transformedUrl + "' by transform '" + transform + "'."));
                break;
            }
        }
        return transformedUrl != null ? transformedUrl : url;
    }

    protected LogEntry parseLine(String line) throws Exception {
        LogEntry logEntry;
        try {
            StringTokenizer tokenizer = new StringTokenizer(line);
            String url = tokenizer.nextToken();
            long startTime = Long.parseLong(tokenizer.nextToken());
            long duration = (long)(Double.parseDouble(tokenizer.nextToken()) * this.timeMultiplier);
            Integer statusCode = null;
            String ipAddress = null;
            if (tokenizer.hasMoreTokens()) {
                statusCode = Integer.valueOf(tokenizer.nextToken());
                if (tokenizer.hasMoreTokens()) {
                    ipAddress = tokenizer.nextToken();
                }
            }
            logEntry = new LogEntry(url, startTime, duration, statusCode, ipAddress);
        }
        catch (RuntimeException e) {
            throw new Exception("Failed to parse response time log file line [" + line + "].", e);
        }
        return logEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void truncateLog(File logFile) throws IOException {
        this.log.debug((Object)("Truncating response-time log file: '" + logFile + "'..."));
        RandomAccessFile randomAccessFile = null;
        try {
            String mode = "rws";
            randomAccessFile = new RandomAccessFile(logFile, mode);
            this.log.debug((Object)"Truncating response-time log file: setting length to 0.");
            randomAccessFile.setLength(0L);
        }
        catch (SecurityException e) {
            this.log.debug((Object)"Unable to truncate response-time log file.", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            this.log.error((Object)"Unable to truncate response-time log file.", (Throwable)e);
        }
        finally {
            if (null != randomAccessFile) {
                try {
                    this.log.debug((Object)"Truncating response-time log file: closing file.");
                    randomAccessFile.close();
                }
                catch (Exception e) {
                    this.log.error((Object)"Unable to close response-time log file.", (Throwable)e);
                }
            }
        }
    }

    public File getLogFile() {
        return this.logFile;
    }

    public void setLogFile(File logFile) {
        this.logFile = logFile;
    }

    public double getTimeMultiplier() {
        return this.timeMultiplier;
    }

    public List<Pattern> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<Pattern> excludes) {
        this.excludes = excludes;
    }

    public List<RegexSubstitution> getTransforms() {
        return this.transforms;
    }

    public void setTransforms(List<RegexSubstitution> transforms) {
        this.transforms = transforms;
    }

    public class LogEntry {
        private String url;
        private long startTime;
        private long duration;
        private Integer statusCode;
        private String ipAddress;

        public LogEntry(String url, long startTime, long duration, Integer statusCode, String ipAddress) {
            this.url = url;
            this.startTime = startTime;
            this.duration = duration;
            this.statusCode = statusCode;
            this.ipAddress = ipAddress;
        }

        public String getUrl() {
            return this.url;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getDuration() {
            return this.duration;
        }

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public String getIpAddress() {
            return this.ipAddress;
        }
    }
}

