/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import junit.framework.TestCase;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.NodeTest;
import org.custommonkey.xmlunit.NodeTester;
import org.custommonkey.xmlunit.Validator;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XSLTConstants;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLTestCase
extends TestCase
implements XSLTConstants {
    public XMLTestCase() {
    }

    public XMLTestCase(String name) {
        super(name);
    }

    public void setIgnoreWhitespace(boolean ignore) {
        XMLUnit.setIgnoreWhitespace(ignore);
    }

    public void setControlParser(String parser) {
        XMLUnit.setControlParser(parser);
    }

    public void setTestParser(String parser) {
        XMLUnit.setTestParser(parser);
    }

    public Diff compareXML(Reader control, Reader test) throws SAXException, IOException, ParserConfigurationException {
        return XMLUnit.compareXML(control, test);
    }

    public Diff compareXML(String control, Reader test) throws SAXException, IOException, ParserConfigurationException {
        return XMLUnit.compareXML((Reader)new StringReader(control), test);
    }

    public Diff compareXML(Reader control, String test) throws SAXException, IOException, ParserConfigurationException {
        return XMLUnit.compareXML(control, (Reader)new StringReader(test));
    }

    public Diff compareXML(String control, String test) throws SAXException, IOException, ParserConfigurationException {
        return XMLUnit.compareXML(control, test);
    }

    public Diff compareXML(Document control, Document test) {
        return XMLUnit.compareXML(control, test);
    }

    public void assertXMLEqual(Diff diff, boolean assertion) {
        XMLAssert.assertXMLEqual(diff, assertion);
    }

    public void assertXMLEqual(Diff diff, boolean assertion, String msg) {
        XMLAssert.assertXMLEqual(msg, diff, assertion);
    }

    public void assertXMLEqual(String msg, Diff diff, boolean assertion) {
        XMLAssert.assertXMLEqual(msg, diff, assertion);
    }

    public void assertXMLIdentical(Diff diff, boolean assertion) {
        XMLAssert.assertXMLEqual(diff.toString(), diff, assertion);
    }

    public void assertXMLIdentical(Diff diff, boolean assertion, String msg) {
        XMLAssert.assertXMLIdentical(msg, diff, assertion);
    }

    public void assertXMLIdentical(String msg, Diff diff, boolean assertion) {
        XMLAssert.assertXMLIdentical(msg, diff, assertion);
    }

    public void assertXMLEqual(String control, String test) throws SAXException, IOException, ParserConfigurationException {
        XMLAssert.assertXMLEqual(control, test);
    }

    public void assertXMLEqual(Document control, Document test) {
        XMLAssert.assertXMLEqual(control, test);
    }

    public void assertXMLEqual(Reader control, Reader test) throws SAXException, IOException, ParserConfigurationException {
        XMLAssert.assertXMLEqual(control, test);
    }

    public void assertXMLEqual(String err, String control, String test) throws SAXException, IOException, ParserConfigurationException {
        XMLAssert.assertXMLEqual(err, control, test);
    }

    public void assertXMLEqual(String err, Document control, Document test) {
        XMLAssert.assertXMLEqual(err, control, test);
    }

    public void assertXMLEqual(String err, Reader control, Reader test) throws SAXException, IOException, ParserConfigurationException {
        XMLAssert.assertXMLEqual(err, control, test);
    }

    public void assertXMLNotEqual(String control, String test) throws SAXException, IOException, ParserConfigurationException {
        XMLAssert.assertXMLNotEqual(control, test);
    }

    public void assertXMLNotEqual(String err, String control, String test) throws SAXException, IOException, ParserConfigurationException {
        XMLAssert.assertXMLNotEqual(err, control, test);
    }

    public void assertXMLNotEqual(Document control, Document test) {
        XMLAssert.assertXMLNotEqual(control, test);
    }

    public void assertXMLNotEqual(String err, Document control, Document test) {
        XMLAssert.assertXMLNotEqual(err, control, test);
    }

    public void assertXMLNotEqual(Reader control, Reader test) throws SAXException, IOException, ParserConfigurationException {
        XMLAssert.assertXMLNotEqual(control, test);
    }

    public void assertXMLNotEqual(String err, Reader control, Reader test) throws SAXException, IOException, ParserConfigurationException {
        XMLAssert.assertXMLEqual(err, control, test);
    }

    public void assertXpathsEqual(String controlXpath, String testXpath, Document document) throws TransformerException {
        XMLAssert.assertXpathsEqual(controlXpath, testXpath, document);
    }

    public void assertXpathsEqual(String controlXpath, String testXpath, String inXMLString) throws SAXException, ParserConfigurationException, TransformerException, IOException {
        XMLAssert.assertXpathsEqual(controlXpath, testXpath, inXMLString);
    }

    public void assertXpathsEqual(String controlXpath, String inControlXMLString, String testXpath, String inTestXMLString) throws SAXException, ParserConfigurationException, IOException, TransformerException {
        XMLAssert.assertXpathsEqual(controlXpath, inControlXMLString, testXpath, inTestXMLString);
    }

    public void assertXpathsEqual(String controlXpath, Document controlDocument, String testXpath, Document testDocument) throws TransformerException {
        XMLAssert.assertXpathsEqual(controlXpath, controlDocument, testXpath, testDocument);
    }

    public void assertXpathsNotEqual(String controlXpath, String testXpath, Document document) throws TransformerException {
        XMLAssert.assertXpathsNotEqual(controlXpath, testXpath, document);
    }

    public void assertXpathsNotEqual(String controlXpath, String testXpath, String inXMLString) throws SAXException, ParserConfigurationException, TransformerException, IOException {
        XMLAssert.assertXpathsNotEqual(controlXpath, testXpath, inXMLString);
    }

    public void assertXpathsNotEqual(String controlXpath, String inControlXMLString, String testXpath, String inTestXMLString) throws SAXException, ParserConfigurationException, IOException, TransformerException {
        XMLAssert.assertXpathsNotEqual(controlXpath, inControlXMLString, testXpath, inTestXMLString);
    }

    public void assertXpathsNotEqual(String controlXpath, Document controlDocument, String testXpath, Document testDocument) throws TransformerException {
        XMLAssert.assertXpathsNotEqual(controlXpath, controlDocument, testXpath, testDocument);
    }

    public void assertXpathValuesEqual(String controlXpath, String testXpath, Document document) throws TransformerException, TransformerConfigurationException {
        XMLAssert.assertXpathValuesEqual(controlXpath, testXpath, document);
    }

    public void assertXpathValuesEqual(String controlXpath, String testXpath, String inXMLString) throws SAXException, ParserConfigurationException, IOException, TransformerException, TransformerConfigurationException {
        XMLAssert.assertXpathValuesEqual(controlXpath, testXpath, inXMLString);
    }

    public void assertXpathValuesEqual(String controlXpath, String inControlXMLString, String testXpath, String inTestXMLString) throws SAXException, ParserConfigurationException, IOException, TransformerException, TransformerConfigurationException {
        XMLAssert.assertXpathValuesEqual(controlXpath, inControlXMLString, testXpath, inTestXMLString);
    }

    public void assertXpathValuesEqual(String controlXpath, Document controlDocument, String testXpath, Document testDocument) throws TransformerException, TransformerConfigurationException {
        XMLAssert.assertXpathValuesEqual(controlXpath, controlDocument, testXpath, testDocument);
    }

    public void assertXpathValuesNotEqual(String controlXpath, String testXpath, String inXMLString) throws SAXException, ParserConfigurationException, IOException, TransformerException, TransformerConfigurationException {
        XMLAssert.assertXpathValuesNotEqual(controlXpath, testXpath, inXMLString);
    }

    public void assertXpathValuesNotEqual(String controlXpath, String testXpath, Document document) throws TransformerException, TransformerConfigurationException {
        XMLAssert.assertXpathValuesNotEqual(controlXpath, testXpath, document);
    }

    public void assertXpathValuesNotEqual(String controlXpath, String inControlXMLString, String testXpath, String inTestXMLString) throws SAXException, ParserConfigurationException, IOException, TransformerException, TransformerConfigurationException {
        XMLAssert.assertXpathValuesNotEqual(controlXpath, inControlXMLString, testXpath, inTestXMLString);
    }

    public void assertXpathValuesNotEqual(String controlXpath, Document controlDocument, String testXpath, Document testDocument) throws TransformerException, TransformerConfigurationException {
        XMLAssert.assertXpathValuesNotEqual(controlXpath, controlDocument, testXpath, testDocument);
    }

    public void assertXpathEvaluatesTo(String expectedValue, String xpathExpression, String inXMLString) throws SAXException, IOException, ParserConfigurationException, TransformerException, TransformerConfigurationException {
        XMLAssert.assertXpathEvaluatesTo(expectedValue, xpathExpression, inXMLString);
    }

    public void assertXpathEvaluatesTo(String expectedValue, String xpathExpression, Document inDocument) throws TransformerException {
        XMLAssert.assertXpathEvaluatesTo(expectedValue, xpathExpression, inDocument);
    }

    public void assertXpathExists(String xPathExpression, String inXMLString) throws TransformerException, ParserConfigurationException, IOException, SAXException {
        XMLAssert.assertXpathExists(xPathExpression, inXMLString);
    }

    public void assertXpathExists(String xPathExpression, Document inDocument) throws TransformerException {
        XMLAssert.assertXpathExists(xPathExpression, inDocument);
    }

    public void assertXpathNotExists(String xPathExpression, String inXMLString) throws TransformerException, ParserConfigurationException, IOException, SAXException {
        XMLAssert.assertXpathNotExists(xPathExpression, inXMLString);
    }

    public void assertNotXpathExists(String xPathExpression, String inXMLString) throws TransformerException, ParserConfigurationException, IOException, SAXException {
        XMLAssert.assertXpathNotExists(xPathExpression, inXMLString);
    }

    public void assertXpathNotExists(String xPathExpression, Document inDocument) throws TransformerException {
        XMLAssert.assertXpathNotExists(xPathExpression, inDocument);
    }

    public void assertNotXpathExists(String xPathExpression, Document inDocument) throws TransformerException {
        XMLAssert.assertXpathNotExists(xPathExpression, inDocument);
    }

    public void assertXMLValid(String xmlString) throws SAXException, ParserConfigurationException {
        XMLAssert.assertXMLValid(xmlString);
    }

    public void assertXMLValid(String xmlString, String systemId) throws SAXException, ParserConfigurationException {
        XMLAssert.assertXMLValid(xmlString, systemId);
    }

    public void assertXMLValid(String xmlString, String systemId, String doctype) throws SAXException, ParserConfigurationException {
        XMLAssert.assertXMLValid(xmlString, systemId, doctype);
    }

    public void assertXMLValid(Validator validator) {
        XMLAssert.assertXMLValid(validator);
    }

    public void assertNodeTestPasses(String xmlString, NodeTester tester, short nodeType) throws SAXException, ParserConfigurationException, IOException {
        XMLAssert.assertNodeTestPasses(xmlString, tester, nodeType);
    }

    public void assertNodeTestPasses(NodeTest test, NodeTester tester, short[] nodeTypes, boolean assertion) {
        XMLAssert.assertNodeTestPasses(test, tester, nodeTypes, assertion);
    }
}

