/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.client.spi;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jboss.deployers.client.spi.MissingDependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncompleteDeployments
implements Serializable {
    private static final long serialVersionUID = -8413355643801749950L;
    private Map<String, Throwable> deploymentsInError;
    private Collection<String> deploymentsMissingDeployer;
    private Map<String, Throwable> contextsInError;
    private Map<String, Set<MissingDependency>> contextsMissingDependencies;
    private String deploymentsInErrorInfo;
    private String deploymentsMissingDeployerInfo;
    private String contextsInErrorInfo;
    private String contextsMissingDependenciesInfo;

    public IncompleteDeployments(Map<String, Throwable> deploymentsInError, Collection<String> deploymentsMissingDeployer, Map<String, Throwable> contextsInError, Map<String, Set<MissingDependency>> contextsMissingDependencies) {
        if (deploymentsInError != null && !deploymentsInError.isEmpty()) {
            this.deploymentsInError = new TreeMap<String, Throwable>();
            this.deploymentsInError.putAll(deploymentsInError);
        }
        if (deploymentsMissingDeployer != null && !deploymentsMissingDeployer.isEmpty()) {
            this.deploymentsMissingDeployer = new TreeSet<String>();
            this.deploymentsMissingDeployer.addAll(deploymentsMissingDeployer);
        }
        if (contextsInError != null && !contextsInError.isEmpty()) {
            this.contextsInError = new TreeMap<String, Throwable>();
            this.contextsInError.putAll(contextsInError);
        }
        if (contextsMissingDependencies != null && !contextsMissingDependencies.isEmpty()) {
            this.contextsMissingDependencies = new TreeMap<String, Set<MissingDependency>>();
            this.contextsMissingDependencies.putAll(contextsMissingDependencies);
        }
    }

    public boolean isIncomplete() {
        if (this.deploymentsInError != null) {
            return true;
        }
        if (this.deploymentsMissingDeployer != null) {
            return true;
        }
        if (this.contextsInError != null) {
            return true;
        }
        return this.contextsMissingDependencies != null;
    }

    public boolean isInvalidDeployment(String deploymentName) {
        if (!this.isIncomplete()) {
            return false;
        }
        if (this.matchComponentName(deploymentName, this.getDeploymentsInError().keySet())) {
            return true;
        }
        return this.matchComponentName(deploymentName, this.getDeploymentsMissingDeployer());
    }

    public boolean isInvalidContext(String contextName) {
        if (!this.isIncomplete()) {
            return false;
        }
        if (this.matchComponentName(contextName, this.getContextsInError().keySet())) {
            return true;
        }
        return this.matchComponentName(contextName, this.getContextsMissingDependencies().keySet());
    }

    public String getDeploymentsInErrorInfo() {
        if (this.deploymentsInErrorInfo == null) {
            StringBuilder buffer = new StringBuilder();
            Map<String, Throwable> deploymentsInError = this.getDeploymentsInError();
            if (!deploymentsInError.isEmpty()) {
                buffer.append("\n*** DEPLOYMENTS IN ERROR: Name -> Error\n\n");
                for (Map.Entry<String, Throwable> entry : deploymentsInError.entrySet()) {
                    buffer.append(entry.getKey()).append(" -> ").append(entry.getValue().toString()).append("\n\n");
                }
            }
            this.deploymentsInErrorInfo = buffer.toString();
        }
        return this.deploymentsInErrorInfo;
    }

    public String getDeploymentsMissingDeployerInfo() {
        if (this.deploymentsMissingDeployerInfo == null) {
            StringBuilder buffer = new StringBuilder();
            Collection<String> deploymentsMissingDeployers = this.getDeploymentsMissingDeployer();
            if (!deploymentsMissingDeployers.isEmpty()) {
                buffer.append("\n*** DEPLOYMENTS MISSING DEPLOYERS: Name\n\n");
                for (String name : deploymentsMissingDeployers) {
                    buffer.append(name).append('\n');
                }
            }
            this.deploymentsMissingDeployerInfo = buffer.toString();
        }
        return this.deploymentsMissingDeployerInfo;
    }

    private static void mergeRootCauses(Map<String, Set<String>> rootCauses, String key, String value) {
        Set<String> values = rootCauses.get(key);
        if (values == null) {
            values = Collections.singleton(value);
            rootCauses.put(key, values);
        } else {
            values = new HashSet<String>(values);
            values.add(value);
            rootCauses.put(key, values);
        }
    }

    protected void calculateContextsError() {
        Map<String, Throwable> contextsInError;
        HashMap<String, Set<String>> rootCauses = new HashMap<String, Set<String>>();
        Map<String, Set<MissingDependency>> contextsMissingDependencies = this.getContextsMissingDependencies();
        if (!contextsMissingDependencies.isEmpty()) {
            for (Map.Entry<String, Set<MissingDependency>> entry : contextsMissingDependencies.entrySet()) {
                for (MissingDependency missingDependency : entry.getValue()) {
                    IncompleteDeployments.mergeRootCauses(rootCauses, missingDependency.getDependency(), missingDependency.getActualState());
                }
            }
        }
        if (!(contextsInError = this.getContextsInError()).isEmpty()) {
            for (Map.Entry<String, Throwable> entry : contextsInError.entrySet()) {
                Throwable throwable = entry.getValue();
                if (throwable == null) {
                    IncompleteDeployments.mergeRootCauses(rootCauses, entry.getKey(), "** UNKNOWN ERROR **");
                    continue;
                }
                IncompleteDeployments.mergeRootCauses(rootCauses, entry.getKey(), throwable.toString());
            }
        }
        StringBuilder buffer = new StringBuilder();
        if (!contextsMissingDependencies.isEmpty()) {
            buffer.append("\nDEPLOYMENTS MISSING DEPENDENCIES:\n");
            for (Map.Entry entry : contextsMissingDependencies.entrySet()) {
                String name = (String)entry.getKey();
                buffer.append(String.format("  Deployment \"%s\" is missing the following dependencies:\n", name));
                for (MissingDependency dependency : (Set)entry.getValue()) {
                    buffer.append(String.format("    Dependency \"%s\" (should be in state \"%s\", but is actually in state \"%s\")\n", dependency.getDependency(), dependency.getRequiredState(), dependency.getActualState()));
                }
                rootCauses.remove(name);
            }
        }
        this.contextsMissingDependenciesInfo = buffer.toString();
        buffer.setLength(0);
        if (!rootCauses.isEmpty()) {
            buffer.append("\nDEPLOYMENTS IN ERROR:\n");
            for (String string : rootCauses.keySet()) {
                buffer.append(String.format("  Deployment \"%s\" is in error due to the following reason(s): ", string));
                Set values = (Set)rootCauses.get(string);
                Iterator it = values.iterator();
                while (it.hasNext()) {
                    buffer.append((String)it.next());
                    if (!it.hasNext()) continue;
                    buffer.append(", ");
                }
                buffer.append("\n");
            }
        }
        this.contextsInErrorInfo = buffer.toString();
    }

    public String getContextsInErrorInfo() {
        if (this.contextsInErrorInfo == null) {
            this.calculateContextsError();
        }
        return this.contextsInErrorInfo;
    }

    public String getContextsMissingDependenciesInfo() {
        if (this.contextsMissingDependenciesInfo == null) {
            this.calculateContextsError();
        }
        return this.contextsMissingDependenciesInfo;
    }

    protected boolean matchComponentName(String componentName, Collection<String> strings) {
        return strings.contains(componentName);
    }

    public Map<String, Throwable> getContextsInError() {
        if (this.contextsInError == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.contextsInError);
    }

    public Map<String, Set<MissingDependency>> getContextsMissingDependencies() {
        if (this.contextsMissingDependencies == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.contextsMissingDependencies);
    }

    public Map<String, Throwable> getDeploymentsInError() {
        if (this.deploymentsInError == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.deploymentsInError);
    }

    public Collection<String> getDeploymentsMissingDeployer() {
        if (this.deploymentsMissingDeployer == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(this.deploymentsMissingDeployer);
    }
}

