/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.webdav.lib.methods;

import hidden.org.apache.commons.httpclient.HttpConnection;
import hidden.org.apache.commons.httpclient.HttpException;
import hidden.org.apache.commons.httpclient.HttpState;
import hidden.org.apache.webdav.lib.methods.DepthSupport;
import hidden.org.apache.webdav.lib.methods.XMLResponseMethodBase;
import hidden.org.apache.webdav.lib.util.XMLPrinter;
import java.io.IOException;
import java.io.InputStream;

public class VersionControlMethod
extends XMLResponseMethodBase
implements DepthSupport {
    private String sComment;
    private String sCreatorDisplayName;
    private String sTarget = null;

    public VersionControlMethod() {
        this.sComment = "none";
        this.sCreatorDisplayName = "unknown";
    }

    public VersionControlMethod(String path) {
        super(path);
    }

    public VersionControlMethod(String path, String sTarget) {
        super(path);
        this.sTarget = sTarget;
    }

    public int getDepth() {
        return 0;
    }

    public void setDepth(int depth) {
    }

    public void setRequestHeader(String headerName, String headerValue) {
        super.setRequestHeader(headerName, headerValue);
        if (this.sTarget != null && this.getRequestHeader("Content-Type") == null) {
            super.setRequestHeader("Content-Type", "text/xml; charset=utf-8");
        }
    }

    public String getName() {
        return "VERSION-CONTROL";
    }

    protected String generateRequestBody() {
        if (this.sTarget != null) {
            XMLPrinter printer = new XMLPrinter();
            printer.writeXMLHeader();
            printer.writeElement("D", "DAV:", "version-control", 0);
            printer.writeElement("D", "version", 0);
            printer.writeElement("D", "href", 0);
            printer.writeText(this.sTarget);
            printer.writeElement("D", "href", 1);
            printer.writeElement("D", "version", 1);
            printer.writeElement("D", "version-control", 1);
            return printer.toString();
        }
        return "";
    }

    public void parseResponse(InputStream input, HttpState state, HttpConnection conn) throws IOException, HttpException {
        try {
            int code = this.getStatusLine().getStatusCode();
            if (code == 409 || code == 403) {
                this.parseXMLResponse(input);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }
}

