/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.audit;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditEvent {
    private String auditLevel = "Info";
    private Map<String, Object> contextMap = new HashMap<String, Object>();
    private Exception underlyingException = null;

    public AuditEvent(String level) {
        this.auditLevel = level;
    }

    public AuditEvent(String level, Map<String, Object> map) {
        this(level);
        this.contextMap = map;
    }

    public AuditEvent(String level, Map<String, Object> map, Exception ex) {
        this(level, map);
        this.underlyingException = ex;
    }

    public String getAuditLevel() {
        return this.auditLevel;
    }

    public Map<String, Object> getContextMap() {
        return this.contextMap;
    }

    public void setContextMap(Map<String, Object> cmap) {
        this.contextMap = cmap;
    }

    public Exception getUnderlyingException() {
        return this.underlyingException;
    }

    public void setUnderlyingException(Exception underlyingException) {
        this.underlyingException = underlyingException;
    }

    public String toString() {
        StringBuilder sbu = new StringBuilder();
        sbu.append("[").append(this.auditLevel).append("]");
        sbu.append(this.dissectContextMap());
        return sbu.toString();
    }

    private String dissectContextMap() {
        StringBuilder sbu = new StringBuilder();
        if (this.contextMap != null) {
            for (String key : this.contextMap.keySet()) {
                sbu.append(key).append("=");
                List<Object> obj = this.contextMap.get(key);
                if (obj instanceof Object[]) {
                    Object[] arr = (Object[])obj;
                    obj = Arrays.asList(arr);
                }
                if (obj instanceof Collection) {
                    Collection coll = obj;
                    for (Object o : coll) {
                        sbu.append(o).append(";");
                    }
                    continue;
                }
                sbu.append(obj).append(";");
            }
        }
        return sbu.toString();
    }
}

