/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.readers;

import java.io.IOException;
import java.io.InputStream;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.readers.XMLEntityReader;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.utils.SymbolCache;
import org.apache.xerces.utils.UTF8DataChunk;
import org.apache.xerces.utils.XMLCharacterProperties;

final class UTF8Reader
extends XMLEntityReader {
    private static final boolean USE_OUT_OF_LINE_LOAD_NEXT_BYTE = false;
    private static final boolean USE_TRY_CATCH_FOR_LOAD_NEXT_BYTE = true;
    public static final byte[] fgAsciiAttValueChar = new byte[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 2, 2, 4, 4, 2, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 1, 0, 0, 0, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final byte[] fgAsciiEntityValueChar = new byte[]{7, 4, 4, 4, 4, 4, 4, 4, 4, 0, 5, 4, 4, 6, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 1, 0, 0, 3, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private char[] fCharacters = new char[16384];
    private int fCharDataLength = 0;
    private static final char[] cdata_string = new char[]{'C', 'D', 'A', 'T', 'A', '['};
    private StringPool.CharArrayRange fCharArrayRange = null;
    private InputStream fInputStream = null;
    private StringPool fStringPool = null;
    private UTF8DataChunk fCurrentChunk = null;
    private int fCurrentIndex = 0;
    private byte[] fMostRecentData = null;
    private int fMostRecentByte = 0;
    private int fLength = 0;
    private boolean fCalledCharPropInit = false;
    private boolean fCallClearPreviousChunk = true;

    public UTF8Reader(XMLEntityHandler xMLEntityHandler, XMLErrorReporter xMLErrorReporter, boolean bl, InputStream inputStream, StringPool stringPool) throws Exception {
        super(xMLEntityHandler, xMLErrorReporter, bl);
        this.fInputStream = inputStream;
        this.fStringPool = stringPool;
        this.fCharArrayRange = this.fStringPool.createCharArrayRange();
        this.fCurrentChunk = UTF8DataChunk.createChunk(this.fStringPool, null);
        this.fillCurrentChunk();
    }

    public int addString(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        return this.fCurrentChunk.addString(n, n2);
    }

    public int addSymbol(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        return this.fCurrentChunk.addSymbol(n, n2, 0);
    }

    private int addSymbol(int n, int n2, int n3) {
        if (n2 == 0) {
            return 0;
        }
        return this.fCurrentChunk.addSymbol(n, n2, n3);
    }

    public void append(XMLEntityHandler.CharBuffer charBuffer, int n, int n2) {
        this.fCurrentChunk.append(charBuffer, n, n2);
    }

    private int slowLoadNextByte() throws Exception {
        this.fCallClearPreviousChunk = true;
        if (this.fCurrentChunk.nextChunk() != null) {
            this.fCurrentChunk = this.fCurrentChunk.nextChunk();
            this.fCurrentIndex = 0;
            this.fMostRecentData = this.fCurrentChunk.toByteArray();
            this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
            return this.fMostRecentByte;
        }
        this.fCurrentChunk = UTF8DataChunk.createChunk(this.fStringPool, this.fCurrentChunk);
        return this.fillCurrentChunk();
    }

    private int loadNextByte() throws Exception {
        ++this.fCurrentOffset;
        ++this.fCurrentIndex;
        try {
            this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
            return this.fMostRecentByte;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return this.slowLoadNextByte();
        }
    }

    private boolean atEOF(int n) {
        return n > this.fLength;
    }

    public XMLEntityHandler.EntityReader changeReaders() throws Exception {
        XMLEntityHandler.EntityReader entityReader = super.changeReaders();
        this.fCurrentChunk.releaseChunk();
        this.fCurrentChunk = null;
        this.fMostRecentData = null;
        this.fMostRecentByte = 0;
        return entityReader;
    }

    public boolean lookingAtChar(char c, boolean bl) throws Exception {
        int n = this.fMostRecentByte;
        if (n != c) {
            if (n == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                return this.changeReaders().lookingAtChar(c, bl);
            }
            if (c == '\n' && n == 13) {
                if (bl) {
                    ++this.fCarriageReturnCounter;
                    this.fCharacterCounter = 1;
                    ++this.fCurrentOffset;
                    ++this.fCurrentIndex;
                    try {
                        n = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        n = this.slowLoadNextByte();
                    }
                    if (n == 10) {
                        ++this.fLinefeedCounter;
                        ++this.fCurrentOffset;
                        ++this.fCurrentIndex;
                        try {
                            this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            this.slowLoadNextByte();
                        }
                    }
                }
                return true;
            }
            return false;
        }
        if (c == '\r') {
            return false;
        }
        if (bl) {
            ++this.fCharacterCounter;
            ++this.fCurrentOffset;
            ++this.fCurrentIndex;
            try {
                this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.slowLoadNextByte();
            }
        }
        return true;
    }

    public boolean lookingAtValidChar(boolean bl) throws Exception {
        int n = this.fMostRecentByte;
        if (n < 128) {
            if (n >= 32 || n == 9) {
                if (bl) {
                    ++this.fCharacterCounter;
                    ++this.fCurrentOffset;
                    ++this.fCurrentIndex;
                    try {
                        this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        this.slowLoadNextByte();
                    }
                }
                return true;
            }
            if (n == 10) {
                if (bl) {
                    ++this.fLinefeedCounter;
                    this.fCharacterCounter = 1;
                    ++this.fCurrentOffset;
                    ++this.fCurrentIndex;
                    try {
                        this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        this.slowLoadNextByte();
                    }
                }
                return true;
            }
            if (n == 13) {
                if (bl) {
                    ++this.fCarriageReturnCounter;
                    this.fCharacterCounter = 1;
                    ++this.fCurrentOffset;
                    ++this.fCurrentIndex;
                    try {
                        n = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        n = this.slowLoadNextByte();
                    }
                    if (n == 10) {
                        ++this.fLinefeedCounter;
                        ++this.fCurrentOffset;
                        ++this.fCurrentIndex;
                        try {
                            this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            this.slowLoadNextByte();
                        }
                    }
                }
                return true;
            }
            if (n == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                return this.changeReaders().lookingAtValidChar(bl);
            }
            return false;
        }
        UTF8DataChunk uTF8DataChunk = this.fCurrentChunk;
        int n2 = this.fCurrentIndex;
        int n3 = this.fCurrentOffset;
        int n4 = this.loadNextByte();
        if ((0xE0 & n) == 192) {
            if (bl) {
                ++this.fCharacterCounter;
                this.loadNextByte();
            } else {
                this.fCurrentChunk = uTF8DataChunk;
                this.fCurrentIndex = n2;
                this.fCurrentOffset = n3;
                this.fMostRecentData = uTF8DataChunk.toByteArray();
                this.fMostRecentByte = n;
            }
            return true;
        }
        int n5 = this.loadNextByte();
        if ((0xF0 & n) == 224) {
            boolean bl2 = false;
            if (!(n == 237 && n4 >= 160 || n == 239 && n4 == 191 && n5 >= 190)) {
                if (bl) {
                    ++this.fCharacterCounter;
                    this.loadNextByte();
                    return true;
                }
                bl2 = true;
            }
            this.fCurrentChunk = uTF8DataChunk;
            this.fCurrentIndex = n2;
            this.fCurrentOffset = n3;
            this.fMostRecentData = uTF8DataChunk.toByteArray();
            this.fMostRecentByte = n;
            return bl2;
        }
        int n6 = this.loadNextByte();
        boolean bl3 = false;
        if ((n & 0xF8) == 240 && (n4 & 0xC0) == 128 && (n5 & 0xC0) == 128 && (n6 & 0xC0) == 128) {
            if (n <= 244 && (n != 244 || n4 < 144)) {
                if (bl) {
                    ++this.fCharacterCounter;
                    this.loadNextByte();
                    return true;
                }
                bl3 = true;
            }
            this.fCurrentChunk = uTF8DataChunk;
            this.fCurrentIndex = n2;
            this.fCurrentOffset = n3;
            this.fMostRecentData = uTF8DataChunk.toByteArray();
            this.fMostRecentByte = n;
            return bl3;
        }
        this.fCurrentChunk = uTF8DataChunk;
        this.fCurrentIndex = n2;
        this.fCurrentOffset = n3;
        this.fMostRecentData = uTF8DataChunk.toByteArray();
        this.fMostRecentByte = n;
        return bl3;
    }

    public boolean lookingAtSpace(boolean bl) throws Exception {
        int n = this.fMostRecentByte;
        if (n > 32) {
            return false;
        }
        if (n == 32 || n == 9) {
            if (!bl) {
                return true;
            }
            ++this.fCharacterCounter;
        } else if (n == 10) {
            if (!bl) {
                return true;
            }
            ++this.fLinefeedCounter;
            this.fCharacterCounter = 1;
        } else if (n == 13) {
            if (!bl) {
                return true;
            }
            ++this.fCarriageReturnCounter;
            this.fCharacterCounter = 1;
            ++this.fCurrentOffset;
            ++this.fCurrentIndex;
            try {
                n = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                n = this.slowLoadNextByte();
            }
            if (n != 10) {
                return true;
            }
            ++this.fLinefeedCounter;
        } else {
            if (n == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                return this.changeReaders().lookingAtSpace(bl);
            }
            return false;
        }
        ++this.fCurrentOffset;
        ++this.fCurrentIndex;
        try {
            this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.slowLoadNextByte();
        }
        return true;
    }

    public void skipToChar(char c) throws Exception {
        int n = this.fMostRecentByte;
        while (n != c) {
            if (n == 0) {
                if (this.atEOF(this.fCurrentOffset + 1)) {
                    this.changeReaders().skipToChar(c);
                    return;
                }
                ++this.fCharacterCounter;
            } else if (n == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
            } else if (n == 13) {
                ++this.fCarriageReturnCounter;
                this.fCharacterCounter = 1;
                n = this.loadNextByte();
                if (n != 10) continue;
                ++this.fLinefeedCounter;
            } else if (n < 128) {
                ++this.fCharacterCounter;
            } else {
                ++this.fCharacterCounter;
                if ((0xE0 & n) == 192) {
                    this.loadNextByte();
                } else if ((0xF0 & n) == 224) {
                    this.loadNextByte();
                    this.loadNextByte();
                } else {
                    this.loadNextByte();
                    this.loadNextByte();
                    this.loadNextByte();
                }
            }
            n = this.loadNextByte();
        }
        return;
    }

    public void skipPastSpaces() throws Exception {
        int n = this.fMostRecentByte;
        while (true) {
            if (n == 32 || n == 9) {
                ++this.fCharacterCounter;
            } else if (n == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
            } else if (n == 13) {
                ++this.fCarriageReturnCounter;
                this.fCharacterCounter = 1;
                ++this.fCurrentOffset;
                ++this.fCurrentIndex;
                try {
                    n = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    n = this.slowLoadNextByte();
                }
                if (n != 10) continue;
                ++this.fLinefeedCounter;
            } else {
                if (n == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                    this.changeReaders().skipPastSpaces();
                }
                return;
            }
            ++this.fCurrentOffset;
            ++this.fCurrentIndex;
            try {
                n = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                n = this.slowLoadNextByte();
                continue;
            }
            break;
        }
    }

    protected boolean skippedMultiByteCharWithFlag(int n, int n2) throws Exception {
        UTF8DataChunk uTF8DataChunk = this.fCurrentChunk;
        int n3 = this.fCurrentOffset;
        int n4 = this.fCurrentIndex;
        if (!this.fCalledCharPropInit) {
            XMLCharacterProperties.initCharFlags();
            this.fCalledCharPropInit = true;
        }
        int n5 = this.loadNextByte();
        if ((0xE0 & n) == 192) {
            if ((XMLCharacterProperties.fgCharFlags[((0x1F & n) << 6) + (0x3F & n5)] & n2) == 0) {
                this.fCurrentChunk = uTF8DataChunk;
                this.fCurrentIndex = n4;
                this.fCurrentOffset = n3;
                this.fMostRecentData = uTF8DataChunk.toByteArray();
                this.fMostRecentByte = n;
                return false;
            }
            return true;
        }
        int n6 = this.loadNextByte();
        if ((0xF0 & n) == 224) {
            if (n == 237 && n5 >= 160 || n == 239 && n5 == 191 && n6 >= 190) {
                this.fCurrentChunk = uTF8DataChunk;
                this.fCurrentIndex = n4;
                this.fCurrentOffset = n3;
                this.fMostRecentData = uTF8DataChunk.toByteArray();
                this.fMostRecentByte = n;
                return false;
            }
            if ((XMLCharacterProperties.fgCharFlags[((0xF & n) << 12) + ((0x3F & n5) << 6) + (0x3F & n6)] & n2) == 0) {
                this.fCurrentChunk = uTF8DataChunk;
                this.fCurrentIndex = n4;
                this.fCurrentOffset = n3;
                this.fMostRecentData = uTF8DataChunk.toByteArray();
                this.fMostRecentByte = n;
                return false;
            }
            return true;
        }
        this.fCurrentChunk = uTF8DataChunk;
        this.fCurrentIndex = n4;
        this.fCurrentOffset = n3;
        this.fMostRecentData = uTF8DataChunk.toByteArray();
        this.fMostRecentByte = n;
        return false;
    }

    public void skipPastName(char c) throws Exception {
        int n = this.fMostRecentByte;
        if (n < 128) {
            if (XMLCharacterProperties.fgAsciiInitialNameChar[n] == 0) {
                return;
            }
        } else {
            if (!this.fCalledCharPropInit) {
                XMLCharacterProperties.initCharFlags();
                this.fCalledCharPropInit = true;
            }
            if (!this.skippedMultiByteCharWithFlag(n, 2)) {
                return;
            }
        }
        while (true) {
            ++this.fCharacterCounter;
            n = this.loadNextByte();
            if (c == n) {
                return;
            }
            if (n < 128) {
                if (XMLCharacterProperties.fgAsciiNameChar[n] != 0) continue;
                return;
            }
            if (!this.fCalledCharPropInit) {
                XMLCharacterProperties.initCharFlags();
                this.fCalledCharPropInit = true;
            }
            if (!this.skippedMultiByteCharWithFlag(n, 4)) break;
        }
    }

    public void skipPastNmtoken(char c) throws Exception {
        int n = this.fMostRecentByte;
        while (c != n) {
            if (n < 128 ? XMLCharacterProperties.fgAsciiNameChar[n] == 0 : !this.skippedMultiByteCharWithFlag(n, 4)) {
                return;
            }
            ++this.fCharacterCounter;
            n = this.loadNextByte();
        }
        return;
    }

    /*
     * Unable to fully structure code
     */
    public boolean skippedString(char[] var1_1) throws Exception {
        block7: {
            var2_2 = var1_1.length;
            var3_3 = this.fMostRecentData;
            var4_4 = this.fCurrentIndex + var2_2;
            var5_5 = var2_2;
            try {
                while (var5_5-- > 0) {
                    if (var3_3[--var4_4] == var1_1[var5_5]) continue;
                    return false;
                }
                this.fCurrentIndex += var2_2;
                break block7;
            }
            catch (ArrayIndexOutOfBoundsException var6_6) {
                var7_8 = 0;
                var4_4 = this.fCurrentIndex;
                ** while (var4_4 < 16384)
            }
lbl-1000:
            // 1 sources

            {
                if (var3_3[var4_4++] == var1_1[var7_8++]) continue;
                return false;
            }
lbl17:
            // 1 sources

            var8_9 = this.fCurrentChunk;
            var9_10 = this.fCurrentOffset;
            var10_11 = this.fCurrentIndex;
            this.slowLoadNextByte();
            var3_3 = this.fMostRecentData;
            var4_4 = 0;
            while (var7_8 < var2_2) {
                if (var3_3[var4_4++] == var1_1[var7_8++]) continue;
                this.fCurrentChunk = var8_9;
                this.fCurrentIndex = var10_11;
                this.fCurrentOffset = var9_10;
                this.fMostRecentData = this.fCurrentChunk.toByteArray();
                this.fMostRecentByte = this.fMostRecentData[var10_11] & 255;
                return false;
            }
            this.fCurrentIndex = var4_4;
        }
        this.fCharacterCounter += var2_2;
        this.fCurrentOffset += var2_2;
        try {
            this.fMostRecentByte = var3_3[this.fCurrentIndex] & 255;
        }
        catch (ArrayIndexOutOfBoundsException var6_7) {
            this.slowLoadNextByte();
        }
        return true;
    }

    public int scanInvalidChar() throws Exception {
        int n = this.fMostRecentByte;
        int n2 = n;
        if (n2 == 10) {
            ++this.fLinefeedCounter;
            this.fCharacterCounter = 1;
        } else if (n2 == 13) {
            ++this.fCarriageReturnCounter;
            this.fCharacterCounter = 1;
            n2 = this.loadNextByte();
            if (n2 != 10) {
                return 10;
            }
            ++this.fLinefeedCounter;
        } else if (n2 == 0) {
            if (this.atEOF(this.fCurrentOffset + 1)) {
                return this.changeReaders().scanInvalidChar();
            }
            ++this.fCharacterCounter;
        } else if (n >= 128) {
            ++this.fCharacterCounter;
            int n3 = this.loadNextByte();
            int n4 = 0;
            if ((0xE0 & n) == 192) {
                n2 = ((0x1F & n) << 6) + (0x3F & n3);
            } else if ((0xF0 & n) == 224) {
                n4 = this.loadNextByte();
                n2 = ((0xF & n) << 12) + ((0x3F & n3) << 6) + (0x3F & n4);
            } else if ((0xF8 & n) == 240) {
                n4 = this.loadNextByte();
                int n5 = this.loadNextByte();
                n2 = ((0xF & n) << 18) + ((0x3F & n3) << 12) + ((0x3F & n4) << 6) + (0x3F & n5);
            }
        }
        this.loadNextByte();
        return n2;
    }

    public int scanCharRef(boolean bl) throws Exception {
        int n = this.fMostRecentByte;
        if (n == 0) {
            if (this.atEOF(this.fCurrentOffset + 1)) {
                return this.changeReaders().scanCharRef(bl);
            }
            return -2;
        }
        int n2 = 0;
        if (bl) {
            if (n > 102 || XMLCharacterProperties.fgAsciiXDigitChar[n] == 0) {
                return -2;
            }
            n2 = n - (n < 65 ? 48 : (n < 97 ? 65 : 97) - 10);
        } else {
            if (n < 48 || n > 57) {
                return -2;
            }
            n2 = n - 48;
        }
        ++this.fCharacterCounter;
        this.loadNextByte();
        boolean bl2 = false;
        while ((n = this.fMostRecentByte) != 0 && !(bl ? n > 102 || XMLCharacterProperties.fgAsciiXDigitChar[n] == 0 : n < 48 || n > 57)) {
            int n3;
            ++this.fCharacterCounter;
            this.loadNextByte();
            if (bl) {
                n3 = n - (n < 65 ? 48 : (n < 97 ? 65 : 97) - 10);
                n2 = (n2 << 4) + n3;
            } else {
                n3 = n - 48;
                n2 = n2 * 10 + n3;
            }
            if (n2 <= 0x10FFFF) continue;
            bl2 = true;
            n2 = 0;
        }
        if (n != 59) {
            return -1;
        }
        ++this.fCharacterCounter;
        this.loadNextByte();
        if (bl2) {
            return -3;
        }
        return n2;
    }

    public int scanStringLiteral() throws Exception {
        boolean bl = this.lookingAtChar('\'', true);
        if (!bl && !this.lookingAtChar('\"', true)) {
            return -1;
        }
        int n = this.fCurrentOffset;
        char c = bl ? (char)'\'' : '\"';
        while (!this.lookingAtChar(c, false)) {
            if (this.lookingAtValidChar(true)) continue;
            return -2;
        }
        int n2 = this.fCurrentChunk.addString(n, this.fCurrentOffset - n);
        this.lookingAtChar(c, true);
        return n2;
    }

    public int scanAttValue(char c, boolean bl) throws Exception {
        int n = this.fCurrentOffset;
        int n2 = this.fMostRecentByte;
        block11: while (true) {
            if (n2 < 128) {
                switch (fgAsciiAttValueChar[n2]) {
                    case 1: {
                        if (n2 == c) {
                            int n3 = this.fCurrentOffset - n;
                            int n4 = n3 == 0 ? 0 : (bl ? this.fCurrentChunk.addSymbol(n, n3, 0) : this.fCurrentChunk.addString(n, n3));
                            ++this.fCharacterCounter;
                            ++this.fCurrentOffset;
                            ++this.fCurrentIndex;
                            try {
                                this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                this.slowLoadNextByte();
                            }
                            return n4;
                        }
                    }
                    case 0: {
                        ++this.fCharacterCounter;
                        ++this.fCurrentOffset;
                        ++this.fCurrentIndex;
                        try {
                            n2 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            n2 = this.slowLoadNextByte();
                        }
                        continue block11;
                    }
                    case 2: {
                        return -1;
                    }
                    case 3: {
                        return -2;
                    }
                    case 4: {
                        return -3;
                    }
                }
                continue;
            }
            if (!this.skipMultiByteCharData(n2)) {
                return -3;
            }
            n2 = this.fMostRecentByte;
        }
    }

    public int scanEntityValue(int n, boolean bl) throws Exception {
        int n2 = this.fCurrentOffset;
        int n3 = this.fMostRecentByte;
        block20: while (true) {
            if (n3 < 128) {
                switch (fgAsciiEntityValueChar[n3]) {
                    case 1: {
                        if (n3 == n) {
                            if (!bl) {
                                return -1;
                            }
                            int n4 = this.fCurrentOffset - n2;
                            int n5 = n4 == 0 ? 0 : this.fCurrentChunk.addString(n2, n4);
                            ++this.fCharacterCounter;
                            ++this.fCurrentOffset;
                            ++this.fCurrentIndex;
                            try {
                                this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                this.slowLoadNextByte();
                            }
                            return n5;
                        }
                    }
                    case 0: {
                        ++this.fCharacterCounter;
                        ++this.fCurrentOffset;
                        ++this.fCurrentIndex;
                        try {
                            n3 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            n3 = this.slowLoadNextByte();
                        }
                        continue block20;
                    }
                    case 5: {
                        ++this.fLinefeedCounter;
                        this.fCharacterCounter = 1;
                        ++this.fCurrentOffset;
                        ++this.fCurrentIndex;
                        try {
                            n3 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            n3 = this.slowLoadNextByte();
                        }
                        continue block20;
                    }
                    case 6: {
                        ++this.fCarriageReturnCounter;
                        this.fCharacterCounter = 1;
                        ++this.fCurrentOffset;
                        ++this.fCurrentIndex;
                        try {
                            n3 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            n3 = this.slowLoadNextByte();
                        }
                        if (n3 != 10) continue block20;
                        ++this.fLinefeedCounter;
                        ++this.fCurrentOffset;
                        ++this.fCurrentIndex;
                        try {
                            n3 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            n3 = this.slowLoadNextByte();
                        }
                        continue block20;
                    }
                    case 2: {
                        return -2;
                    }
                    case 3: {
                        return -3;
                    }
                    case 7: {
                        if (this.atEOF(this.fCurrentOffset + 1)) {
                            this.changeReaders();
                            return -5;
                        }
                    }
                    case 4: {
                        return -4;
                    }
                }
                continue;
            }
            if (!this.skipMultiByteCharData(n3)) {
                return -4;
            }
            n3 = this.fMostRecentByte;
        }
    }

    public boolean scanExpectedName(char c, StringPool.CharArrayRange charArrayRange) throws Exception {
        char[] cArray = charArrayRange.chars;
        int n = charArrayRange.offset;
        int n2 = charArrayRange.length;
        int n3 = this.fMostRecentByte;
        int n4 = 0;
        int n5 = 0;
        while (true) {
            if (n3 < 128) {
                n4 = n3;
                if (n5 == n2) break;
                if (n4 != cArray[n]) {
                    this.skipPastNmtoken(c);
                    return false;
                }
            } else {
                int n6;
                UTF8DataChunk uTF8DataChunk = this.fCurrentChunk;
                int n7 = this.fCurrentIndex++;
                int n8 = this.fCurrentOffset++;
                try {
                    n6 = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    n6 = this.slowLoadNextByte();
                }
                if ((0xE0 & n3) == 192) {
                    n4 = ((0x1F & n3) << 6) + (0x3F & n6);
                    if (n5 == n2) break;
                    if (n4 != cArray[n]) {
                        this.fCurrentChunk = uTF8DataChunk;
                        this.fCurrentIndex = n7;
                        this.fCurrentOffset = n8;
                        this.fMostRecentData = uTF8DataChunk.toByteArray();
                        this.fMostRecentByte = n3;
                        this.skipPastNmtoken(c);
                        return false;
                    }
                } else {
                    int n9;
                    ++this.fCurrentOffset;
                    ++this.fCurrentIndex;
                    try {
                        n9 = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        n9 = this.slowLoadNextByte();
                    }
                    if ((0xF0 & n3) == 224) {
                        if (n3 == 237 && n6 >= 160 || n3 == 239 && n6 == 191 && n9 >= 190) {
                            this.fCurrentChunk = uTF8DataChunk;
                            this.fCurrentIndex = n7;
                            this.fCurrentOffset = n8;
                            this.fMostRecentData = uTF8DataChunk.toByteArray();
                            this.fMostRecentByte = n3;
                            return false;
                        }
                        n4 = ((0xF & n3) << 12) + ((0x3F & n6) << 6) + (0x3F & n9);
                        if (n5 == n2) break;
                        if (n4 != cArray[n]) {
                            this.fCurrentChunk = uTF8DataChunk;
                            this.fCurrentIndex = n7;
                            this.fCurrentOffset = n8;
                            this.fMostRecentData = uTF8DataChunk.toByteArray();
                            this.fMostRecentByte = n3;
                            this.skipPastNmtoken(c);
                            return false;
                        }
                    } else {
                        this.fCurrentChunk = uTF8DataChunk;
                        this.fCurrentIndex = n7;
                        this.fCurrentOffset = n8;
                        this.fMostRecentData = uTF8DataChunk.toByteArray();
                        this.fMostRecentByte = n3;
                        return false;
                    }
                }
            }
            ++n5;
            ++n;
            ++this.fCharacterCounter;
            ++this.fCurrentOffset;
            ++this.fCurrentIndex;
            try {
                n3 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                n3 = this.slowLoadNextByte();
            }
        }
        if (n4 == c) {
            return true;
        }
        if (n4 < 128) {
            if (XMLCharacterProperties.fgAsciiNameChar[n4] == 0) {
                return true;
            }
        } else {
            if (!this.fCalledCharPropInit) {
                XMLCharacterProperties.initCharFlags();
                this.fCalledCharPropInit = true;
            }
            if ((XMLCharacterProperties.fgCharFlags[n4] & 4) == 0) {
                return true;
            }
        }
        this.skipPastNmtoken(c);
        return false;
    }

    public void scanQName(char c, QName qName) throws Exception {
        int n = this.fCurrentOffset;
        int n2 = this.fMostRecentByte;
        if (n2 < 128) {
            if (XMLCharacterProperties.fgAsciiInitialNameChar[n2] == 0) {
                qName.clear();
                return;
            }
            if (n2 == 58) {
                qName.clear();
                return;
            }
        } else {
            if (!this.fCalledCharPropInit) {
                XMLCharacterProperties.initCharFlags();
                this.fCalledCharPropInit = true;
            }
            n2 = this.getMultiByteSymbolChar(n2);
            --this.fCurrentIndex;
            --this.fCurrentOffset;
            if ((XMLCharacterProperties.fgCharFlags[n2] & 2) == 0) {
                qName.clear();
                return;
            }
        }
        int n3 = this.fCurrentIndex;
        byte[] byArray = this.fMostRecentData;
        int n4 = -1;
        while (true) {
            ++this.fCharacterCounter;
            ++this.fCurrentOffset;
            ++n3;
            try {
                n2 = byArray[n3] & 0xFF;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                n2 = this.slowLoadNextByte();
                n3 = 0;
                byArray = this.fMostRecentData;
            }
            if (c == n2) break;
            if (n2 < 128) {
                if (XMLCharacterProperties.fgAsciiNameChar[n2] == 0) break;
                if (n2 != 58) continue;
                if (n4 != -1) break;
                n4 = this.fCurrentOffset;
                try {
                    n2 = byArray[n3 + 1] & 0xFF;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    UTF8DataChunk uTF8DataChunk = this.fCurrentChunk;
                    int n5 = this.fCurrentOffset;
                    n2 = this.slowLoadNextByte();
                    this.fCurrentChunk = uTF8DataChunk;
                    this.fCurrentOffset = n5;
                    this.fMostRecentData = this.fCurrentChunk.toByteArray();
                }
                boolean bl = true;
                if (n2 < 128) {
                    if (XMLCharacterProperties.fgAsciiInitialNameChar[n2] == 0 || n2 == 58) {
                        bl = false;
                    }
                } else {
                    if (!this.fCalledCharPropInit) {
                        XMLCharacterProperties.initCharFlags();
                        this.fCalledCharPropInit = true;
                    }
                    if ((XMLCharacterProperties.fgCharFlags[n2] & 2) == 0) {
                        bl = false;
                    }
                }
                n2 = 58;
                if (bl) continue;
                n4 = -1;
                break;
            }
            if (!this.fCalledCharPropInit) {
                XMLCharacterProperties.initCharFlags();
                this.fCalledCharPropInit = true;
            }
            this.fCurrentIndex = n3;
            this.fMostRecentByte = n2;
            n2 = this.getMultiByteSymbolChar(n2);
            --this.fCurrentIndex;
            --this.fCurrentOffset;
            n3 = this.fCurrentIndex;
            if ((XMLCharacterProperties.fgCharFlags[n2] & 4) == 0) break;
        }
        this.fCurrentIndex = n3;
        this.fMostRecentByte = n2;
        int n6 = this.fCurrentOffset - n;
        qName.rawname = this.addSymbol(n, n6);
        qName.prefix = n4 == -1 ? -1 : this.addSymbol(n, n4 - n);
        qName.localpart = n4 == -1 ? qName.rawname : this.addSymbol(n4 + 1, this.fCurrentOffset - (n4 + 1));
        qName.uri = -1;
    }

    private int getMultiByteSymbolChar(int n) throws Exception {
        int n2;
        int n3;
        UTF8DataChunk uTF8DataChunk = this.fCurrentChunk;
        int n4 = this.fCurrentIndex;
        int n5 = this.fCurrentOffset;
        if (!this.fCalledCharPropInit) {
            XMLCharacterProperties.initCharFlags();
            this.fCalledCharPropInit = true;
        }
        ++this.fCurrentOffset;
        ++this.fCurrentIndex;
        try {
            n3 = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            n3 = this.slowLoadNextByte();
        }
        if ((0xE0 & n) == 192) {
            int n6 = ((0x1F & n) << 6) + (0x3F & n3);
            if ((XMLCharacterProperties.fgCharFlags[n6] & 4) == 0) {
                this.fCurrentChunk = uTF8DataChunk;
                this.fCurrentIndex = n4;
                this.fCurrentOffset = n5;
                this.fMostRecentData = uTF8DataChunk.toByteArray();
                this.fMostRecentByte = n;
                return -1;
            }
            this.loadNextByte();
            return n6;
        }
        ++this.fCurrentOffset;
        ++this.fCurrentIndex;
        try {
            n2 = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            n2 = this.slowLoadNextByte();
        }
        if ((0xF0 & n) == 224) {
            if (n == 237 && n3 >= 160 || n == 239 && n3 == 191 && n2 >= 190) {
                this.fCurrentChunk = uTF8DataChunk;
                this.fCurrentIndex = n4;
                this.fCurrentOffset = n5;
                this.fMostRecentData = uTF8DataChunk.toByteArray();
                this.fMostRecentByte = n;
                return -1;
            }
            int n7 = ((0xF & n) << 12) + ((0x3F & n3) << 6) + (0x3F & n2);
            if ((XMLCharacterProperties.fgCharFlags[n7] & 4) == 0) {
                this.fCurrentChunk = uTF8DataChunk;
                this.fCurrentIndex = n4;
                this.fCurrentOffset = n5;
                this.fMostRecentData = uTF8DataChunk.toByteArray();
                this.fMostRecentByte = n;
                return -1;
            }
            this.loadNextByte();
            return n7;
        }
        this.fCurrentChunk = uTF8DataChunk;
        this.fCurrentIndex = n4;
        this.fCurrentOffset = n5;
        this.fMostRecentData = uTF8DataChunk.toByteArray();
        this.fMostRecentByte = n;
        return -1;
    }

    public int scanName(char c) throws Exception {
        int n;
        int n2 = this.fMostRecentByte;
        if (n2 < 128) {
            if (XMLCharacterProperties.fgAsciiInitialNameChar[n2] == 0) {
                if (n2 == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                    return this.changeReaders().scanName(c);
                }
                return -1;
            }
            n = n2;
        } else {
            int n3;
            UTF8DataChunk uTF8DataChunk = this.fCurrentChunk;
            int n4 = this.fCurrentIndex;
            int n5 = this.fCurrentOffset;
            if (!this.fCalledCharPropInit) {
                XMLCharacterProperties.initCharFlags();
                this.fCalledCharPropInit = true;
            }
            ++this.fCurrentOffset;
            ++this.fCurrentIndex;
            try {
                n3 = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                n3 = this.slowLoadNextByte();
            }
            if ((0xE0 & n2) == 192) {
                n = ((0x1F & n2) << 6) + (0x3F & n3);
                if ((XMLCharacterProperties.fgCharFlags[n] & 2) == 0) {
                    this.fCurrentChunk = uTF8DataChunk;
                    this.fCurrentIndex = n4;
                    this.fCurrentOffset = n5;
                    this.fMostRecentData = uTF8DataChunk.toByteArray();
                    this.fMostRecentByte = n2;
                    return -1;
                }
            } else {
                int n6;
                ++this.fCurrentOffset;
                ++this.fCurrentIndex;
                try {
                    n6 = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    n6 = this.slowLoadNextByte();
                }
                if ((0xF0 & n2) == 224) {
                    if (n2 == 237 && n3 >= 160 || n2 == 239 && n3 == 191 && n6 >= 190) {
                        this.fCurrentChunk = uTF8DataChunk;
                        this.fCurrentIndex = n4;
                        this.fCurrentOffset = n5;
                        this.fMostRecentData = uTF8DataChunk.toByteArray();
                        this.fMostRecentByte = n2;
                        return -1;
                    }
                    n = ((0xF & n2) << 12) + ((0x3F & n3) << 6) + (0x3F & n6);
                    if ((XMLCharacterProperties.fgCharFlags[n] & 2) == 0) {
                        this.fCurrentChunk = uTF8DataChunk;
                        this.fCurrentIndex = n4;
                        this.fCurrentOffset = n5;
                        this.fMostRecentData = uTF8DataChunk.toByteArray();
                        this.fMostRecentByte = n2;
                        return -1;
                    }
                } else {
                    this.fCurrentChunk = uTF8DataChunk;
                    this.fCurrentIndex = n4;
                    this.fCurrentOffset = n5;
                    this.fMostRecentData = uTF8DataChunk.toByteArray();
                    this.fMostRecentByte = n2;
                    return -1;
                }
            }
        }
        ++this.fCharacterCounter;
        ++this.fCurrentOffset;
        ++this.fCurrentIndex;
        try {
            n2 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            n2 = this.slowLoadNextByte();
        }
        return this.scanMatchingName(n, n2, c);
    }

    private int scanMatchingName(int n, int n2, int n3) throws Exception {
        SymbolCache symbolCache = this.fStringPool.getSymbolCache();
        Object object = symbolCache.fCacheLines;
        char[] cArray = symbolCache.fSymbolChars;
        boolean bl = n3 == this.fMostRecentByte;
        int n4 = symbolCache.fSymbolCharsOffset;
        int n5 = 0;
        int[] nArray = object[n5];
        int n6 = 1 + (nArray[0] - 1) * 3;
        int n7 = 0;
        if (bl) {
            while (n6 > 0) {
                if (nArray[n6 + 0] == n) {
                    if (nArray[n6 + 1] == -1) break;
                    int n8 = nArray[n6 + 1];
                    if (n7 > 3) {
                        this.fStringPool.updateCacheLine(n8, n7, 1);
                    }
                    return n8;
                }
                n6 -= 3;
                ++n7;
            }
            try {
                cArray[symbolCache.fSymbolCharsOffset] = (char)n;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                cArray = new char[symbolCache.fSymbolCharsOffset * 2];
                System.arraycopy(symbolCache.fSymbolChars, 0, cArray, 0, symbolCache.fSymbolCharsOffset);
                symbolCache.fSymbolChars = cArray;
                cArray[symbolCache.fSymbolCharsOffset] = (char)n;
            }
            ++symbolCache.fSymbolCharsOffset;
            if (n6 < 0) {
                n6 = 1 + nArray[0] * 3;
                nArray[0] = nArray[0] + 1;
                try {
                    nArray[n6 + 0] = n;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    int n9 = 1 + (n6 - 1) * 2;
                    nArray = new int[n9];
                    System.arraycopy(object[n5], 0, nArray, 0, n6);
                    object[n5] = nArray;
                    nArray[n6 + 0] = n;
                }
                nArray[n6 + 2] = -1;
            }
            int n10 = this.fStringPool.createNonMatchingSymbol(n4, n5, nArray, n6);
            return n10;
        }
        try {
            cArray[symbolCache.fSymbolCharsOffset] = (char)n;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            cArray = new char[symbolCache.fSymbolCharsOffset * 2];
            System.arraycopy(symbolCache.fSymbolChars, 0, cArray, 0, symbolCache.fSymbolCharsOffset);
            symbolCache.fSymbolChars = cArray;
            cArray[symbolCache.fSymbolCharsOffset] = (char)n;
        }
        ++symbolCache.fSymbolCharsOffset;
        int n11 = 1;
        while (n6 >= 0) {
            if (nArray[n6 + 0] != n) {
                n6 -= 3;
                ++n7;
                continue;
            }
            if (n2 >= 128) {
                n = this.getMultiByteSymbolChar(n2);
                n2 = this.fMostRecentByte;
            } else if (n2 == n3 || XMLCharacterProperties.fgAsciiNameChar[n2] == 0) {
                n = -1;
            } else {
                n = n2;
                ++this.fCharacterCounter;
                ++this.fCurrentOffset;
                ++this.fCurrentIndex;
                try {
                    n2 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    n2 = this.slowLoadNextByte();
                }
            }
            if (n == -1) {
                if (nArray[n6 + 1] == -1) {
                    return this.fStringPool.createNonMatchingSymbol(n4, n5, nArray, n6);
                }
                symbolCache.fSymbolCharsOffset = n4;
                int n12 = nArray[n6 + 1];
                if (n7 > n11 * 3) {
                    this.fStringPool.updateCacheLine(n12, n7, n11);
                }
                return n12;
            }
            try {
                cArray[symbolCache.fSymbolCharsOffset] = (char)n;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                cArray = new char[symbolCache.fSymbolCharsOffset * 2];
                System.arraycopy(symbolCache.fSymbolChars, 0, cArray, 0, symbolCache.fSymbolCharsOffset);
                symbolCache.fSymbolChars = cArray;
                cArray[symbolCache.fSymbolCharsOffset] = (char)n;
            }
            ++symbolCache.fSymbolCharsOffset;
            n5 = nArray[n6 + 2];
            try {
                nArray = object[n5];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (n5 == -1) {
                    nArray[n6 + 2] = n5 = symbolCache.fCacheLineCount++;
                    nArray = new int[13];
                    try {
                        object[n5] = nArray;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException2) {
                        object = new int[n5 * 2][];
                        System.arraycopy(symbolCache.fCacheLines, 0, object, 0, n5);
                        symbolCache.fCacheLines = object;
                        object[n5] = nArray;
                    }
                }
                nArray = object[n5];
                throw new RuntimeException("RDR001 untested");
            }
            n6 = 1 + (nArray[0] - 1) * 3;
            ++n11;
        }
        if (n6 < 0) {
            n6 = 1 + nArray[0] * 3;
        }
        while (true) {
            nArray[0] = nArray[0] + 1;
            try {
                nArray[n6 + 0] = n;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                int n13 = 1 + (n6 - 1) * 2;
                nArray = new int[n13];
                System.arraycopy(object[n5], 0, nArray, 0, n6);
                object[n5] = nArray;
                nArray[n6 + 0] = n;
            }
            if (n2 >= 128) {
                n = this.getMultiByteSymbolChar(n2);
                n2 = this.fMostRecentByte;
            } else if (n2 == n3 || XMLCharacterProperties.fgAsciiNameChar[n2] == 0) {
                n = -1;
            } else {
                n = n2;
                ++this.fCharacterCounter;
                ++this.fCurrentOffset;
                ++this.fCurrentIndex;
                try {
                    n2 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    n2 = this.slowLoadNextByte();
                }
            }
            if (n == -1) break;
            ++symbolCache.fCacheLineCount;
            nArray[n6 + 1] = -1;
            nArray[n6 + 2] = n5;
            nArray = new int[13];
            try {
                object[n5] = nArray;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                object = new int[n5 * 2][];
                System.arraycopy(symbolCache.fCacheLines, 0, object, 0, n5);
                symbolCache.fCacheLines = object;
                object[n5] = nArray;
            }
            n6 = 1;
            try {
                cArray[symbolCache.fSymbolCharsOffset] = (char)n;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                cArray = new char[symbolCache.fSymbolCharsOffset * 2];
                System.arraycopy(symbolCache.fSymbolChars, 0, cArray, 0, symbolCache.fSymbolCharsOffset);
                symbolCache.fSymbolChars = cArray;
                cArray[symbolCache.fSymbolCharsOffset] = (char)n;
            }
            ++symbolCache.fSymbolCharsOffset;
        }
        nArray[n6 + 2] = -1;
        int n14 = this.fStringPool.createNonMatchingSymbol(n4, n5, nArray, n6);
        return n14;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int recognizeMarkup(int n, QName qName) throws Exception {
        switch (n) {
            case 0: {
                return 11;
            }
            case 63: {
                ++this.fCharacterCounter;
                this.loadNextByte();
                return 0;
            }
            case 33: {
                ++this.fCharacterCounter;
                n = this.loadNextByte();
                if (n == 0) {
                    --this.fCharacterCounter;
                    --this.fCurrentOffset;
                    return 11;
                }
                if (n == 45) {
                    ++this.fCharacterCounter;
                    n = this.loadNextByte();
                    if (n == 0) {
                        this.fCharacterCounter -= 2;
                        this.fCurrentOffset -= 2;
                        return 11;
                    }
                    if (n != 45) return 10;
                    ++this.fCharacterCounter;
                    n = this.loadNextByte();
                    return 1;
                }
                if (n != 91) return 10;
                int n2 = 0;
                while (true) {
                    if (n2 >= 6) {
                        ++this.fCharacterCounter;
                        this.loadNextByte();
                        return 2;
                    }
                    ++this.fCharacterCounter;
                    n = this.loadNextByte();
                    if (n == 0) {
                        this.fCharacterCounter -= 2 + n2;
                        this.fCurrentOffset -= 2 + n2;
                        return 11;
                    }
                    if (n != cdata_string[n2]) {
                        return 10;
                    }
                    ++n2;
                }
            }
            case 47: {
                ++this.fCharacterCounter;
                ++this.fCurrentOffset;
                ++this.fCurrentIndex;
                try {
                    n = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    n = this.slowLoadNextByte();
                }
                int n3 = qName.rawname;
                this.fStringPool.getCharArrayRange(n3, this.fCharArrayRange);
                char[] cArray = this.fCharArrayRange.chars;
                int n4 = this.fCharArrayRange.offset;
                int n5 = this.fCharArrayRange.length;
                if (n != cArray[n4++]) return 4;
                UTF8DataChunk uTF8DataChunk = this.fCurrentChunk;
                int n6 = this.fCurrentIndex;
                int n7 = this.fCurrentOffset;
                int n8 = 1;
                while (true) {
                    if (n8 >= n5) {
                        this.fCharacterCounter += n5;
                        ++this.fCharacterCounter;
                        ++this.fCurrentOffset;
                        ++this.fCurrentIndex;
                        try {
                            n = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            n = this.slowLoadNextByte();
                        }
                        break;
                    }
                    ++this.fCurrentOffset;
                    ++this.fCurrentIndex;
                    try {
                        n = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        n = this.slowLoadNextByte();
                    }
                    if (n != cArray[n4++]) {
                        this.fCurrentChunk = uTF8DataChunk;
                        this.fCurrentIndex = n6;
                        this.fCurrentOffset = n7;
                        this.fMostRecentData = this.fCurrentChunk.toByteArray();
                        this.fMostRecentByte = this.fMostRecentData[n6] & 0xFF;
                        return 4;
                    }
                    ++n8;
                }
                if (n == 62) {
                    ++this.fCharacterCounter;
                    ++this.fCurrentOffset;
                    ++this.fCurrentIndex;
                    try {
                        this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                        return 5;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        this.slowLoadNextByte();
                    }
                    return 5;
                }
                do {
                    if (n != 32 && n != 9 && n != 10 && n != 13) {
                        this.fCurrentChunk = uTF8DataChunk;
                        this.fCurrentIndex = n6;
                        this.fCurrentOffset = n7;
                        this.fMostRecentData = this.fCurrentChunk.toByteArray();
                        this.fMostRecentByte = this.fMostRecentData[n6] & 0xFF;
                        return 4;
                    }
                    if (n == 10) {
                        ++this.fLinefeedCounter;
                        this.fCharacterCounter = 1;
                        n = this.loadNextByte();
                        continue;
                    }
                    if (n == 13) {
                        ++this.fCarriageReturnCounter;
                        this.fCharacterCounter = 1;
                        n = this.loadNextByte();
                        if (n != 10) continue;
                        ++this.fLinefeedCounter;
                        n = this.loadNextByte();
                        continue;
                    }
                    ++this.fCharacterCounter;
                    n = this.loadNextByte();
                } while (n != 62);
                ++this.fCharacterCounter;
                ++this.fCurrentOffset;
                ++this.fCurrentIndex;
                try {
                    this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                    return 5;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.slowLoadNextByte();
                }
                return 5;
            }
        }
        return 6;
    }

    private int recognizeReference(int n) throws Exception {
        if (n == 0) {
            return 12;
        }
        if (n == 35) {
            ++this.fCharacterCounter;
            this.loadNextByte();
            return 7;
        }
        return 8;
    }

    public int scanContent(QName qName) throws Exception {
        int n;
        int n2;
        if (this.fCallClearPreviousChunk && this.fCurrentChunk.clearPreviousChunk()) {
            this.fCallClearPreviousChunk = false;
        }
        this.fCharDataLength = 0;
        int n3 = this.fCurrentOffset++;
        int n4 = this.fMostRecentByte;
        if (n4 < 128) {
            block8 : switch (XMLCharacterProperties.fgAsciiWSCharData[n4]) {
                case 0: {
                    if (this.fSendCharDataAsCharArray) {
                        try {
                            this.fCharacters[this.fCharDataLength] = (char)n4;
                            ++this.fCharDataLength;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            this.slowAppendCharData(n4);
                        }
                    }
                    ++this.fCharacterCounter;
                    ++this.fCurrentOffset;
                    ++this.fCurrentIndex;
                    try {
                        n4 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        n4 = this.slowLoadNextByte();
                    }
                    break;
                }
                case 1: {
                    ++this.fCharacterCounter;
                    ++this.fCurrentIndex;
                    try {
                        n4 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        n4 = this.slowLoadNextByte();
                    }
                    if (!this.fInCDSect) {
                        return this.recognizeMarkup(n4, qName);
                    }
                    if (!this.fSendCharDataAsCharArray) break;
                    this.appendCharData(60);
                    break;
                }
                case 2: {
                    ++this.fCharacterCounter;
                    n4 = this.loadNextByte();
                    if (!this.fInCDSect) {
                        return this.recognizeReference(n4);
                    }
                    if (!this.fSendCharDataAsCharArray) break;
                    this.appendCharData(38);
                    break;
                }
                case 3: {
                    ++this.fCharacterCounter;
                    n4 = this.loadNextByte();
                    if (n4 != 93) {
                        if (!this.fSendCharDataAsCharArray) break;
                        this.appendCharData(93);
                        break;
                    }
                    if (this.fCurrentIndex + 1 == 16384) {
                        UTF8DataChunk uTF8DataChunk = this.fCurrentChunk;
                        int n5 = this.fCurrentIndex;
                        n2 = this.fCurrentOffset;
                        if (this.loadNextByte() != 62) {
                            this.fCurrentChunk = uTF8DataChunk;
                            this.fCurrentIndex = n5;
                            this.fCurrentOffset = n2;
                            this.fMostRecentData = this.fCurrentChunk.toByteArray();
                            this.fMostRecentByte = 93;
                            if (!this.fSendCharDataAsCharArray) break;
                            this.appendCharData(93);
                            break;
                        }
                    } else {
                        if (this.fMostRecentData[this.fCurrentIndex + 1] != 62) {
                            if (!this.fSendCharDataAsCharArray) break;
                            this.appendCharData(93);
                            break;
                        }
                        ++this.fCurrentIndex;
                        ++this.fCurrentOffset;
                    }
                    this.loadNextByte();
                    this.fCharacterCounter += 2;
                    return 3;
                }
                case 4: {
                    if (n4 == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                        this.changeReaders();
                        return 9;
                    }
                    return 9;
                }
                case 5: {
                    do {
                        if (n4 == 10) {
                            ++this.fLinefeedCounter;
                            this.fCharacterCounter = 1;
                        } else if (n4 == 13) {
                            ++this.fCarriageReturnCounter;
                            this.fCharacterCounter = 1;
                            ++this.fCurrentOffset;
                            ++this.fCurrentIndex;
                            try {
                                n4 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                n4 = this.slowLoadNextByte();
                            }
                            if (n4 != 10) {
                                if (this.fSendCharDataAsCharArray) {
                                    this.appendCharData(10);
                                }
                                if (n4 != 32 && n4 != 9 && n4 != 13) break;
                                continue;
                            }
                            ++this.fLinefeedCounter;
                        } else {
                            ++this.fCharacterCounter;
                        }
                        if (this.fSendCharDataAsCharArray) {
                            try {
                                this.fCharacters[this.fCharDataLength] = (char)n4;
                                ++this.fCharDataLength;
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                this.slowAppendCharData(n4);
                            }
                        }
                        ++this.fCurrentOffset;
                        ++this.fCurrentIndex;
                        try {
                            n4 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            n4 = this.slowLoadNextByte();
                        }
                    } while (n4 == 32 || n4 == 9 || n4 == 10 || n4 == 13);
                    if (n4 < 128) {
                        switch (XMLCharacterProperties.fgAsciiCharData[n4]) {
                            case 0: {
                                if (this.fSendCharDataAsCharArray) {
                                    this.appendCharData(n4);
                                }
                                ++this.fCharacterCounter;
                                n4 = this.loadNextByte();
                                break block8;
                            }
                            case 1: {
                                if (!this.fInCDSect) {
                                    if (this.fSendCharDataAsCharArray) {
                                        this.fCharDataHandler.processWhitespace(this.fCharacters, 0, this.fCharDataLength);
                                    } else {
                                        int n6 = this.addString(n3, this.fCurrentOffset - n3);
                                        this.fCharDataHandler.processWhitespace(n6);
                                    }
                                    ++this.fCharacterCounter;
                                    ++this.fCurrentOffset;
                                    ++this.fCurrentIndex;
                                    try {
                                        n4 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                                    }
                                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                        n4 = this.slowLoadNextByte();
                                    }
                                    return this.recognizeMarkup(n4, qName);
                                }
                                if (this.fSendCharDataAsCharArray) {
                                    this.appendCharData(60);
                                }
                                ++this.fCharacterCounter;
                                n4 = this.loadNextByte();
                                break block8;
                            }
                            case 2: {
                                if (!this.fInCDSect) {
                                    this.whitespace(n3, this.fCurrentOffset);
                                    ++this.fCharacterCounter;
                                    n4 = this.loadNextByte();
                                    return this.recognizeReference(n4);
                                }
                                if (this.fSendCharDataAsCharArray) {
                                    this.appendCharData(38);
                                }
                                ++this.fCharacterCounter;
                                n4 = this.loadNextByte();
                                break block8;
                            }
                            case 3: {
                                int n7 = this.fCurrentOffset++;
                                n4 = this.loadNextByte();
                                if (n4 != 93) {
                                    ++this.fCharacterCounter;
                                    if (!this.fSendCharDataAsCharArray) break;
                                    this.appendCharData(93);
                                    break block8;
                                }
                                if (this.fCurrentIndex + 1 == 16384) {
                                    UTF8DataChunk uTF8DataChunk = this.fCurrentChunk;
                                    n2 = this.fCurrentIndex;
                                    n = this.fCurrentOffset;
                                    if (this.loadNextByte() != 62) {
                                        this.fCurrentChunk = uTF8DataChunk;
                                        this.fCurrentIndex = n2;
                                        this.fCurrentOffset = n;
                                        this.fMostRecentData = this.fCurrentChunk.toByteArray();
                                        this.fMostRecentByte = 93;
                                        ++this.fCharacterCounter;
                                        if (!this.fSendCharDataAsCharArray) break;
                                        this.appendCharData(93);
                                        break block8;
                                    }
                                } else {
                                    if (this.fMostRecentData[this.fCurrentIndex + 1] != 62) {
                                        ++this.fCharacterCounter;
                                        if (!this.fSendCharDataAsCharArray) break;
                                        this.appendCharData(93);
                                        break block8;
                                    }
                                    ++this.fCurrentIndex;
                                }
                                this.loadNextByte();
                                this.whitespace(n3, n7);
                                this.fCharacterCounter += 3;
                                return 3;
                            }
                            case 4: {
                                this.whitespace(n3, this.fCurrentOffset);
                                if (n4 == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                                    this.changeReaders();
                                    return 9;
                                }
                                return 9;
                            }
                        }
                        break;
                    }
                    if (this.fSendCharDataAsCharArray) {
                        if (this.copyMultiByteCharData(n4)) break;
                        this.whitespace(n3, this.fCurrentOffset);
                        return 9;
                    }
                    if (this.skipMultiByteCharData(n4)) break;
                    this.whitespace(n3, this.fCurrentOffset);
                    return 9;
                }
            }
        } else if (this.fSendCharDataAsCharArray ? !this.copyMultiByteCharData(n4) : !this.skipMultiByteCharData(n4)) {
            return 9;
        }
        n4 = this.fSendCharDataAsCharArray ? this.copyAsciiCharData() : this.skipAsciiCharData();
        while (true) {
            if (n4 < 128) {
                switch (XMLCharacterProperties.fgAsciiCharData[n4]) {
                    case 0: {
                        if (this.fSendCharDataAsCharArray) {
                            this.appendCharData(n4);
                        }
                        ++this.fCharacterCounter;
                        n4 = this.loadNextByte();
                        break;
                    }
                    case 1: {
                        if (!this.fInCDSect) {
                            if (this.fSendCharDataAsCharArray) {
                                this.fCharDataHandler.processCharacters(this.fCharacters, 0, this.fCharDataLength);
                            } else {
                                int n8 = this.addString(n3, this.fCurrentOffset - n3);
                                this.fCharDataHandler.processCharacters(n8);
                            }
                            ++this.fCharacterCounter;
                            ++this.fCurrentOffset;
                            ++this.fCurrentIndex;
                            try {
                                n4 = this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                n4 = this.slowLoadNextByte();
                            }
                            return this.recognizeMarkup(n4, qName);
                        }
                        if (this.fSendCharDataAsCharArray) {
                            this.appendCharData(60);
                        }
                        ++this.fCharacterCounter;
                        n4 = this.loadNextByte();
                        break;
                    }
                    case 2: {
                        if (!this.fInCDSect) {
                            this.characters(n3, this.fCurrentOffset);
                            ++this.fCharacterCounter;
                            n4 = this.loadNextByte();
                            return this.recognizeReference(n4);
                        }
                        if (this.fSendCharDataAsCharArray) {
                            this.appendCharData(38);
                        }
                        ++this.fCharacterCounter;
                        n4 = this.loadNextByte();
                        break;
                    }
                    case 3: {
                        int n9 = this.fCurrentOffset++;
                        n4 = this.loadNextByte();
                        if (n4 != 93) {
                            ++this.fCharacterCounter;
                            if (!this.fSendCharDataAsCharArray) break;
                            this.appendCharData(93);
                            break;
                        }
                        if (this.fCurrentIndex + 1 == 16384) {
                            UTF8DataChunk uTF8DataChunk = this.fCurrentChunk;
                            n2 = this.fCurrentIndex;
                            n = this.fCurrentOffset;
                            if (this.loadNextByte() != 62) {
                                this.fCurrentChunk = uTF8DataChunk;
                                this.fCurrentIndex = n2;
                                this.fCurrentOffset = n;
                                this.fMostRecentData = this.fCurrentChunk.toByteArray();
                                this.fMostRecentByte = 93;
                                ++this.fCharacterCounter;
                                if (!this.fSendCharDataAsCharArray) break;
                                this.appendCharData(93);
                                break;
                            }
                        } else {
                            if (this.fMostRecentData[this.fCurrentIndex + 1] != 62) {
                                ++this.fCharacterCounter;
                                if (!this.fSendCharDataAsCharArray) break;
                                this.appendCharData(93);
                                break;
                            }
                            ++this.fCurrentIndex;
                        }
                        this.loadNextByte();
                        this.characters(n3, n9);
                        this.fCharacterCounter += 3;
                        return 3;
                    }
                    case 4: {
                        if (n4 == 10) {
                            if (this.fSendCharDataAsCharArray) {
                                this.appendCharData(n4);
                            }
                            ++this.fLinefeedCounter;
                            this.fCharacterCounter = 1;
                            n4 = this.loadNextByte();
                            break;
                        }
                        if (n4 == 13) {
                            if (this.fSendCharDataAsCharArray) {
                                this.appendCharData(10);
                            }
                            ++this.fCarriageReturnCounter;
                            this.fCharacterCounter = 1;
                            n4 = this.loadNextByte();
                            if (n4 != 10) break;
                            ++this.fLinefeedCounter;
                            n4 = this.loadNextByte();
                            break;
                        }
                        this.characters(n3, this.fCurrentOffset);
                        if (n4 == 0 && this.atEOF(this.fCurrentOffset + 1)) {
                            this.changeReaders();
                            return 9;
                        }
                        return 9;
                    }
                }
                continue;
            }
            if (this.fSendCharDataAsCharArray) {
                if (!this.copyMultiByteCharData(n4)) {
                    this.characters(n3, this.fCurrentOffset);
                    return 9;
                }
            } else if (!this.skipMultiByteCharData(n4)) {
                this.characters(n3, this.fCurrentOffset);
                return 9;
            }
            n4 = this.fMostRecentByte;
        }
    }

    private boolean copyMultiByteCharData(int n) throws Exception {
        UTF8DataChunk uTF8DataChunk = this.fCurrentChunk;
        int n2 = this.fCurrentOffset;
        int n3 = this.fCurrentIndex;
        int n4 = this.loadNextByte();
        if ((0xE0 & n) == 192) {
            int n5 = ((0x1F & n) << 6) + (0x3F & n4);
            this.appendCharData(n5);
            this.loadNextByte();
            return true;
        }
        int n6 = this.loadNextByte();
        if ((0xF0 & n) == 224) {
            if (n == 237 && n4 >= 160 || n == 239 && n4 == 191 && n6 >= 190) {
                this.fCurrentChunk = uTF8DataChunk;
                this.fCurrentIndex = n3;
                this.fCurrentOffset = n2;
                this.fMostRecentData = uTF8DataChunk.toByteArray();
                this.fMostRecentByte = n;
                return false;
            }
            int n7 = ((0xF & n) << 12) + ((0x3F & n4) << 6) + (0x3F & n6);
            this.appendCharData(n7);
            this.loadNextByte();
            return true;
        }
        int n8 = this.loadNextByte();
        if ((0xF8 & n) == 240) {
            if (n > 244 || n == 244 && n4 >= 144) {
                this.fCurrentChunk = uTF8DataChunk;
                this.fCurrentIndex = n3;
                this.fCurrentOffset = n2;
                this.fMostRecentData = uTF8DataChunk.toByteArray();
                this.fMostRecentByte = n;
                return false;
            }
            int n9 = ((0xF & n) << 18) + ((0x3F & n4) << 12) + ((0x3F & n6) << 6) + (0x3F & n8);
            if (n9 < 65536) {
                this.appendCharData(n9);
            } else {
                this.appendCharData((n9 - 65536 >> 10) + 55296);
                this.appendCharData((n9 - 65536 & 0x3FF) + 56320);
            }
            this.loadNextByte();
            return true;
        }
        this.fCurrentChunk = uTF8DataChunk;
        this.fCurrentIndex = n3;
        this.fCurrentOffset = n2;
        this.fMostRecentData = uTF8DataChunk.toByteArray();
        this.fMostRecentByte = n;
        return false;
    }

    private boolean skipMultiByteCharData(int n) throws Exception {
        UTF8DataChunk uTF8DataChunk = this.fCurrentChunk;
        int n2 = this.fCurrentOffset;
        int n3 = this.fCurrentIndex;
        int n4 = this.loadNextByte();
        if ((0xE0 & n) == 192) {
            this.loadNextByte();
            return true;
        }
        int n5 = this.loadNextByte();
        if ((0xF0 & n) == 224) {
            if (n == 237 && n4 >= 160 || n == 239 && n4 == 191 && n5 >= 190) {
                this.fCurrentChunk = uTF8DataChunk;
                this.fCurrentIndex = n3;
                this.fCurrentOffset = n2;
                this.fMostRecentData = uTF8DataChunk.toByteArray();
                this.fMostRecentByte = n;
                return false;
            }
            this.loadNextByte();
            return true;
        }
        int n6 = this.loadNextByte();
        if (n > 244 || n == 244 && n4 >= 144) {
            this.fCurrentChunk = uTF8DataChunk;
            this.fCurrentIndex = n3;
            this.fCurrentOffset = n2;
            this.fMostRecentData = uTF8DataChunk.toByteArray();
            this.fMostRecentByte = n;
            return false;
        }
        this.loadNextByte();
        return true;
    }

    private int copyAsciiCharData() throws Exception {
        int n = this.fCurrentIndex;
        int n2 = this.fCurrentOffset - n;
        byte[] byArray = this.fMostRecentData;
        int n3 = this.fCharDataLength;
        boolean bl = false;
        while (true) {
            int n4;
            try {
                n4 = byArray[n] & 0xFF;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                n2 += n;
                this.slowLoadNextByte();
                n = 0;
                byArray = this.fMostRecentData;
                n4 = byArray[n] & 0xFF;
            }
            if (n4 >= 128) {
                this.fCurrentOffset = n2 + n;
                this.fCurrentIndex = n;
                this.fMostRecentByte = n4;
                return n4;
            }
            if (XMLCharacterProperties.fgAsciiCharData[n4] == 0) {
                ++this.fCharacterCounter;
                bl = false;
            } else if (n4 == 10) {
                ++this.fLinefeedCounter;
                if (bl) {
                    bl = false;
                    ++n;
                    continue;
                }
                this.fCharacterCounter = 1;
            } else if (n4 == 13) {
                ++this.fCarriageReturnCounter;
                this.fCharacterCounter = 1;
                bl = true;
                n4 = 10;
            } else {
                this.fCurrentOffset = n2 + n;
                this.fCurrentIndex = n;
                this.fMostRecentByte = n4;
                return n4;
            }
            ++n;
            try {
                this.fCharacters[this.fCharDataLength] = (char)n4;
                ++this.fCharDataLength;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.slowAppendCharData(n4);
                continue;
            }
            break;
        }
    }

    private int skipAsciiCharData() throws Exception {
        int n = this.fCurrentIndex;
        int n2 = this.fCurrentOffset - n;
        byte[] byArray = this.fMostRecentData;
        while (true) {
            int n3;
            try {
                n3 = byArray[n] & 0xFF;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                n2 += n;
                this.slowLoadNextByte();
                n = 0;
                byArray = this.fMostRecentData;
                n3 = byArray[n] & 0xFF;
            }
            if (n3 >= 128) {
                this.fCurrentOffset = n2 + n;
                this.fCurrentIndex = n;
                this.fMostRecentByte = n3;
                return n3;
            }
            if (XMLCharacterProperties.fgAsciiCharData[n3] == 0) {
                ++this.fCharacterCounter;
            } else if (n3 == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
            } else if (n3 == 13) {
                ++this.fCarriageReturnCounter;
                this.fCharacterCounter = 1;
            } else {
                this.fCurrentOffset = n2 + n;
                this.fCurrentIndex = n;
                this.fMostRecentByte = n3;
                return n3;
            }
            ++n;
        }
    }

    private void appendCharData(int n) throws Exception {
        try {
            this.fCharacters[this.fCharDataLength] = (char)n;
            ++this.fCharDataLength;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.slowAppendCharData(n);
        }
    }

    private void slowAppendCharData(int n) throws Exception {
        this.characters(0, this.fCharDataLength);
        this.fCharDataLength = 0;
        this.fCharacters[this.fCharDataLength++] = (char)n;
    }

    private void characters(int n, int n2) throws Exception {
        if (!this.fSendCharDataAsCharArray) {
            int n3 = this.addString(n, n2 - n);
            this.fCharDataHandler.processCharacters(n3);
            return;
        }
        this.fCharDataHandler.processCharacters(this.fCharacters, 0, this.fCharDataLength);
    }

    private void whitespace(int n, int n2) throws Exception {
        if (!this.fSendCharDataAsCharArray) {
            int n3 = this.addString(n, n2 - n);
            this.fCharDataHandler.processWhitespace(n3);
            return;
        }
        this.fCharDataHandler.processWhitespace(this.fCharacters, 0, this.fCharDataLength);
    }

    private int fillCurrentChunk() throws Exception {
        byte[] byArray = this.fCurrentChunk.toByteArray();
        if (this.fInputStream == null) {
            if (byArray == null) {
                byArray = new byte[]{0};
            }
            this.fMostRecentData = byArray;
            this.fCurrentIndex = 0;
            this.fCurrentChunk.setByteArray(this.fMostRecentData);
            this.fMostRecentByte = this.fMostRecentData[0] & 0xFF;
            return this.fMostRecentByte;
        }
        if (byArray == null) {
            byArray = new byte[16384];
        }
        int n = 0;
        int n2 = 16384;
        int n3 = 0;
        do {
            try {
                n3 = this.fInputStream.read(byArray, n, n2);
            }
            catch (IOException iOException) {
                n3 = -1;
            }
            if (n3 == -1) {
                this.fInputStream.close();
                this.fInputStream = null;
                try {
                    byArray[n] = 0;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                break;
            }
            if (n3 <= 0) continue;
            n += n3;
            n2 -= n3;
        } while (n2 > 0);
        this.fMostRecentData = byArray;
        this.fLength += n;
        this.fCurrentIndex = 0;
        this.fCurrentChunk.setByteArray(this.fMostRecentData);
        this.fMostRecentByte = this.fMostRecentData[0] & 0xFF;
        return this.fMostRecentByte;
    }
}

