/*
 * Decompiled with CFR 0.152.
 */
package org.drools.xml;

import java.util.HashSet;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.xml.BaseAbstractHandler;
import org.drools.xml.Configuration;
import org.drools.xml.Handler;
import org.drools.xml.XmlPackageReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class LhsHandler
extends BaseAbstractHandler
implements Handler {
    LhsHandler(XmlPackageReader xmlPackageReader) {
        this.xmlPackageReader = xmlPackageReader;
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(PackageDescr.class);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.validPeers.add(FunctionDescr.class);
            this.validPeers.add(RuleDescr.class);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs) throws SAXException {
        this.xmlPackageReader.startConfiguration(localName, attrs);
        return null;
    }

    public Object end(String uri, String localName) throws SAXException {
        Configuration config = this.xmlPackageReader.endConfiguration();
        String name = config.getAttribute("name");
        if (name == null || name.trim().equals("")) {
            throw new SAXParseException("<function> requires a 'name' attribute", this.xmlPackageReader.getLocator());
        }
        String returnType = config.getAttribute("return-type");
        if (returnType == null || returnType.trim().equals("")) {
            throw new SAXParseException("<function> requires a 'return-type' attribute", this.xmlPackageReader.getLocator());
        }
        FunctionDescr functionDescr = new FunctionDescr(name, returnType);
        Configuration[] parameters = config.getChildren("parameter");
        int length = parameters.length;
        for (int i = 0; i < length; ++i) {
            String identifier = parameters[i].getAttribute("identifier");
            if (name == null || identifier.trim().equals("")) {
                throw new SAXParseException("function's <parameter> requires an 'identifier' attribute", this.xmlPackageReader.getLocator());
            }
            String type = parameters[i].getText();
            if (type == null || type.trim().equals("")) {
                throw new SAXParseException("function's <parameter> must specify a 'type'", this.xmlPackageReader.getLocator());
            }
            functionDescr.addParameter(type, identifier);
        }
        Configuration body = config.getChild("body");
        if (body == null) {
            throw new SAXParseException("function must have a <body>", this.xmlPackageReader.getLocator());
        }
        functionDescr.setText(body.getText());
        PackageDescr packageDescr = this.xmlPackageReader.getPackageDescr();
        packageDescr.addFunction(functionDescr);
        return functionDescr;
    }

    public Class generateNodeFor() {
        return FunctionDescr.class;
    }
}

