/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import [Ljava.lang.Object;;
import java.lang.reflect.Array;
import java.util.Arrays;

public class ArrayUtils {
    public static final int INDEX_NOT_FOUND = -1;

    public static boolean contains(Object[] array, Object objectToFind) {
        return ArrayUtils.indexOf(array, objectToFind) != -1;
    }

    public static int indexOf(Object[] array, Object objectToFind) {
        return ArrayUtils.indexOf(array, objectToFind, 0);
    }

    public static int indexOf(Object[] array, Object objectToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (objectToFind == null) {
            for (int i = startIndex; i < array.length; ++i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = startIndex; i < array.length; ++i) {
                if (!objectToFind.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static int hashCode(Object[] array) {
        int PRIME = 31;
        if (array == null) {
            return 0;
        }
        int result = 1;
        for (int index = 0; index < array.length; ++index) {
            result = 31 * result + (array[index] == null ? 0 : array[index].hashCode());
        }
        return result;
    }

    public static Object[] copyOf(Object[] original, int newLength, Class newType) {
        Object[] arr = newType == Object;.class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        int len = original.length < newLength ? original.length : newLength;
        System.arraycopy(original, 0, arr, 0, len);
        return arr;
    }

    public static boolean deepEquals(Object[] a1, Object[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        int len = a1.length;
        if (len != a2.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            boolean eq;
            Object e1 = a1[i];
            Object e2 = a2[i];
            if (e1 == e2) continue;
            if (e1 == null) {
                return false;
            }
            boolean bl = e1.getClass() != e2.getClass() || !e1.getClass().isArray() || !e2.getClass().isArray() ? e1.equals(e2) : (e1 instanceof Object[] && e2 instanceof Object[] ? ArrayUtils.deepEquals((Object[])e1, (Object[])e2) : (e1 instanceof byte[] && e2 instanceof byte[] ? ArrayUtils.equals((byte[])e1, (byte[])e2) : (e1 instanceof short[] && e2 instanceof short[] ? ArrayUtils.equals((short[])e1, (short[])e2) : (e1 instanceof int[] && e2 instanceof int[] ? ArrayUtils.equals((int[])e1, (int[])e2) : (e1 instanceof long[] && e2 instanceof long[] ? ArrayUtils.equals((long[])e1, (long[])e2) : (e1 instanceof char[] && e2 instanceof char[] ? ArrayUtils.equals((char[])e1, (char[])e2) : (e1 instanceof boolean[] && e2 instanceof boolean[] ? ArrayUtils.equals((boolean[])e1, (boolean[])e2) : (e1 instanceof float[] && e2 instanceof float[] ? ArrayUtils.equals((float[])e1, (float[])e2) : (eq = e1 instanceof double[] && e2 instanceof double[] ? ArrayUtils.equals((double[])e1, (double[])e2) : e1.equals(e2))))))))));
            if (eq) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(long[] a, long[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean equals(int[] a, int[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean equals(short[] a, short[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean equals(char[] a, char[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean equals(byte[] a, byte[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean equals(boolean[] a, boolean[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean equals(double[] a, double[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean equals(float[] a, float[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean equals(Object[] a, Object[] a2) {
        return Arrays.equals(a, a2);
    }
}

