/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.rule.ConditionalElement;
import org.drools.rule.Declaration;
import org.drools.rule.RuleConditionElement;

public class GroupElement
extends ConditionalElement {
    private static final long serialVersionUID = 400L;
    public static final Type AND = new AndType();
    public static final Type OR = new OrType();
    public static final Type EXISTS = new ExistsType();
    public static final Type NOT = new NotType();
    private Type type = null;
    private final List children = new ArrayList();

    public GroupElement() {
        this(AND);
    }

    public GroupElement(Type type) {
        this.type = type;
    }

    public void addChild(RuleConditionElement child) {
        if ((this.isNot() || this.isExists()) && this.children.size() > 0) {
            throw new RuntimeDroolsException(this.type.toString() + " can have only a single child element. Either a single Pattern or another CE.");
        }
        this.children.add(child);
    }

    public void addChild(int index, RuleConditionElement rce) {
        this.children.add(index, rce);
    }

    public List getChildren() {
        return this.children;
    }

    public Map getInnerDeclarations() {
        return this.type.getInnerDeclarations(this.children);
    }

    public Map getOuterDeclarations() {
        return this.type.getOuterDeclarations(this.children);
    }

    public Declaration resolveDeclaration(String identifier) {
        return (Declaration)this.type.getInnerDeclarations(this.children).get(identifier);
    }

    public void pack() {
        Object child;
        Object[] clone = this.children.toArray();
        for (int i = 0; i < clone.length; ++i) {
            if (!(clone[i] instanceof GroupElement)) continue;
            GroupElement childGroup = (GroupElement)clone[i];
            childGroup.pack(this);
        }
        if ((this.isAnd() || this.isOr()) && this.children.size() == 1 && (child = this.getChildren().get(0)) instanceof GroupElement) {
            GroupElement group = (GroupElement)child;
            this.type = group.getType();
            this.children.clear();
            this.children.addAll(group.getChildren());
        }
    }

    public void pack(GroupElement parent) {
        if (this.children.size() == 0) {
            parent.children.remove(this);
            return;
        }
        if (this.isAnd() || this.isOr() || this.isExists()) {
            if (parent.getType() == this.getType()) {
                int index = parent.getChildren().indexOf(this);
                parent.getChildren().remove(this);
                Iterator childIt = this.children.iterator();
                while (childIt.hasNext()) {
                    Object child = childIt.next();
                    parent.getChildren().add(index++, child);
                    if (!(child instanceof GroupElement)) continue;
                    int previousSize = parent.getChildren().size();
                    ((GroupElement)child).pack(parent);
                    index += parent.getChildren().size() - previousSize;
                }
            } else if (!this.isExists() && this.children.size() == 1) {
                int index = parent.getChildren().indexOf(this);
                parent.getChildren().remove(this);
                Object child = this.children.get(0);
                parent.getChildren().add(index, child);
                if (child instanceof GroupElement) {
                    ((GroupElement)child).pack(parent);
                }
            } else {
                this.pack();
            }
        } else {
            this.pack();
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof GroupElement)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        GroupElement e2 = (GroupElement)object;
        if (!this.type.equals(e2.type)) {
            return false;
        }
        List e1Children = this.getChildren();
        List e2Children = e2.getChildren();
        if (e1Children.size() != e2Children.size()) {
            return false;
        }
        for (int i = 0; i < e1Children.size(); ++i) {
            Object e2Object1;
            Object e1Object1 = e1Children.get(i);
            if (e1Object1.equals(e2Object1 = e2Children.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.type.hashCode() + ((Object)this.children).hashCode();
    }

    public Object clone() {
        GroupElement cloned = null;
        try {
            cloned = (GroupElement)this.getClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Could not clone '" + this.getClass().getName() + "'");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not clone '" + this.getClass().getName() + "'");
        }
        cloned.setType(this.getType());
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            RuleConditionElement re = (RuleConditionElement)it.next();
            if (re instanceof GroupElement) {
                re = (RuleConditionElement)((GroupElement)re).clone();
            }
            cloned.addChild(re);
        }
        return cloned;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean isAnd() {
        return this.type.isAnd();
    }

    public boolean isOr() {
        return this.type.isOr();
    }

    public boolean isNot() {
        return this.type.isNot();
    }

    public boolean isExists() {
        return this.type.isExists();
    }

    public String toString() {
        return this.type.toString() + this.children.toString();
    }

    public List getNestedElements() {
        return this.children;
    }

    private static class ExistsType
    extends AbstractType {
        private static final long serialVersionUID = 400L;

        ExistsType() {
        }

        public boolean isAnd() {
            return false;
        }

        public boolean isExists() {
            return true;
        }

        public boolean isNot() {
            return false;
        }

        public boolean isOr() {
            return false;
        }

        public Map getOuterDeclarations(List children) {
            return Collections.EMPTY_MAP;
        }

        public boolean equals(Object obj) {
            return obj instanceof ExistsType;
        }

        public int hashCode() {
            return 31;
        }

        public String toString() {
            return "EXISTS";
        }
    }

    private static class NotType
    extends AbstractType {
        private static final long serialVersionUID = 400L;

        NotType() {
        }

        public boolean isAnd() {
            return false;
        }

        public boolean isExists() {
            return false;
        }

        public boolean isNot() {
            return true;
        }

        public boolean isOr() {
            return false;
        }

        public Map getOuterDeclarations(List children) {
            return Collections.EMPTY_MAP;
        }

        public boolean equals(Object obj) {
            return obj instanceof NotType;
        }

        public int hashCode() {
            return 23;
        }

        public String toString() {
            return "NOT";
        }
    }

    private static class OrType
    extends AbstractType {
        private static final long serialVersionUID = 400L;

        OrType() {
        }

        public boolean isAnd() {
            return false;
        }

        public boolean isExists() {
            return false;
        }

        public boolean isNot() {
            return false;
        }

        public boolean isOr() {
            return true;
        }

        public boolean equals(Object obj) {
            return obj instanceof OrType;
        }

        public int hashCode() {
            return 17;
        }

        public String toString() {
            return "OR";
        }
    }

    private static class AndType
    extends AbstractType {
        private static final long serialVersionUID = 400L;

        AndType() {
        }

        public boolean isAnd() {
            return true;
        }

        public boolean isExists() {
            return false;
        }

        public boolean isNot() {
            return false;
        }

        public boolean isOr() {
            return false;
        }

        public boolean equals(Object obj) {
            return obj instanceof AndType;
        }

        public int hashCode() {
            return 11;
        }

        public String toString() {
            return "AND";
        }
    }

    private static abstract class AbstractType
    implements Type {
        private static final long serialVersionUID = 400L;

        private AbstractType() {
        }

        public Map getInnerDeclarations(List children) {
            Map declarations = null;
            if (children.isEmpty()) {
                declarations = Collections.EMPTY_MAP;
            } else if (children.size() == 1) {
                RuleConditionElement re = (RuleConditionElement)children.get(0);
                declarations = re.getOuterDeclarations();
            } else {
                declarations = new HashMap();
                Iterator it = children.iterator();
                while (it.hasNext()) {
                    declarations.putAll(((RuleConditionElement)it.next()).getOuterDeclarations());
                }
            }
            return declarations;
        }

        public Map getOuterDeclarations(List children) {
            Map declarations = null;
            if (children.isEmpty()) {
                declarations = Collections.EMPTY_MAP;
            } else if (children.size() == 1) {
                RuleConditionElement re = (RuleConditionElement)children.get(0);
                declarations = re.getOuterDeclarations();
            } else {
                declarations = new HashMap();
                Iterator it = children.iterator();
                while (it.hasNext()) {
                    declarations.putAll(((RuleConditionElement)it.next()).getOuterDeclarations());
                }
            }
            return declarations;
        }
    }

    public static interface Type
    extends Serializable {
        public boolean isAnd();

        public boolean isOr();

        public boolean isNot();

        public boolean isExists();

        public Map getInnerDeclarations(List var1);

        public Map getOuterDeclarations(List var1);
    }
}

