/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.common.BaseNode;
import org.drools.common.BetaConstraints;
import org.drools.common.DefaultBetaConstraints;
import org.drools.common.DoubleBetaConstraints;
import org.drools.common.EmptyBetaConstraints;
import org.drools.common.QuadroupleBetaConstraints;
import org.drools.common.SingleBetaConstraints;
import org.drools.common.TripleBetaConstraints;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSource;
import org.drools.reteoo.builder.BuildContext;
import org.drools.reteoo.builder.ReteooComponentBuilder;
import org.drools.rule.Declaration;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.RuleConditionElement;
import org.drools.spi.BetaNodeFieldConstraint;

public class BuildUtils {
    private final Map componentBuilders = new HashMap();

    public void addBuilder(Class target, ReteooComponentBuilder builder) {
        this.componentBuilders.put(target, builder);
    }

    public ReteooComponentBuilder getBuilderFor(RuleConditionElement target) {
        return (ReteooComponentBuilder)this.componentBuilders.get(target.getClass());
    }

    public BaseNode attachNode(BuildContext context, BaseNode candidate) {
        BaseNode node = null;
        if (candidate instanceof ObjectTypeNode) {
            ObjectTypeNode otn = (ObjectTypeNode)candidate;
            otn = (ObjectTypeNode)context.getRuleBase().getRete().getObjectTypeNodes().get(otn.getObjectType());
            if (otn != null) {
                node = otn;
            }
        } else if (this.isSharingEnabledForNode(context, candidate)) {
            if (context.getTupleSource() != null && candidate instanceof TupleSink) {
                TupleSink[] sinks = context.getTupleSource().getSinkPropagator().getSinks();
                for (int i = 0; i < sinks.length; ++i) {
                    if (!candidate.equals(sinks[i])) continue;
                    node = (BaseNode)((Object)sinks[i]);
                    break;
                }
            } else if (context.getObjectSource() != null && candidate instanceof ObjectSink) {
                ObjectSink[] sinks = context.getObjectSource().getSinkPropagator().getSinks();
                for (int i = 0; i < sinks.length; ++i) {
                    if (!candidate.equals(sinks[i])) continue;
                    node = (BaseNode)((Object)sinks[i]);
                    break;
                }
            } else {
                throw new RuntimeDroolsException("This is a bug on node sharing verification. Please report to development team.");
            }
            if (node != null) {
                context.releaseId();
            }
        }
        if (node == null) {
            node = candidate;
            if (context.getWorkingMemories().length == 0) {
                node.attach();
            } else {
                node.attach(context.getWorkingMemories());
            }
        }
        return node;
    }

    private boolean isSharingEnabledForNode(BuildContext context, BaseNode node) {
        if (node instanceof TupleSource) {
            return context.getRuleBase().getConfiguration().isShareBetaNodes();
        }
        if (node instanceof ObjectSource) {
            return context.getRuleBase().getConfiguration().isShareAlphaNodes();
        }
        return false;
    }

    public BetaConstraints createBetaNodeConstraint(BuildContext context, List list, boolean disableIndexing) {
        BetaConstraints constraints;
        switch (list.size()) {
            case 0: {
                constraints = EmptyBetaConstraints.getInstance();
                break;
            }
            case 1: {
                constraints = new SingleBetaConstraints((BetaNodeFieldConstraint)list.get(0), context.getRuleBase().getConfiguration(), disableIndexing);
                break;
            }
            case 2: {
                constraints = new DoubleBetaConstraints(list.toArray(new BetaNodeFieldConstraint[list.size()]), context.getRuleBase().getConfiguration(), disableIndexing);
                break;
            }
            case 3: {
                constraints = new TripleBetaConstraints(list.toArray(new BetaNodeFieldConstraint[list.size()]), context.getRuleBase().getConfiguration(), disableIndexing);
                break;
            }
            case 4: {
                constraints = new QuadroupleBetaConstraints(list.toArray(new BetaNodeFieldConstraint[list.size()]), context.getRuleBase().getConfiguration(), disableIndexing);
                break;
            }
            default: {
                constraints = new DefaultBetaConstraints(list.toArray(new BetaNodeFieldConstraint[list.size()]), context.getRuleBase().getConfiguration(), disableIndexing);
            }
        }
        return constraints;
    }

    public void checkUnboundDeclarations(BuildContext context, Declaration[] declarations) throws InvalidPatternException {
        ArrayList<String> list = new ArrayList<String>();
        int length = declarations.length;
        for (int i = 0; i < length; ++i) {
            ListIterator it = context.stackIterator();
            while (it.hasPrevious()) {
                RuleConditionElement rce = (RuleConditionElement)it.previous();
                Declaration decl = rce.resolveDeclaration(declarations[i].getIdentifier());
                if (decl != null && decl.getPattern().getOffset() <= declarations[i].getPattern().getOffset()) continue;
                list.add(declarations[i].getIdentifier());
            }
        }
        if (list.size() != 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(list.get(0));
            int size = list.size();
            for (int i = 1; i < size; ++i) {
                buffer.append(", " + list.get(i));
            }
            throw new InvalidPatternException("Required Declarations not bound: '" + buffer);
        }
    }
}

