/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.util;

public abstract class ByteUtil {
    public static String toString(byte[] bytes) {
        if (bytes == null) {
            return "null";
        }
        if (bytes.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            buf.append(ByteUtil.toHexChar(b >>> 4 & 0xF));
            buf.append(ByteUtil.toHexChar(b & 0xF));
        }
        return buf.toString();
    }

    public static char toHexChar(int i) {
        if (0 <= i && i <= 9) {
            return (char)(48 + i);
        }
        return (char)(97 + (i - 10));
    }

    public static byte[] fromString(String hexString) {
        if (hexString == null) {
            return null;
        }
        if (hexString.length() % 2 != 0) {
            throw new IllegalArgumentException("invalid hex string: odd number of hex digits");
        }
        int byteArraySize = hexString.length() / 2;
        byte[] bytes = new byte[byteArraySize];
        for (int i = 0; i < bytes.length; ++i) {
            int stringIndex = i * 2;
            String byteString = hexString.substring(stringIndex, stringIndex + 2);
            bytes[i] = (byte)Integer.parseInt(byteString, 16);
        }
        return bytes;
    }
}

