/*
 * Decompiled with CFR 0.152.
 */
package org.drools.spi;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.drools.rule.Declaration;
import org.drools.rule.GroupElement;
import org.drools.rule.Pattern;
import org.drools.rule.RuleConditionElement;
import org.drools.spi.GlobalExtractor;

public class DeclarationScopeResolver {
    private static final Stack EMPTY_STACK = new Stack();
    private Map[] maps;
    private Stack buildStack;

    public DeclarationScopeResolver(Map[] maps) {
        this(maps, EMPTY_STACK);
    }

    public DeclarationScopeResolver(Map[] maps, Stack buildStack) {
        this.maps = maps;
        this.buildStack = buildStack == null ? EMPTY_STACK : buildStack;
    }

    public Class getType(String name) {
        int i;
        for (i = this.buildStack.size() - 1; i >= 0; --i) {
            Declaration declaration = (Declaration)((RuleConditionElement)this.buildStack.get(i)).getInnerDeclarations().get(name);
            if (declaration == null) continue;
            return declaration.getExtractor().getExtractToClass();
        }
        int length = this.maps.length;
        for (i = 0; i < length; ++i) {
            Object object = this.maps[i].get(name);
            if (object == null) continue;
            if (object instanceof Declaration) {
                return ((Declaration)object).getExtractor().getExtractToClass();
            }
            return (Class)object;
        }
        return null;
    }

    public Declaration getDeclaration(String name) {
        int i;
        for (i = this.buildStack.size() - 1; i >= 0; --i) {
            Declaration declaration = (Declaration)((RuleConditionElement)this.buildStack.get(i)).getInnerDeclarations().get(name);
            if (declaration == null) continue;
            return declaration;
        }
        int length = this.maps.length;
        for (i = 0; i < length; ++i) {
            if (!this.maps[i].containsKey(name)) continue;
            GlobalExtractor global = new GlobalExtractor(name, this.maps[i]);
            Pattern dummy = new Pattern(0, global.getObjectType());
            Declaration declaration = new Declaration(name, global, dummy);
            return declaration;
        }
        return null;
    }

    public boolean available(String name) {
        int i;
        for (i = this.buildStack.size() - 1; i >= 0; --i) {
            Declaration declaration = (Declaration)((RuleConditionElement)this.buildStack.get(i)).getInnerDeclarations().get(name);
            if (declaration == null) continue;
            return true;
        }
        int length = this.maps.length;
        for (i = 0; i < length; ++i) {
            if (!this.maps[i].containsKey(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isDuplicated(String name) {
        int i;
        int length = this.maps.length;
        for (i = 0; i < length; ++i) {
            if (!this.maps[i].containsKey(name)) continue;
            return true;
        }
        for (i = this.buildStack.size() - 1; i >= 0; --i) {
            RuleConditionElement rce = (RuleConditionElement)this.buildStack.get(i);
            Declaration declaration = (Declaration)rce.getInnerDeclarations().get(name);
            if (declaration == null) continue;
            return !(rce instanceof GroupElement) || !((GroupElement)rce).isOr();
        }
        return false;
    }

    public Map getDeclarations() {
        HashMap declarations = new HashMap();
        for (int i = 0; i < this.buildStack.size(); ++i) {
            declarations.putAll(((RuleConditionElement)this.buildStack.get(i)).getInnerDeclarations());
        }
        return declarations;
    }
}

